/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.connection;

import com.zoyi.io.socket.okhttp3.Address;
import com.zoyi.io.socket.okhttp3.CertificatePinner;
import com.zoyi.io.socket.okhttp3.Connection;
import com.zoyi.io.socket.okhttp3.ConnectionSpec;
import com.zoyi.io.socket.okhttp3.Handshake;
import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Request$Builder;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.Route;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.Version;
import com.zoyi.io.socket.okhttp3.internal.connection.ConnectionSpecSelector;
import com.zoyi.io.socket.okhttp3.internal.connection.RouteException;
import com.zoyi.io.socket.okhttp3.internal.connection.StreamAllocation;
import com.zoyi.io.socket.okhttp3.internal.http.HttpHeaders;
import com.zoyi.io.socket.okhttp3.internal.http1.Http1Codec;
import com.zoyi.io.socket.okhttp3.internal.http2.ErrorCode;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$Builder;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$Listener;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Stream;
import com.zoyi.io.socket.okhttp3.internal.platform.Platform;
import com.zoyi.io.socket.okhttp3.internal.tls.OkHostnameVerifier;
import com.zoyi.io.socket.okio.BufferedSink;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.Okio;
import com.zoyi.io.socket.okio.Source;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class RealConnection
extends Http2Connection$Listener
implements Connection {
    private final Route route;
    private Socket rawSocket;
    public Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    public volatile Http2Connection http2Connection;
    public int successCount;
    public BufferedSource source;
    public BufferedSink sink;
    public int allocationLimit;
    public final List<Reference<StreamAllocation>> allocations = new ArrayList<Reference<StreamAllocation>>();
    public boolean noNewStreams;
    public long idleAtNanos = Long.MAX_VALUE;

    public RealConnection(Route route) {
        this.route = route;
    }

    public final void connect(int n2, int n3, int n4, List<ConnectionSpec> object, boolean bl) {
        if (this.protocol != null) {
            throw new IllegalStateException("already connected");
        }
        RouteException routeException = null;
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector((List<ConnectionSpec>)object);
        if (this.route.address().sslSocketFactory() == null) {
            if (!object.contains(ConnectionSpec.CLEARTEXT)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication not enabled for client"));
            }
            object = this.route.address().url().host();
            if (!Platform.get().isCleartextTrafficPermitted((String)object)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication to " + (String)object + " not permitted by network security policy"));
            }
        }
        while (this.protocol == null) {
            try {
                if (this.route.requiresTunnel()) {
                    this.buildTunneledConnection(n2, n3, n4, connectionSpecSelector);
                    continue;
                }
                this.buildConnection(n2, n3, n4, connectionSpecSelector);
            }
            catch (IOException iOException) {
                Util.closeQuietly(this.socket);
                Util.closeQuietly(this.rawSocket);
                this.socket = null;
                this.rawSocket = null;
                this.source = null;
                this.sink = null;
                this.handshake = null;
                this.protocol = null;
                if (routeException == null) {
                    routeException = new RouteException(iOException);
                } else {
                    routeException.addConnectException(iOException);
                }
                if (bl && connectionSpecSelector.connectionFailed(iOException)) continue;
                throw routeException;
            }
        }
    }

    private void buildTunneledConnection(int n2, int n3, int n4, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        Request request = this.createTunnelRequest();
        HttpUrl httpUrl = request.url();
        int n5 = 0;
        while (true) {
            if (++n5 > 21) {
                throw new ProtocolException("Too many tunnel connections attempted: " + 21);
            }
            this.connectSocket(n2, n3);
            request = this.createTunnel(n3, n4, request, httpUrl);
            if (request == null) break;
            Util.closeQuietly(this.rawSocket);
            this.rawSocket = null;
            this.sink = null;
            this.source = null;
        }
        this.establishProtocol(n3, n4, connectionSpecSelector);
    }

    private void buildConnection(int n2, int n3, int n4, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        this.connectSocket(n2, n3);
        this.establishProtocol(n3, n4, connectionSpecSelector);
    }

    private void connectSocket(int n2, int n3) throws IOException {
        Proxy proxy = this.route.proxy();
        Address address = this.route.address();
        this.rawSocket = proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP ? address.socketFactory().createSocket() : new Socket(proxy);
        this.rawSocket.setSoTimeout(n3);
        try {
            Platform.get().connectSocket(this.rawSocket, this.route.socketAddress(), n2);
        }
        catch (ConnectException connectException) {
            ConnectException connectException2 = new ConnectException("Failed to connect to " + this.route.socketAddress());
            connectException2.initCause(connectException);
            throw connectException2;
        }
        this.source = Okio.buffer(Okio.source(this.rawSocket));
        this.sink = Okio.buffer(Okio.sink(this.rawSocket));
    }

    private void establishProtocol(int n2, int n3, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        if (this.route.address().sslSocketFactory() != null) {
            this.connectTls(n2, n3, connectionSpecSelector);
        } else {
            this.protocol = Protocol.HTTP_1_1;
            this.socket = this.rawSocket;
        }
        if (this.protocol == Protocol.HTTP_2) {
            this.socket.setSoTimeout(0);
            Http2Connection http2Connection = new Http2Connection$Builder(true).socket(this.socket, this.route.address().url().host(), this.source, this.sink).listener(this).build();
            http2Connection.start();
            this.allocationLimit = http2Connection.maxConcurrentStreams();
            this.http2Connection = http2Connection;
            return;
        }
        this.allocationLimit = 1;
    }

    private void connectTls(int n2, int n3, ConnectionSpecSelector object) throws IOException {
        Address address = this.route.address();
        Object object2 = address.sslSocketFactory();
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)((SSLSocketFactory)object2).createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
            object2 = ((ConnectionSpecSelector)object).configureSecureSocket(sSLSocket);
            if (((ConnectionSpec)object2).supportsTlsExtensions()) {
                Platform.get().configureTlsExtensions(sSLSocket, address.url().host(), address.protocols());
            }
            sSLSocket.startHandshake();
            object = Handshake.get(sSLSocket.getSession());
            if (!address.hostnameVerifier().verify(address.url().host(), sSLSocket.getSession())) {
                object2 = (X509Certificate)((Handshake)object).peerCertificates().get(0);
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified:\n    certificate: " + CertificatePinner.pin((Certificate)object2) + "\n    DN: " + ((X509Certificate)object2).getSubjectDN().getName() + "\n    subjectAltNames: " + OkHostnameVerifier.allSubjectAltNames((X509Certificate)object2));
            }
            address.certificatePinner().check(address.url().host(), ((Handshake)object).peerCertificates());
            object2 = ((ConnectionSpec)object2).supportsTlsExtensions() ? Platform.get().getSelectedProtocol(sSLSocket) : null;
            this.socket = sSLSocket;
            this.source = Okio.buffer(Okio.source(this.socket));
            this.sink = Okio.buffer(Okio.sink(this.socket));
            this.handshake = object;
            Protocol protocol = this.protocol = object2 != null ? Protocol.get((String)object2) : Protocol.HTTP_1_1;
            if (sSLSocket != null) {
                Platform.get().afterHandshake(sSLSocket);
            }
            return;
        }
        catch (AssertionError assertionError) {
            try {
                object2 = assertionError;
                if (Util.isAndroidGetsocknameError(assertionError)) {
                    throw new IOException((Throwable)object2);
                }
                throw object2;
            }
            catch (Throwable throwable) {
                if (sSLSocket != null) {
                    Platform.get().afterHandshake(sSLSocket);
                }
                Util.closeQuietly(sSLSocket);
                throw throwable;
            }
        }
    }

    private Request createTunnel(int n2, int n3, Request object, HttpUrl object2) throws IOException {
        Response response;
        object2 = "CONNECT " + Util.hostHeader((HttpUrl)object2, true) + " HTTP/1.1";
        block4: while (true) {
            Http1Codec http1Codec = new Http1Codec(null, null, this.source, this.sink);
            this.source.timeout().timeout(n2, TimeUnit.MILLISECONDS);
            this.sink.timeout().timeout(n3, TimeUnit.MILLISECONDS);
            http1Codec.writeRequest(((Request)object).headers(), (String)object2);
            http1Codec.finishRequest();
            response = http1Codec.readResponse().request((Request)object).build();
            long l2 = HttpHeaders.contentLength(response);
            if (l2 == -1L) {
                l2 = 0L;
            }
            object = http1Codec.newFixedLengthSource(l2);
            Util.skipAll((Source)object, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            object.close();
            switch (response.code()) {
                case 200: {
                    if (!this.source.buffer().exhausted() || !this.sink.buffer().exhausted()) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    return null;
                }
                case 407: {
                    object = this.route.address().proxyAuthenticator().authenticate(this.route, response);
                    if (object != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                    if (!"close".equalsIgnoreCase(response.header("Connection"))) continue block4;
                    return object;
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    private Request createTunnelRequest() {
        return new Request$Builder().url(this.route.address().url()).header("Host", Util.hostHeader(this.route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", Version.userAgent()).build();
    }

    @Override
    public final Route route() {
        return this.route;
    }

    public final void cancel() {
        Util.closeQuietly(this.rawSocket);
    }

    @Override
    public final Socket socket() {
        return this.socket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isHealthy(boolean bl) {
        if (this.socket.isClosed()) return false;
        if (this.socket.isInputShutdown()) return false;
        if (this.socket.isOutputShutdown()) {
            return false;
        }
        if (this.http2Connection != null) {
            if (this.http2Connection.isShutdown()) return false;
            return true;
        }
        if (!bl) return true;
        try {
            int n2 = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(1);
                if (!this.source.exhausted()) return true;
                return false;
            }
            finally {
                this.socket.setSoTimeout(n2);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public final void onStream(Http2Stream http2Stream) throws IOException {
        http2Stream.close(ErrorCode.REFUSED_STREAM);
    }

    @Override
    public final void onSettings(Http2Connection http2Connection) {
        this.allocationLimit = http2Connection.maxConcurrentStreams();
    }

    @Override
    public final Handshake handshake() {
        return this.handshake;
    }

    public final boolean isMultiplexed() {
        return this.http2Connection != null;
    }

    @Override
    public final Protocol protocol() {
        if (this.http2Connection == null) {
            if (this.protocol != null) {
                return this.protocol;
            }
            return Protocol.HTTP_1_1;
        }
        return Protocol.HTTP_2;
    }

    public final String toString() {
        return "Connection{" + this.route.address().url().host() + ":" + this.route.address().url().port() + ", proxy=" + this.route.proxy() + " hostAddress=" + this.route.socketAddress() + " cipherSuite=" + (this.handshake != null ? this.handshake.cipherSuite() : "none") + " protocol=" + (Object)((Object)this.protocol) + '}';
    }
}

