/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.cache;

import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.ForwardingSink;
import com.zoyi.io.socket.okio.Sink;
import java.io.IOException;

class FaultHidingSink
extends ForwardingSink {
    private boolean hasErrors;

    public FaultHidingSink(Sink sink) {
        super(sink);
    }

    @Override
    public void write(Buffer buffer, long l2) throws IOException {
        if (this.hasErrors) {
            buffer.skip(l2);
            return;
        }
        try {
            super.write(buffer, l2);
            return;
        }
        catch (IOException iOException) {
            this.hasErrors = true;
            this.onException(iOException);
            return;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
            return;
        }
        catch (IOException iOException) {
            this.hasErrors = true;
            this.onException(iOException);
            return;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.close();
            return;
        }
        catch (IOException iOException) {
            this.hasErrors = true;
            this.onException(iOException);
            return;
        }
    }

    protected void onException(IOException iOException) {
    }
}

