/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.CacheControl;
import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.Request$Builder;
import com.zoyi.io.socket.okhttp3.RequestBody;
import java.util.List;

public final class Request {
    final HttpUrl url;
    final String method;
    final Headers headers;
    final RequestBody body;
    final Object tag;
    private volatile CacheControl cacheControl;

    Request(Request$Builder request$Builder) {
        this.url = request$Builder.url;
        this.method = request$Builder.method;
        this.headers = request$Builder.headers.build();
        this.body = request$Builder.body;
        this.tag = request$Builder.tag != null ? request$Builder.tag : this;
    }

    public final HttpUrl url() {
        return this.url;
    }

    public final String method() {
        return this.method;
    }

    public final Headers headers() {
        return this.headers;
    }

    public final String header(String string) {
        return this.headers.get(string);
    }

    public final List<String> headers(String string) {
        return this.headers.values(string);
    }

    public final RequestBody body() {
        return this.body;
    }

    public final Object tag() {
        return this.tag;
    }

    public final Request$Builder newBuilder() {
        return new Request$Builder(this);
    }

    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl != null) {
            return cacheControl;
        }
        this.cacheControl = CacheControl.parse(this.headers);
        return this.cacheControl;
    }

    public final boolean isHttps() {
        return this.url.isHttps();
    }

    public final String toString() {
        return "Request{method=" + this.method + ", url=" + this.url + ", tag=" + (this.tag != this ? this.tag : null) + '}';
    }
}

