/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.CipherSuite;
import com.zoyi.io.socket.okhttp3.ConnectionSpec$Builder;
import com.zoyi.io.socket.okhttp3.TlsVersion;
import com.zoyi.io.socket.okhttp3.internal.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    private static final CipherSuite[] APPROVED_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA};
    public static final ConnectionSpec MODERN_TLS = new ConnectionSpec$Builder(true).cipherSuites(APPROVED_CIPHER_SUITES).tlsVersions(TlsVersion.TLS_1_3, TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
    public static final ConnectionSpec COMPATIBLE_TLS = new ConnectionSpec$Builder(MODERN_TLS).tlsVersions(TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
    public static final ConnectionSpec CLEARTEXT = new ConnectionSpec$Builder(false).build();
    final boolean tls;
    final boolean supportsTlsExtensions;
    final String[] cipherSuites;
    final String[] tlsVersions;

    ConnectionSpec(ConnectionSpec$Builder connectionSpec$Builder) {
        this.tls = connectionSpec$Builder.tls;
        this.cipherSuites = connectionSpec$Builder.cipherSuites;
        this.tlsVersions = connectionSpec$Builder.tlsVersions;
        this.supportsTlsExtensions = connectionSpec$Builder.supportsTlsExtensions;
    }

    public final boolean isTls() {
        return this.tls;
    }

    public final List<CipherSuite> cipherSuites() {
        if (this.cipherSuites == null) {
            return null;
        }
        ArrayList<CipherSuite> arrayList = new ArrayList<CipherSuite>(this.cipherSuites.length);
        String[] stringArray = this.cipherSuites;
        int n2 = this.cipherSuites.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            arrayList.add(CipherSuite.forJavaName(string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final List<TlsVersion> tlsVersions() {
        if (this.tlsVersions == null) {
            return null;
        }
        ArrayList<TlsVersion> arrayList = new ArrayList<TlsVersion>(this.tlsVersions.length);
        String[] stringArray = this.tlsVersions;
        int n2 = this.tlsVersions.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            arrayList.add(TlsVersion.forJavaName(string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    final void apply(SSLSocket sSLSocket, boolean bl) {
        ConnectionSpec connectionSpec = this.supportedSpec(sSLSocket, bl);
        if (connectionSpec.tlsVersions != null) {
            sSLSocket.setEnabledProtocols(connectionSpec.tlsVersions);
        }
        if (connectionSpec.cipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(connectionSpec.cipherSuites);
        }
    }

    private ConnectionSpec supportedSpec(SSLSocket sSLSocket, boolean bl) {
        String[] stringArray;
        String[] stringArray2 = this.cipherSuites != null ? Util.intersect(String.class, this.cipherSuites, sSLSocket.getEnabledCipherSuites()) : sSLSocket.getEnabledCipherSuites();
        String[] stringArray3 = stringArray = this.tlsVersions != null ? Util.intersect(String.class, this.tlsVersions, sSLSocket.getEnabledProtocols()) : sSLSocket.getEnabledProtocols();
        if (bl && Util.indexOf(sSLSocket.getSupportedCipherSuites(), "TLS_FALLBACK_SCSV") != -1) {
            stringArray2 = Util.concat(stringArray2, "TLS_FALLBACK_SCSV");
        }
        return new ConnectionSpec$Builder(this).cipherSuites(stringArray2).tlsVersions(stringArray).build();
    }

    public final boolean isCompatible(SSLSocket sSLSocket) {
        if (!this.tls) {
            return false;
        }
        if (this.tlsVersions != null && !ConnectionSpec.nonEmptyIntersection(this.tlsVersions, sSLSocket.getEnabledProtocols())) {
            return false;
        }
        return this.cipherSuites == null || ConnectionSpec.nonEmptyIntersection(this.cipherSuites, sSLSocket.getEnabledCipherSuites());
    }

    private static boolean nonEmptyIntersection(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length == 0 || stringArray2.length == 0) {
            return false;
        }
        for (String string : stringArray) {
            if (Util.indexOf(stringArray2, string) == -1) continue;
            return true;
        }
        return false;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (ConnectionSpec)object;
        if (this.tls != ((ConnectionSpec)object).tls) {
            return false;
        }
        if (this.tls) {
            if (!Arrays.equals(this.cipherSuites, ((ConnectionSpec)object).cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersions, ((ConnectionSpec)object).tlsVersions)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n2 = 17;
        if (this.tls) {
            n2 = 527 + Arrays.hashCode(this.cipherSuites);
            n2 = n2 * 31 + Arrays.hashCode(this.tlsVersions);
            n2 = n2 * 31 + (this.supportsTlsExtensions ? 0 : 1);
        }
        return n2;
    }

    public final String toString() {
        if (!this.tls) {
            return "ConnectionSpec()";
        }
        String string = this.cipherSuites != null ? this.cipherSuites().toString() : "[all enabled]";
        String string2 = this.tlsVersions != null ? this.tlsVersions().toString() : "[all enabled]";
        return "ConnectionSpec(cipherSuites=" + string + ", tlsVersions=" + string2 + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ")";
    }
}

