/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.engineio.client.transports;

import com.zoyi.io.socket.emitter.Emitter$Listener;
import com.zoyi.io.socket.engineio.client.Transport;
import com.zoyi.io.socket.engineio.client.Transport$Options;
import com.zoyi.io.socket.engineio.client.Transport$ReadyState;
import com.zoyi.io.socket.engineio.client.transports.Polling$1;
import com.zoyi.io.socket.engineio.client.transports.Polling$2;
import com.zoyi.io.socket.engineio.client.transports.Polling$3;
import com.zoyi.io.socket.engineio.client.transports.Polling$4;
import com.zoyi.io.socket.engineio.client.transports.Polling$5;
import com.zoyi.io.socket.engineio.parser.Packet;
import com.zoyi.io.socket.engineio.parser.Parser;
import com.zoyi.io.socket.engineio.parser.Parser$DecodePayloadCallback;
import com.zoyi.io.socket.parseqs.ParseQS;
import com.zoyi.io.socket.thread.EventThread;
import com.zoyi.io.socket.utf8.UTF8Exception;
import com.zoyi.io.socket.yeast.Yeast;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class Polling
extends Transport {
    private static final Logger logger = Logger.getLogger(Polling.class.getName());
    public static final String NAME = "polling";
    public static final String EVENT_POLL = "poll";
    public static final String EVENT_POLL_COMPLETE = "pollComplete";
    private boolean polling;

    public Polling(Transport$Options transport$Options) {
        super(transport$Options);
        this.name = NAME;
    }

    @Override
    protected void doOpen() {
        this.poll();
    }

    public void pause(Runnable runnable) {
        EventThread.exec(new Polling$1(this, runnable));
    }

    private void poll() {
        logger.fine(NAME);
        this.polling = true;
        this.doPoll();
        this.emit(EVENT_POLL, new Object[0]);
    }

    @Override
    protected void onData(String string) {
        this._onData(string);
    }

    @Override
    protected void onData(byte[] byArray) {
        this._onData(byArray);
    }

    private void _onData(Object object) {
        Object object2 = this;
        logger.fine(String.format("polling got data %s", object));
        object2 = new Polling$2(this, (Polling)object2);
        if (object instanceof String) {
            Parser.decodePayload((String)object, (Parser$DecodePayloadCallback<String>)object2);
        } else if (object instanceof byte[]) {
            Parser.decodePayload((byte[])object, (Parser$DecodePayloadCallback)object2);
        }
        if (this.readyState != Transport$ReadyState.CLOSED) {
            this.polling = false;
            this.emit(EVENT_POLL_COMPLETE, new Object[0]);
            if (this.readyState == Transport$ReadyState.OPEN) {
                this.poll();
                return;
            }
            logger.fine(String.format("ignoring poll - transport state '%s'", new Object[]{this.readyState}));
        }
    }

    @Override
    protected void doClose() {
        Object object = this;
        object = new Polling$3(this, (Polling)object);
        if (this.readyState == Transport$ReadyState.OPEN) {
            logger.fine("transport open - closing");
            object.call(new Object[0]);
            return;
        }
        logger.fine("transport not open - deferring close");
        this.once("open", (Emitter$Listener)object);
    }

    @Override
    protected void write(Packet[] packetArray) throws UTF8Exception {
        Polling polling = this;
        this.writable = false;
        Polling$4 polling$4 = new Polling$4(this, polling);
        Parser.encodePayload(packetArray, new Polling$5(this, polling, polling$4));
    }

    protected String uri() {
        HashMap<String, String> hashMap = this.query;
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        String string = this.secure ? "https" : "http";
        String string2 = "";
        if (this.timestampRequests) {
            hashMap.put(this.timestampParam, Yeast.yeast());
        }
        hashMap = ParseQS.encode(hashMap);
        if (this.port > 0 && ("https".equals(string) && this.port != 443 || "http".equals(string) && this.port != 80)) {
            string2 = ":" + this.port;
        }
        if (((String)((Object)hashMap)).length() > 0) {
            hashMap = "?" + (String)((Object)hashMap);
        }
        boolean bl = this.hostname.contains(":");
        return string + "://" + (bl ? "[" + this.hostname + "]" : this.hostname) + string2 + this.path + (String)((Object)hashMap);
    }

    protected abstract void doWrite(byte[] var1, Runnable var2);

    protected abstract void doPoll();

    static /* synthetic */ Transport$ReadyState access$002(Polling polling, Transport$ReadyState transport$ReadyState) {
        polling.readyState = transport$ReadyState;
        return polling.readyState;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ Transport$ReadyState access$202(Polling polling, Transport$ReadyState transport$ReadyState) {
        polling.readyState = transport$ReadyState;
        return polling.readyState;
    }

    static /* synthetic */ boolean access$300(Polling polling) {
        return polling.polling;
    }

    static /* synthetic */ Transport$ReadyState access$400(Polling polling) {
        return polling.readyState;
    }

    static /* synthetic */ void access$500(Polling polling) {
        polling.onOpen();
    }

    static /* synthetic */ void access$600(Polling polling) {
        polling.onClose();
    }

    static /* synthetic */ void access$700(Polling polling, Packet packet) {
        polling.onPacket(packet);
    }
}

