/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.engineio.client;

import com.zoyi.io.socket.emitter.Emitter;
import com.zoyi.io.socket.engineio.client.EngineIOException;
import com.zoyi.io.socket.engineio.client.Socket;
import com.zoyi.io.socket.engineio.client.Transport$1;
import com.zoyi.io.socket.engineio.client.Transport$2;
import com.zoyi.io.socket.engineio.client.Transport$3;
import com.zoyi.io.socket.engineio.client.Transport$Options;
import com.zoyi.io.socket.engineio.client.Transport$ReadyState;
import com.zoyi.io.socket.engineio.parser.Packet;
import com.zoyi.io.socket.engineio.parser.Parser;
import com.zoyi.io.socket.thread.EventThread;
import com.zoyi.io.socket.utf8.UTF8Exception;
import java.net.Proxy;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public abstract class Transport
extends Emitter {
    public static final String EVENT_OPEN = "open";
    public static final String EVENT_CLOSE = "close";
    public static final String EVENT_PACKET = "packet";
    public static final String EVENT_DRAIN = "drain";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_REQUEST_HEADERS = "requestHeaders";
    public static final String EVENT_RESPONSE_HEADERS = "responseHeaders";
    public boolean writable;
    public String name;
    public Map<String, String> query;
    protected boolean secure;
    protected boolean timestampRequests;
    protected int port;
    protected String path;
    protected String hostname;
    protected String timestampParam;
    protected SSLContext sslContext;
    protected Socket socket;
    protected HostnameVerifier hostnameVerifier;
    protected Proxy proxy;
    protected String proxyLogin;
    protected String proxyPassword;
    protected Transport$ReadyState readyState;

    public Transport(Transport$Options transport$Options) {
        this.path = transport$Options.path;
        this.hostname = transport$Options.hostname;
        this.port = transport$Options.port;
        this.secure = transport$Options.secure;
        this.query = transport$Options.query;
        this.timestampParam = transport$Options.timestampParam;
        this.timestampRequests = transport$Options.timestampRequests;
        this.sslContext = transport$Options.sslContext;
        this.socket = transport$Options.socket;
        this.hostnameVerifier = transport$Options.hostnameVerifier;
        this.proxy = transport$Options.proxy;
        this.proxyLogin = transport$Options.proxyLogin;
        this.proxyPassword = transport$Options.proxyPassword;
    }

    protected Transport onError(String object, Exception exception) {
        object = new EngineIOException((String)object, exception);
        this.emit(EVENT_ERROR, object);
        return this;
    }

    public Transport open() {
        EventThread.exec(new Transport$1(this));
        return this;
    }

    public Transport close() {
        EventThread.exec(new Transport$2(this));
        return this;
    }

    public void send(Packet[] packetArray) {
        EventThread.exec(new Transport$3(this, packetArray));
    }

    protected void onOpen() {
        this.readyState = Transport$ReadyState.OPEN;
        this.writable = true;
        this.emit(EVENT_OPEN, new Object[0]);
    }

    protected void onData(String string) {
        this.onPacket(Parser.decodePacket(string));
    }

    protected void onData(byte[] byArray) {
        this.onPacket(Parser.decodePacket(byArray));
    }

    protected void onPacket(Packet packet) {
        this.emit(EVENT_PACKET, packet);
    }

    protected void onClose() {
        this.readyState = Transport$ReadyState.CLOSED;
        this.emit(EVENT_CLOSE, new Object[0]);
    }

    protected abstract void write(Packet[] var1) throws UTF8Exception;

    protected abstract void doOpen();

    protected abstract void doClose();
}

