/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.client;

import com.zoyi.io.socket.backo.Backoff;
import com.zoyi.io.socket.client.Manager$1;
import com.zoyi.io.socket.client.Manager$10;
import com.zoyi.io.socket.client.Manager$11;
import com.zoyi.io.socket.client.Manager$12;
import com.zoyi.io.socket.client.Manager$2;
import com.zoyi.io.socket.client.Manager$3;
import com.zoyi.io.socket.client.Manager$4;
import com.zoyi.io.socket.client.Manager$5;
import com.zoyi.io.socket.client.Manager$6;
import com.zoyi.io.socket.client.Manager$7;
import com.zoyi.io.socket.client.Manager$8;
import com.zoyi.io.socket.client.Manager$9;
import com.zoyi.io.socket.client.Manager$OpenCallback;
import com.zoyi.io.socket.client.Manager$Options;
import com.zoyi.io.socket.client.Manager$ReadyState;
import com.zoyi.io.socket.client.On;
import com.zoyi.io.socket.client.On$Handle;
import com.zoyi.io.socket.client.Socket;
import com.zoyi.io.socket.emitter.Emitter;
import com.zoyi.io.socket.parser.Packet;
import com.zoyi.io.socket.parser.Parser$Decoder;
import com.zoyi.io.socket.parser.Parser$Encoder;
import com.zoyi.io.socket.thread.EventThread;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class Manager
extends Emitter {
    private static final Logger logger = Logger.getLogger(Manager.class.getName());
    public static final String EVENT_OPEN = "open";
    public static final String EVENT_CLOSE = "close";
    public static final String EVENT_PACKET = "packet";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_CONNECT_ERROR = "connect_error";
    public static final String EVENT_CONNECT_TIMEOUT = "connect_timeout";
    public static final String EVENT_RECONNECT = "reconnect";
    public static final String EVENT_RECONNECT_ERROR = "reconnect_error";
    public static final String EVENT_RECONNECT_FAILED = "reconnect_failed";
    public static final String EVENT_RECONNECT_ATTEMPT = "reconnect_attempt";
    public static final String EVENT_RECONNECTING = "reconnecting";
    public static final String EVENT_PING = "ping";
    public static final String EVENT_PONG = "pong";
    public static final String EVENT_TRANSPORT = "transport";
    static SSLContext defaultSSLContext;
    static HostnameVerifier defaultHostnameVerifier;
    Manager$ReadyState readyState;
    private boolean _reconnection;
    private boolean skipReconnect;
    private boolean reconnecting;
    private boolean encoding;
    private int _reconnectionAttempts;
    private long _reconnectionDelay;
    private long _reconnectionDelayMax;
    private double _randomizationFactor;
    private Backoff backoff;
    private long _timeout;
    private Set<Socket> connecting = new HashSet<Socket>();
    private Date lastPing;
    private URI uri;
    private List<Packet> packetBuffer;
    private Queue<On$Handle> subs;
    private Manager$Options opts;
    com.zoyi.io.socket.engineio.client.Socket engine;
    private Parser$Encoder encoder;
    private Parser$Decoder decoder;
    ConcurrentHashMap<String, Socket> nsps;

    public Manager() {
        this(null, null);
    }

    public Manager(URI uRI) {
        this(uRI, null);
    }

    public Manager(Manager$Options manager$Options) {
        this(null, manager$Options);
    }

    public Manager(URI uRI, Manager$Options manager$Options) {
        if (manager$Options == null) {
            manager$Options = new Manager$Options();
        }
        if (manager$Options.path == null) {
            manager$Options.path = "/socket.io";
        }
        if (manager$Options.sslContext == null) {
            manager$Options.sslContext = defaultSSLContext;
        }
        if (manager$Options.hostnameVerifier == null) {
            manager$Options.hostnameVerifier = defaultHostnameVerifier;
        }
        this.opts = manager$Options;
        this.nsps = new ConcurrentHashMap();
        this.subs = new LinkedList<On$Handle>();
        this.reconnection(manager$Options.reconnection);
        this.reconnectionAttempts(manager$Options.reconnectionAttempts != 0 ? manager$Options.reconnectionAttempts : Integer.MAX_VALUE);
        this.reconnectionDelay(manager$Options.reconnectionDelay != 0L ? manager$Options.reconnectionDelay : 1000L);
        this.reconnectionDelayMax(manager$Options.reconnectionDelayMax != 0L ? manager$Options.reconnectionDelayMax : 5000L);
        this.randomizationFactor(manager$Options.randomizationFactor != 0.0 ? manager$Options.randomizationFactor : 0.5);
        this.backoff = new Backoff().setMin(this.reconnectionDelay()).setMax(this.reconnectionDelayMax()).setJitter(this.randomizationFactor());
        this.timeout(manager$Options.timeout);
        this.readyState = Manager$ReadyState.CLOSED;
        this.uri = uRI;
        this.encoding = false;
        this.packetBuffer = new ArrayList<Packet>();
        this.encoder = new Parser$Encoder();
        this.decoder = new Parser$Decoder();
    }

    private void emitAll(String string, Object ... objectArray) {
        this.emit(string, objectArray);
        for (Socket socket : this.nsps.values()) {
            socket.emit(string, objectArray);
        }
    }

    private void updateSocketIds() {
        for (Socket socket : this.nsps.values()) {
            var1_1.next().id = this.engine.id();
        }
    }

    public boolean reconnection() {
        return this._reconnection;
    }

    public Manager reconnection(boolean bl) {
        this._reconnection = bl;
        return this;
    }

    public int reconnectionAttempts() {
        return this._reconnectionAttempts;
    }

    public Manager reconnectionAttempts(int n2) {
        this._reconnectionAttempts = n2;
        return this;
    }

    public final long reconnectionDelay() {
        return this._reconnectionDelay;
    }

    public Manager reconnectionDelay(long l2) {
        this._reconnectionDelay = l2;
        if (this.backoff != null) {
            this.backoff.setMin(l2);
        }
        return this;
    }

    public final double randomizationFactor() {
        return this._randomizationFactor;
    }

    public Manager randomizationFactor(double d2) {
        this._randomizationFactor = d2;
        if (this.backoff != null) {
            this.backoff.setJitter(d2);
        }
        return this;
    }

    public final long reconnectionDelayMax() {
        return this._reconnectionDelayMax;
    }

    public Manager reconnectionDelayMax(long l2) {
        this._reconnectionDelayMax = l2;
        if (this.backoff != null) {
            this.backoff.setMax(l2);
        }
        return this;
    }

    public long timeout() {
        return this._timeout;
    }

    public Manager timeout(long l2) {
        this._timeout = l2;
        return this;
    }

    private void maybeReconnectOnOpen() {
        if (!this.reconnecting && this._reconnection && this.backoff.getAttempts() == 0) {
            this.reconnect();
        }
    }

    public Manager open() {
        return this.open(null);
    }

    public Manager open(Manager$OpenCallback manager$OpenCallback) {
        EventThread.exec(new Manager$1(this, manager$OpenCallback));
        return this;
    }

    private void onopen() {
        logger.fine(EVENT_OPEN);
        this.cleanup();
        this.readyState = Manager$ReadyState.OPEN;
        this.emit(EVENT_OPEN, new Object[0]);
        com.zoyi.io.socket.engineio.client.Socket socket = this.engine;
        this.subs.add(On.on(socket, "data", new Manager$2(this)));
        this.subs.add(On.on(socket, EVENT_PING, new Manager$3(this)));
        this.subs.add(On.on(socket, EVENT_PONG, new Manager$4(this)));
        this.subs.add(On.on(socket, EVENT_ERROR, new Manager$5(this)));
        this.subs.add(On.on(socket, EVENT_CLOSE, new Manager$6(this)));
        this.subs.add(On.on(this.decoder, Parser$Decoder.EVENT_DECODED, new Manager$7(this)));
    }

    private void onping() {
        this.lastPing = new Date();
        this.emitAll(EVENT_PING, new Object[0]);
    }

    private void onpong() {
        this.emitAll(EVENT_PONG, this.lastPing != null ? new Date().getTime() - this.lastPing.getTime() : 0L);
    }

    private void ondata(String string) {
        this.decoder.add(string);
    }

    private void ondata(byte[] byArray) {
        this.decoder.add(byArray);
    }

    private void ondecoded(Packet packet) {
        this.emit(EVENT_PACKET, packet);
    }

    private void onerror(Exception exception) {
        logger.log(Level.FINE, EVENT_ERROR, exception);
        this.emitAll(EVENT_ERROR, exception);
    }

    public Socket socket(String object) {
        Object object2 = this.nsps.get(object);
        if (object2 == null) {
            object2 = new Socket(this, (String)object);
            if ((object = this.nsps.putIfAbsent((String)object, (Socket)object2)) != null) {
                object2 = object;
            } else {
                object = this;
                Object object3 = object2;
                ((Emitter)object2).on("connecting", new Manager$8(this, (Manager)object, (Socket)object3));
                ((Emitter)object2).on("connect", new Manager$9(this, (Socket)object3, (Manager)object));
            }
        }
        return object2;
    }

    void destroy(Socket socket) {
        this.connecting.remove(socket);
        if (!this.connecting.isEmpty()) {
            return;
        }
        this.close();
    }

    void packet(Packet packet) {
        logger.fine(String.format("writing packet %s", packet));
        Manager manager = this;
        if (!manager.encoding) {
            manager.encoding = true;
            this.encoder.encode(packet, new Manager$10(this, manager));
            return;
        }
        manager.packetBuffer.add(packet);
    }

    private void processPacketQueue() {
        if (!this.packetBuffer.isEmpty() && !this.encoding) {
            Packet packet = this.packetBuffer.remove(0);
            this.packet(packet);
        }
    }

    private void cleanup() {
        On$Handle on$Handle;
        logger.fine("cleanup");
        while ((on$Handle = this.subs.poll()) != null) {
            on$Handle.destroy();
        }
        this.packetBuffer.clear();
        this.encoding = false;
        this.lastPing = null;
        this.decoder.destroy();
    }

    void close() {
        logger.fine("disconnect");
        this.skipReconnect = true;
        this.reconnecting = false;
        if (this.readyState != Manager$ReadyState.OPEN) {
            this.cleanup();
        }
        this.backoff.reset();
        this.readyState = Manager$ReadyState.CLOSED;
        if (this.engine != null) {
            this.engine.close();
        }
    }

    private void onclose(String string) {
        logger.fine("onclose");
        this.cleanup();
        this.backoff.reset();
        this.readyState = Manager$ReadyState.CLOSED;
        this.emit(EVENT_CLOSE, string);
        if (this._reconnection && !this.skipReconnect) {
            this.reconnect();
        }
    }

    private void reconnect() {
        if (this.reconnecting || this.skipReconnect) {
            return;
        }
        Manager manager = this;
        if (this.backoff.getAttempts() >= this._reconnectionAttempts) {
            logger.fine("reconnect failed");
            this.backoff.reset();
            this.emitAll(EVENT_RECONNECT_FAILED, new Object[0]);
            this.reconnecting = false;
            return;
        }
        long l2 = this.backoff.duration();
        logger.fine(String.format("will wait %dms before reconnect attempt", l2));
        this.reconnecting = true;
        Timer timer = new Timer();
        timer.schedule((TimerTask)new Manager$11(this, manager), l2);
        this.subs.add(new Manager$12(this, timer));
    }

    private void onreconnect() {
        int n2 = this.backoff.getAttempts();
        this.reconnecting = false;
        this.backoff.reset();
        this.updateSocketIds();
        this.emitAll(EVENT_RECONNECT, n2);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ URI access$100(Manager manager) {
        return manager.uri;
    }

    static /* synthetic */ Manager$Options access$200(Manager manager) {
        return manager.opts;
    }

    static /* synthetic */ boolean access$302(Manager manager, boolean bl) {
        manager.skipReconnect = bl;
        return manager.skipReconnect;
    }

    static /* synthetic */ void access$400(Manager manager) {
        manager.onopen();
    }

    static /* synthetic */ void access$500(Manager manager) {
        manager.cleanup();
    }

    static /* synthetic */ void access$600(Manager manager, String string, Object[] objectArray) {
        manager.emitAll(string, objectArray);
    }

    static /* synthetic */ void access$700(Manager manager) {
        manager.maybeReconnectOnOpen();
    }

    static /* synthetic */ long access$800(Manager manager) {
        return manager._timeout;
    }

    static /* synthetic */ Queue access$900(Manager manager) {
        return manager.subs;
    }

    static /* synthetic */ void access$1000(Manager manager, String string) {
        manager.ondata(string);
    }

    static /* synthetic */ void access$1100(Manager manager, byte[] byArray) {
        manager.ondata(byArray);
    }

    static /* synthetic */ void access$1200(Manager manager) {
        manager.onping();
    }

    static /* synthetic */ void access$1300(Manager manager) {
        manager.onpong();
    }

    static /* synthetic */ void access$1400(Manager manager, Exception exception) {
        manager.onerror(exception);
    }

    static /* synthetic */ void access$1500(Manager manager, String string) {
        manager.onclose(string);
    }

    static /* synthetic */ void access$1600(Manager manager, Packet packet) {
        manager.ondecoded(packet);
    }

    static /* synthetic */ Set access$1700(Manager manager) {
        return manager.connecting;
    }

    static /* synthetic */ boolean access$1802(Manager manager, boolean bl) {
        manager.encoding = bl;
        return manager.encoding;
    }

    static /* synthetic */ void access$1900(Manager manager) {
        manager.processPacketQueue();
    }

    static /* synthetic */ boolean access$300(Manager manager) {
        return manager.skipReconnect;
    }

    static /* synthetic */ Backoff access$2000(Manager manager) {
        return manager.backoff;
    }

    static /* synthetic */ boolean access$2102(Manager manager, boolean bl) {
        manager.reconnecting = bl;
        return manager.reconnecting;
    }

    static /* synthetic */ void access$2200(Manager manager) {
        manager.reconnect();
    }

    static /* synthetic */ void access$2300(Manager manager) {
        manager.onreconnect();
    }
}

