/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.presenter.chat;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.ColorRes;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat.CountryDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnActionMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnUserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.activity.chat.model.NewMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.QuestionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ActionType;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.chat.ChatState;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.presenter.chat.ChatAdapterContract$Model;
import com.zoyi.channel.plugin.android.presenter.chat.ChatAdapterContract$View;
import com.zoyi.channel.plugin.android.presenter.chat.ChatContract$Presenter;
import com.zoyi.channel.plugin.android.presenter.chat.ChatContract$View;
import com.zoyi.channel.plugin.android.presenter.chat.a;
import com.zoyi.channel.plugin.android.presenter.chat.b;
import com.zoyi.channel.plugin.android.presenter.chat.c;
import com.zoyi.channel.plugin.android.presenter.chat.d;
import com.zoyi.channel.plugin.android.presenter.chat.e;
import com.zoyi.channel.plugin.android.presenter.chat.f;
import com.zoyi.channel.plugin.android.presenter.chat.g;
import com.zoyi.channel.plugin.android.presenter.chat.h;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ChatPresenter
implements OnActionMessageClickListener,
OnMessageClickListener,
OnMessageSendListener,
OnSendingMessageClickListener,
OnUserInfoListener,
ChatContract$Presenter {
    private ChatContract$View view;
    private ChatAdapterContract$View adapterView;
    private ChatAdapterContract$Model adapterModel;
    private Context context;
    private ProgressDialog dialog;
    private UserChat userChat;
    private Session session;
    private ChatDataDictionary dictionary;
    private CountryDictionary countryDictionary;
    private String chatId;
    private int backColor = -16777216;
    private int textColor = -1;
    private ChatState state = ChatState.IDLE;
    private String backwardId = "zzzzzzzzzzzzzzzz";
    private String forwardId = "0000000000000000";
    private String forwardTempId = "0000000000000000";
    private Long forwardTimestamp = Long.MIN_VALUE;
    private int fetchCounter = 0;
    private boolean welcomeMessageExists = false;
    private boolean backwardLoading = false;
    private boolean newMessageDismiss = false;
    private boolean firstMessage = true;
    private boolean isUserInfoFirst = true;
    private Long lastReadAt;
    private UserInfoItem userInfoItem;
    private List<SendingMessageItem> tempQueue;

    public ChatPresenter(Context context) {
        this.context = context;
        TimeUtils.refreshOffset();
        this.dictionary = new ChatDataDictionary();
        this.countryDictionary = new CountryDictionary(context);
        this.tempQueue = new ArrayList<SendingMessageItem>();
        ChatManager.get().setOnMessageSendListener(this);
    }

    @Override
    public void showProgress() {
        if (this.dialog == null || !this.dialog.isShowing()) {
            this.dialog = ProgressHelper.show(this.context, ResUtils.getString(this.context, "ch.loading_information"));
        }
    }

    @Override
    public void hideProgress() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    @Override
    public void setView(ChatContract$View chatContract$View) {
        this.view = chatContract$View;
    }

    @Override
    public String getChatId() {
        return this.chatId;
    }

    @Override
    public void setChatId(String string2) {
        this.chatId = string2;
    }

    @Override
    public int getBackColor() {
        return this.backColor;
    }

    @Override
    public int getTextColor() {
        return this.textColor;
    }

    @Override
    public void setColor(@ColorRes int n2, @ColorRes int n3) {
        this.backColor = n2;
        this.textColor = n3;
    }

    @Override
    public void setAdapterView(ChatAdapterContract$View chatAdapterContract$View) {
        this.adapterView = chatAdapterContract$View;
        this.adapterView.setOnMessageClickListener(this);
        this.adapterView.setOnActionMessageClickListener(this);
        this.adapterView.setOnSendingMessageClickListener(this);
        this.adapterView.setOnUserInfoListener(this);
    }

    @Override
    public void setAdapterModel(ChatAdapterContract$Model chatAdapterContract$Model) {
        this.adapterModel = chatAdapterContract$Model;
    }

    @Override
    public void init() {
        if (this.chatId == null) {
            this.addWelcomeMessage();
            return;
        }
        this.adapterModel.addMessageItems(ChatManager.get().getFailedItems(this.chatId));
        this.fetchUserChat();
    }

    private void addWorkingTimeMessage() {
        String string2;
        if (!this.welcomeMessageExists && !ChannelStore.isWorking() && (string2 = ChannelStore.getScript("out_of_work", "ch.scripts.out_of_work.default")) != null) {
            this.welcomeMessageExists = true;
            this.adapterModel.addMessageItem(new ActionMessageItem(ActionType.REQUEST_WORKING_TIME, string2, this.forwardTimestamp, 1));
        }
    }

    private void addWelcomeMessage() {
        if (!this.welcomeMessageExists) {
            String string2;
            if (!ChannelStore.isWorking()) {
                this.addWorkingTimeMessage();
                return;
            }
            User user = ChannelStore.getUser();
            if (user != null && user.getName() != null) {
                string2 = ChannelStore.getScript("welcome_user", "ch.scripts.welcome_user.default");
                if (string2 != null) {
                    string2 = string2.replace("${user}", user.getName());
                }
            } else {
                string2 = ChannelStore.getScript("welcome_veil", "ch.scripts.welcome_veil.default");
            }
            if (string2 != null) {
                this.welcomeMessageExists = true;
                this.adapterModel.addMessageItem(new ActionMessageItem(null, string2, this.forwardTimestamp, 1));
            }
        }
    }

    @Override
    public void fetchUserChat() {
        if (this.userChat == null) {
            this.showProgress();
        }
        this.setState(ChatState.USER_CHAT_LOADING, false);
        ChannelPlugin.getApi().getUserChat(this.chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new a(this));
    }

    private void createUserChat() {
        this.showProgress();
        this.setState(ChatState.USER_CHAT_LOADING, false);
        if (ChannelStore.getPluginId() != null) {
            ChannelPlugin.getApi().createUserChat(ChannelStore.getPluginId()).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new b(this));
            return;
        }
        this.hideProgress();
    }

    private void setUserChat(UserChatWrapper userChatWrapper, boolean bl) {
        this.hideProgress();
        if (this.isStateEquals(ChatState.USER_CHAT_LOADING)) {
            if (userChatWrapper == null) {
                this.handleUserChatFetchError(new Exception("UserChatWrapper cannot be null"));
                return;
            }
            this.view.onLoadUserChat();
            this.view.setReconnectVisibility(false);
            this.userChat = userChatWrapper.getUserChat();
            this.chatId = userChatWrapper.getUserChat().getId();
            this.session = userChatWrapper.getSession();
            this.dictionary.add(userChatWrapper.getManagers());
            if (this.lastReadAt == null) {
                this.lastReadAt = bl ? Long.MAX_VALUE : this.session.getLastReadAt();
            }
            if (this.tempQueue.size() > 0) {
                ChatManager.get().send(this.chatId, this.tempQueue);
                this.tempQueue.clear();
            }
            this.joinChat();
        }
    }

    private void handleUserChatFetchError(Throwable throwable) {
        if (throwable != null) {
            L.e(throwable.getMessage());
        }
        if (this.isStateEquals(ChatState.USER_CHAT_LOADING)) {
            this.setState(ChatState.USER_CHAT_NOT_LOADED, true);
        }
    }

    private void joinChat() {
        if (SocketManager.isReady()) {
            this.setState(ChatState.CHAT_JOINING, false);
            SocketManager.joinChat(this.chatId);
            return;
        }
        this.setState(ChatState.WAITING_SOCKET, false);
        SocketManager.reconnect();
    }

    private boolean isMessageExists() {
        return CompareUtils.compare(this.backwardId, this.forwardId) < 0;
    }

    private boolean isAvailableRequest(int n2) {
        return this.isStateEquals(ChatState.MESSAGES_LOADING) && this.fetchCounter == n2;
    }

    @Override
    public void fetchMessages() {
        if (SocketManager.isReady()) {
            ++this.fetchCounter;
            this.setState(ChatState.MESSAGES_LOADING, false);
            if (!this.isMessageExists()) {
                this.fetchInitMessages(this.fetchCounter);
                return;
            }
            this.fetchForwardMessages(this.forwardId, this.fetchCounter);
            return;
        }
        this.setState(ChatState.WAITING_SOCKET, false);
        SocketManager.reconnect();
    }

    @Override
    public void fetchInitMessages(int n2) {
        ChannelPlugin.getApi().getMessages(this.chatId, "zzzzzzzzzzzzzzzz", 30, "DESC").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new c(this, n2));
    }

    @Override
    public void fetchBackwardMessages() {
        if (this.backwardLoading || !this.isMessageExists()) {
            return;
        }
        this.backwardLoading = true;
        ChannelPlugin.getApi().getMessages(this.chatId, this.backwardId, 30, "DESC").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new d(this));
    }

    @Override
    public void fetchForwardMessages(String string2, int n2) {
        ChannelPlugin.getApi().getMessages(this.chatId, string2, 30, "ASC").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new e(this, n2));
    }

    private void handleMessagesFetchError(Throwable throwable, int n2) {
        if (throwable != null) {
            L.e(throwable.getMessage());
        }
        if (this.isStateEquals(ChatState.MESSAGES_LOADING) && this.fetchCounter == n2) {
            this.setState(ChatState.MESSAGES_NOT_LOADED, true);
        }
    }

    @Override
    public void calculateNewToast(int n2) {
        if (this.lastReadAt == null || this.newMessageDismiss) {
            return;
        }
        MessageItem messageItem = this.adapterModel.getItem(n2);
        if (messageItem != null) {
            if (this.lastReadAt < messageItem.getFirst()) {
                this.view.setToastVisibility(true);
                return;
            }
            this.hideNewToast();
        }
    }

    @Override
    public void newToastClicked() {
        if (this.lastReadAt != null) {
            NewMessageItem newMessageItem = new NewMessageItem(this.lastReadAt);
            int n2 = this.adapterModel.getIndex(newMessageItem);
            if (n2 < 0) {
                this.view.scrollTo(0);
                return;
            }
            this.hideNewToast();
            this.view.scrollTo(n2);
        }
    }

    @Override
    public void hideNewToast() {
        this.newMessageDismiss = true;
        this.view.setToastVisibility(false);
    }

    private void addNewMessageItem(List<Message> object) {
        if (this.lastReadAt == null) {
            return;
        }
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Message message = (Message)object.next();
                if (message.getLog() != null) continue;
                l2 = Math.min(l2, message.getCreatedAt());
                l3 = Math.max(l3, message.getCreatedAt());
            }
        }
        if (l2 <= this.lastReadAt && this.lastReadAt < l3) {
            this.adapterModel.addMessageItem(new NewMessageItem(this.lastReadAt));
        }
    }

    private void addMessage(Message message) {
        if (CompareUtils.isSame(message.getChatId(), this.chatId)) {
            this.adapterModel.addMessage(message, this.chatId);
            boolean bl = CompareUtils.exists((Comparable)((Object)message.getPersonType()), (Comparable[])new String[]{"User", "Veil"});
            if (this.isStateEquals(ChatState.CHAT_READY)) {
                this.calculateForwardId(message);
                this.readAll();
            } else {
                this.forwardTempId = CompareUtils.max(this.forwardTempId, message.getId());
            }
            this.forwardTimestamp = Math.max(this.forwardTimestamp, message.getCreatedAt());
            if (this.firstMessage && bl) {
                this.firstMessage = false;
                this.checkRequireUserInfo(this.forwardTimestamp);
            }
            this.view.scrollToBottom(false);
        }
    }

    private void addMessages(List<Message> list) {
        if (list != null) {
            for (Message message : list) {
                this.forwardTimestamp = Math.max(this.forwardTimestamp, message.getCreatedAt());
                this.forwardId = CompareUtils.max(this.forwardId, message.getId());
            }
        }
        this.adapterModel.addMessages(list, this.chatId);
    }

    private void calculateForwardId(Message message) {
        if (message != null) {
            this.forwardId = CompareUtils.max(this.forwardId, message.getId());
        }
    }

    private void calculateForwardId(List<Message> object) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Message message = (Message)object.next();
                this.calculateForwardId(message);
            }
        }
    }

    private void calculateForwardId() {
        this.forwardId = CompareUtils.max(this.forwardId, this.forwardTempId);
    }

    @Override
    public void sendTextMessage(String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return;
        }
        object = new SendingMessageItem(this.chatId, (String)object, false);
        this.adapterModel.addMessageItem((MessageItem)object);
        this.sendMessages(Collections.singletonList(object));
    }

    @Override
    public void sendImageFiles(ArrayList<String> object) {
        ArrayList<SendingMessageItem> arrayList = new ArrayList<SendingMessageItem>();
        if (object != null) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                Object object2 = (String)object.next();
                object2 = new SendingMessageItem(this.chatId, (String)object2, true);
                this.adapterModel.addMessageItem((MessageItem)object2);
                arrayList.add((SendingMessageItem)object2);
            }
        }
        this.sendMessages(arrayList);
    }

    private void sendMessages(List<SendingMessageItem> list) {
        this.view.scrollToBottom(true);
        if (this.chatId == null) {
            this.tempQueue.addAll(list);
            this.createUserChat();
            return;
        }
        ChatManager.get().send(list);
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean bl) {
        if (this.chatId != null && channelModel != null) {
            switch (channelModel.getClass().getSimpleName()) {
                case "Message": {
                    this.addMessage((Message)channelModel);
                    return;
                }
                case "File": 
                case "WebPage": 
                case "Bot": 
                case "Manager": {
                    this.dictionary.add(channelModel);
                }
            }
        }
    }

    private void readAll() {
        ChannelPlugin.getApi().readAll(this.chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        switch (command) {
            case APP_STARTED: {
                this.refresh();
                return;
            }
            case SOCKET_DISCONNECTED: {
                ++this.fetchCounter;
                if (this.isStateEquals(ChatState.IDLE)) break;
                this.setState(ChatState.USER_CHAT_NOT_LOADED, true);
                return;
            }
            case SOCKET_ERROR: {
                this.view.setReconnectVisibility(true);
                return;
            }
            case READY: {
                this.view.setReconnectVisibility(false);
                if (this.isStateEquals(ChatState.WAITING_SOCKET)) {
                    this.joinChat();
                    return;
                }
                this.refresh();
                return;
            }
            case LEAVED: {
                if (object == null || CompareUtils.compare(this.chatId, (String)object) != 0 || !this.isStateEquals(ChatState.CHAT_READY)) break;
                this.setState(ChatState.NOT_JOINED, false);
                return;
            }
            case JOINED: {
                if (object == null || CompareUtils.compare(this.chatId, (String)object) != 0 || !this.isStateEquals(ChatState.CHAT_JOINING)) break;
                this.view.setReconnectVisibility(false);
                this.fetchMessages();
            }
        }
    }

    @Override
    public void messageClicked(Message message) {
        if (message.getFile() != null) {
            if (message.getFile().getPreviewThumb() == null || !message.getFile().isImage()) {
                this.view.onFileDownload(message);
                return;
            }
            this.adapterModel.setImageFilesToStorage();
            this.view.onShowPhotoAlbum(message.getFile());
            return;
        }
        if (message.getWebPage() != null) {
            this.urlClicked(message.getWebPage().getUrl());
        }
    }

    @Override
    public void urlClicked(String string2) {
        this.view.onUrlClicked(string2);
    }

    @Override
    public void actionMessageClicked(ActionMessageItem actionMessageItem) {
        if (actionMessageItem != null && actionMessageItem.getActionType() != null) {
            switch (actionMessageItem.getActionType()) {
                case REQUEST_WORKING_TIME: {
                    actionMessageItem.setActionType(null);
                    this.adapterModel.addMessageItem(actionMessageItem);
                    Object object = new QuestionMessageItem(this.forwardTimestamp, ResUtils.getString(this.context, "ch.out_of_work.user_answer"), actionMessageItem.getOrder() + 1);
                    this.adapterModel.addMessageItem((MessageItem)object);
                    this.view.scrollToBottom(true);
                    object = ChannelStore.getChannel() != null ? ChannelStore.getChannel().getWorkingTime(this.context) : "?";
                    this.addMessageDelay(new ActionMessageItem(null, (String)object, null, actionMessageItem.getOrder() + 2));
                }
            }
        }
    }

    @Override
    public void sendingMessageClicked(SendingMessageItem sendingMessageItem) {
        this.view.sendingMessageClicked(sendingMessageItem);
    }

    @Override
    public void resend(SendingMessageItem sendingMessageItem) {
        if (sendingMessageItem != null) {
            this.removeFailedItem(sendingMessageItem);
            sendingMessageItem.refreshCreatedAt();
            this.adapterModel.addMessageItem(sendingMessageItem);
            ChatManager.get().send(sendingMessageItem);
        }
    }

    @Override
    public void removeFailedItem(SendingMessageItem sendingMessageItem) {
        if (sendingMessageItem != null) {
            this.adapterModel.removeMessageItem(sendingMessageItem);
            ChatManager.get().removeFailedItem(sendingMessageItem.getCreatedAt());
        }
    }

    @Override
    public void sendSuccessed(SendingMessageItem sendingMessageItem, Message message) {
        this.adapterModel.removeMessageItem(sendingMessageItem);
        this.addMessage(message);
    }

    @Override
    public void sendFailed(SendingMessageItem sendingMessageItem) {
        this.adapterModel.addMessageItem(sendingMessageItem);
    }

    @Override
    public UserInfoItem getUserInfoItem() {
        return this.userInfoItem;
    }

    @Override
    public ProfileEntity getProfile(String object, String string2) {
        if ((object = this.dictionary.getProfile((String)object, string2)) != null) {
            return object;
        }
        return ChannelStore.getChannel();
    }

    @Override
    public void refresh() {
        switch (this.state) {
            case USER_CHAT_NOT_LOADED: {
                if (this.chatId != null) {
                    this.fetchUserChat();
                    return;
                }
                this.createUserChat();
                return;
            }
            case WAITING_SOCKET: {
                SocketManager.connect();
                return;
            }
            case NOT_JOINED: {
                this.setState(ChatState.CHAT_JOINING, true);
                SocketManager.joinChat(this.chatId);
                return;
            }
            case MESSAGES_NOT_LOADED: {
                this.fetchMessages();
            }
        }
    }

    private void setState(ChatState chatState, boolean bl) {
        this.state = chatState;
        this.view.setRefreshVisibility(bl);
    }

    private boolean isStateEquals(ChatState chatState) {
        return chatState.equals((Object)this.state);
    }

    private void addMessageDelay(ActionMessageItem actionMessageItem) {
        Handler handler = new Handler();
        handler.postDelayed((Runnable)new f(this, actionMessageItem), 750L);
    }

    @Override
    public void userInfoChanged(Object object) {
        if (this.userInfoItem != null) {
            switch (this.userInfoItem.getUserInfoType()) {
                case NAME: {
                    if (!(object instanceof String)) break;
                    this.userInfoItem.setObject(object);
                    return;
                }
                case MOBILE_NUMBER: {
                    if (!(object instanceof MobileNumberItem)) break;
                    this.userInfoItem.setObject(object);
                }
            }
        }
    }

    @Override
    public void sendUserInfo() {
        if (this.userInfoItem != null && this.userInfoItem.getObject() != null) {
            Object object = null;
            switch (this.userInfoItem.getUserInfoType()) {
                case NAME: {
                    if (!(this.userInfoItem.getObject() instanceof String)) break;
                    object = RequestUtils.form().set("name", (String)this.userInfoItem.getObject());
                    break;
                }
                case MOBILE_NUMBER: {
                    if (!(this.userInfoItem.getObject() instanceof MobileNumberItem)) break;
                    object = (MobileNumberItem)this.userInfoItem.getObject();
                    object = RequestUtils.form().set("mobileNumber", String.format("+%s%s", ((MobileNumberItem)object).getCountry(), ((MobileNumberItem)object).getMobileNumber()));
                    break;
                }
                default: {
                    return;
                }
            }
            if (object != null) {
                ChannelPlugin.getApi().updateGuest(((RequestUtils)object).create()).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new g(this));
            }
        }
    }

    private void checkRequireUserInfo(long l2) {
        boolean bl = false;
        if (this.userInfoItem != null) {
            try {
                this.adapterModel.removeMessageItem(this.userInfoItem);
                this.userInfoItem = null;
                bl = true;
            }
            catch (Exception exception) {}
        }
        if (!ChannelStore.hasName()) {
            this.userInfoItem = new UserInfoItem(UserInfoType.NAME, l2, false, null);
        } else if (ChannelStore.getMobileNumber() == null) {
            this.userInfoItem = new UserInfoItem(UserInfoType.MOBILE_NUMBER, l2, false, new MobileNumberItem(this.countryDictionary.getDefaultCountryCode(), ""));
        }
        if (this.userInfoItem != null) {
            Observable.timer(512L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(new h(this));
            return;
        }
        if (bl) {
            this.userInfoItem = new UserInfoItem(UserInfoType.COMPLETE, l2, false, null);
            this.adapterModel.addMessageItem(this.userInfoItem);
        }
    }

    @Override
    public void leaveChat() {
        SocketManager.leaveChat(this.chatId);
    }

    @Override
    public void release() {
        ChatManager.get().setOnMessageSendListener(null);
    }

    static /* synthetic */ void access$000(ChatPresenter chatPresenter, Throwable throwable) {
        chatPresenter.handleUserChatFetchError(throwable);
    }

    static /* synthetic */ void access$100(ChatPresenter chatPresenter, UserChatWrapper userChatWrapper, boolean bl) {
        chatPresenter.setUserChat(userChatWrapper, bl);
    }

    static /* synthetic */ boolean access$200(ChatPresenter chatPresenter, int n2) {
        return chatPresenter.isAvailableRequest(n2);
    }

    static /* synthetic */ void access$300(ChatPresenter chatPresenter, Throwable throwable, int n2) {
        chatPresenter.handleMessagesFetchError(throwable, n2);
    }

    static /* synthetic */ String access$402(ChatPresenter chatPresenter, String string2) {
        chatPresenter.backwardId = string2;
        return chatPresenter.backwardId;
    }

    static /* synthetic */ ChatDataDictionary access$500(ChatPresenter chatPresenter) {
        return chatPresenter.dictionary;
    }

    static /* synthetic */ void access$600(ChatPresenter chatPresenter, List list) {
        chatPresenter.addMessages(list);
    }

    static /* synthetic */ void access$700(ChatPresenter chatPresenter, List list) {
        chatPresenter.calculateForwardId(list);
    }

    static /* synthetic */ void access$800(ChatPresenter chatPresenter) {
        chatPresenter.calculateForwardId();
    }

    static /* synthetic */ Long access$900(ChatPresenter chatPresenter) {
        return chatPresenter.lastReadAt;
    }

    static /* synthetic */ Long access$1000(ChatPresenter chatPresenter) {
        return chatPresenter.forwardTimestamp;
    }

    static /* synthetic */ Long access$902(ChatPresenter chatPresenter, Long l2) {
        chatPresenter.lastReadAt = l2;
        return chatPresenter.lastReadAt;
    }

    static /* synthetic */ void access$1100(ChatPresenter chatPresenter, List list) {
        chatPresenter.addNewMessageItem(list);
    }

    static /* synthetic */ void access$1200(ChatPresenter chatPresenter) {
        chatPresenter.addWorkingTimeMessage();
    }

    static /* synthetic */ void access$1300(ChatPresenter chatPresenter, ChatState chatState, boolean bl) {
        chatPresenter.setState(chatState, bl);
    }

    static /* synthetic */ void access$1400(ChatPresenter chatPresenter) {
        chatPresenter.readAll();
    }

    static /* synthetic */ boolean access$1502(ChatPresenter chatPresenter, boolean bl) {
        chatPresenter.backwardLoading = bl;
        return chatPresenter.backwardLoading;
    }

    static /* synthetic */ int access$1600(ChatPresenter chatPresenter) {
        return chatPresenter.fetchCounter;
    }

    static /* synthetic */ String access$1700(ChatPresenter chatPresenter) {
        return chatPresenter.chatId;
    }

    static /* synthetic */ ChatAdapterContract$Model access$1800(ChatPresenter chatPresenter) {
        return chatPresenter.adapterModel;
    }

    static /* synthetic */ String access$1900(ChatPresenter chatPresenter) {
        return chatPresenter.forwardId;
    }

    static /* synthetic */ ChatContract$View access$2000(ChatPresenter chatPresenter) {
        return chatPresenter.view;
    }

    static /* synthetic */ UserInfoItem access$2100(ChatPresenter chatPresenter) {
        return chatPresenter.userInfoItem;
    }

    static /* synthetic */ void access$2200(ChatPresenter chatPresenter, long l2) {
        chatPresenter.checkRequireUserInfo(l2);
    }

    static /* synthetic */ boolean access$2300(ChatPresenter chatPresenter) {
        return chatPresenter.isUserInfoFirst;
    }

    static /* synthetic */ boolean access$2302(ChatPresenter chatPresenter, boolean bl) {
        chatPresenter.isUserInfoFirst = bl;
        return chatPresenter.isUserInfoFirst;
    }
}

