/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.a;
import com.zoyi.channel.plugin.android.activity.chat.b;
import com.zoyi.channel.plugin.android.activity.chat.c;
import com.zoyi.channel.plugin.android.activity.chat.d;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.presenter.chat.ChatContract$Presenter;
import com.zoyi.channel.plugin.android.presenter.chat.ChatContract$View;
import com.zoyi.channel.plugin.android.presenter.chat.ChatPresenter;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.handler.BackgroundToucher;
import com.zoyi.channel.plugin.android.view.layout.BigBar$MenuPosition;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$ActionType;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$MenuState;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class ChatActivity
extends BaseActivity
implements View.OnClickListener,
ChatContract$View {
    private RecyclerView recyclerView;
    private WatchedEditText editChat;
    private Button buttonSend;
    private ImageButton buttonAttach;
    private View toast;
    private View reconnectLayout;
    private LinearLayoutManager layoutManager;
    private ChatContract$Presenter presenter;
    private ChatAdapter adapter;

    @Override
    protected void onCreate(@Nullable Bundle object) {
        super.onCreate((Bundle)object);
        this.init(R.layout.ch_plugin_activity_chat);
        this.adapter = new ChatAdapter();
        this.presenter = new ChatPresenter((Context)this);
        this.adapter.setPresenter(this.presenter);
        this.presenter.setView(this);
        this.presenter.setAdapterModel(this.adapter);
        this.presenter.setAdapterView(this.adapter);
        this.buttonSend = (Button)this.findViewById(R.id.button_send);
        this.buttonSend.setOnClickListener((View.OnClickListener)this);
        this.buttonAttach = (ImageButton)this.findViewById(R.id.button_attach);
        this.buttonAttach.setOnClickListener((View.OnClickListener)this);
        this.toast = this.findViewById(R.id.layout_toast);
        this.toast.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.button_close_toast).setOnClickListener((View.OnClickListener)this);
        this.reconnectLayout = this.findViewById(R.id.layout_reconnect);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.layoutManager.setStackFromEnd(true);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_chat);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerView.setItemAnimator(null);
        this.recyclerView.getRecycledViewPool().setMaxRecycledViews(MessageType.VERIFY.toInt(), 1);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new a(this, this.layoutManager, 1));
        this.editChat = (WatchedEditText)this.findViewById(R.id.edit_chat);
        this.editChat.setHandledButton(this.buttonSend, ContextCompat.getColor((Context)this, (int)R.color.ch_cobalt), ContextCompat.getColor((Context)this, (int)R.color.ch_gray));
        BackgroundToucher.makeKeyboardEvent(this, this.recyclerView, this.editChat);
        object = null;
        int n2 = 0;
        boolean bl = false;
        if (this.getIntent() != null) {
            object = this.getIntent().getStringExtra("chatId");
            n2 = this.getIntent().getIntExtra("chatCount", 0);
            bl = this.getIntent().getBooleanExtra("chatEmpty", false);
        }
        this.getBigBar().withActivity(this).addMenu(MenuButton$ActionType.BACK, BigBar$MenuPosition.LEFT, bl ? MenuButton$MenuState.HIDDEN : MenuButton$MenuState.VISIBLE).addMenu(MenuButton$ActionType.EXIT, BigBar$MenuPosition.LEFT, bl ? MenuButton$MenuState.VISIBLE : MenuButton$MenuState.HIDDEN).addText(BigBar$MenuPosition.LEFT).addMenu(MenuButton$ActionType.REFRESH, BigBar$MenuPosition.RIGHT, MenuButton$MenuState.HIDDEN).build();
        this.getBigBar().setText(n2);
        if (SocketManager.isError()) {
            this.setReconnectVisibility(true);
        }
        this.setStyle();
        if (object != null) {
            this.presenter.setChatId((String)object);
        }
        this.presenter.init();
    }

    public void finish() {
        this.presenter.release();
        if (this.presenter.getChatId() == null) {
            this.setResult(22);
        } else {
            this.presenter.leaveChat();
        }
        super.finish();
    }

    private void setStyle() {
        Channel channel = ChannelStore.getChannel();
        Plugin plugin = ChannelStore.getPlugin();
        if (plugin != null) {
            this.presenter.setColor(plugin.getBackgroundColor(), plugin.getTextColor());
            this.setStatusBarColor(plugin.getBackgroundColor());
            this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
        }
        if (channel != null) {
            this.getBigBar().setTitle(channel.getName());
        }
    }

    @Override
    public void onLoadUserChat() {
        this.getBigBar().setMenuState(MenuButton$ActionType.EXIT, MenuButton$MenuState.HIDDEN);
        this.getBigBar().setMenuState(MenuButton$ActionType.BACK, MenuButton$MenuState.VISIBLE);
    }

    @Override
    public void scrollToBottom(boolean bl) {
        if (this.layoutManager.findLastCompletelyVisibleItemPosition() == this.adapter.getItemCount() - 2 || bl) {
            this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
        }
    }

    @Override
    public void scrollTo(int n2) {
        this.recyclerView.smoothScrollToPosition(n2);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        super.onActivityResult(n2, n3, intent);
        switch (n2) {
            case 902: {
                if (n3 == 12) {
                    this.presenter.sendImageFiles(intent.getStringArrayListExtra("PHOTO_INTENT_KEY"));
                    return;
                }
            }
            case 3001: {
                PhotoAlbumStorage.getInstance().release();
            }
        }
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean bl) {
        this.presenter.receiveData(channelModel, bl);
    }

    @Override
    public void receiveChatCounter(int n2) {
        this.onLoadUserChat();
        this.getBigBar().setText(n2);
    }

    @Override
    public void optionClicked(MenuButton$ActionType menuButton$ActionType) {
        super.optionClicked(menuButton$ActionType);
        switch (menuButton$ActionType) {
            case REFRESH: {
                this.presenter.refresh();
            }
        }
    }

    @Override
    public void setRefreshVisibility(boolean bl) {
        this.getBigBar().setMenuState(MenuButton$ActionType.REFRESH, bl ? MenuButton$MenuState.VISIBLE : MenuButton$MenuState.HIDDEN);
    }

    @Override
    public void setReconnectVisibility(boolean bl) {
        this.reconnectLayout.setVisibility(UIUtils.getVisible(bl, true));
    }

    @Override
    public void setToastVisibility(boolean bl) {
        this.toast.setVisibility(UIUtils.getVisible(bl, true));
    }

    public void onClick(View view) {
        int n2 = view.getId();
        if (n2 == R.id.layout_toast) {
            this.presenter.newToastClicked();
        }
        if (n2 == R.id.button_close_toast) {
            this.presenter.hideNewToast();
        }
        if (n2 == R.id.button_send) {
            this.presenter.sendTextMessage(this.editChat.getString());
            this.editChat.setText("");
        }
        if (n2 == R.id.button_attach) {
            this.hideKeyboard(this.editChat);
            IntentUtils.setNextActivity((Context)this, PhotoPickerActivity.class).startActivityForResult(902);
        }
    }

    @Override
    public void setPresenter(ChatContract$Presenter chatContract$Presenter) {
    }

    @Override
    public void onFileDownload(Message message) {
        IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", message.getFile().getUrl()).putExtra("filename", message.getFile().getFilename()).putExtra("image", message.getFile().isImage()).startActivity();
    }

    @Override
    public void onShowPhotoAlbum(File file) {
        IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("fileId", file.getId()).startActivityForResult(3001);
    }

    @Override
    public void onUrlClicked(String string) {
        Executor.goWeb((Context)this, string);
    }

    @Override
    public void sendingMessageClicked(SendingMessageItem sendingMessageItem) {
        sendingMessageItem = new AlertDialog.Builder((Context)this).setMessage((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.description")).setPositiveButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend"), (DialogInterface.OnClickListener)new c(this, sendingMessageItem)).setNegativeButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.cancel"), null).setNeutralButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.delete"), (DialogInterface.OnClickListener)new b(this, sendingMessageItem)).setCancelable(true).create();
        sendingMessageItem.setOnShowListener(new d(this, (AlertDialog)sendingMessageItem));
        sendingMessageItem.show();
    }

    static /* synthetic */ ChatContract$Presenter access$000(ChatActivity chatActivity) {
        return chatActivity.presenter;
    }
}

