/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.k;
import com.zoyi.channel.plugin.android.l;
import com.zoyi.channel.plugin.android.m;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.n;
import com.zoyi.channel.plugin.android.o;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;

public class ChannelView
extends RelativeLayout {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private int gravity;
    private int topMargin;
    private int bottomMargin;
    private int leftMargin;
    private int rightMargin;
    private View pushLayout;
    private AvatarLayout avatarLayout;
    private TextView textName;
    private TextView textMessage;
    private View fabLayout;
    private TextView badge;
    private FloatingActionButton fab;
    private Context context;
    private Animation pushAnimation;
    private Subscription subscription;
    private UserChat userChat;

    public ChannelView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ChannelView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public ChannelView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this);
        this.fabLayout = view.findViewById(R.id.fab_layout);
        this.badge = (TextView)view.findViewById(R.id.text_badge);
        this.fab = (FloatingActionButton)view.findViewById(R.id.fab);
        this.fab.setOnClickListener(new k(this));
        int n2 = context.getResources().getDimensionPixelSize(R.dimen.ch_default_channel_button_margin);
        attributeSet = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ChannelView, 0, 0);
        try {
            this.gravity = attributeSet.getInteger(R.styleable.ChannelView_channel_button_gravity, 3);
            this.topMargin = attributeSet.getDimensionPixelSize(R.styleable.ChannelView_channel_button_top_margin, n2);
            this.bottomMargin = attributeSet.getDimensionPixelSize(R.styleable.ChannelView_channel_button_bottom_margin, n2);
            this.leftMargin = attributeSet.getDimensionPixelSize(R.styleable.ChannelView_channel_button_left_margin, n2);
            this.rightMargin = attributeSet.getDimensionPixelSize(R.styleable.ChannelView_channel_button_right_margin, n2);
            this.setTopMargin(this.topMargin);
            this.setBottomMargin(this.bottomMargin);
            this.setLeftMargin(this.leftMargin);
            this.setRightMargin(this.rightMargin);
            this.setButtonGravity(this.gravity);
        }
        finally {
            if (attributeSet != null) {
                attributeSet.recycle();
            }
        }
        this.pushLayout = view.findViewById(R.id.push_layout);
        this.avatarLayout = (AvatarLayout)view.findViewById(R.id.push_avatar);
        this.textName = (TextView)view.findViewById(R.id.push_name);
        this.textMessage = (TextView)view.findViewById(R.id.push_message);
        this.pushAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ch_plugin_push);
        this.pushAnimation.setAnimationListener((Animation.AnimationListener)new l(this));
        view.findViewById(R.id.push_close).setOnClickListener((View.OnClickListener)new m(this));
        this.pushLayout.setOnClickListener((View.OnClickListener)new n(this, context));
    }

    public void setButtonGravity(int n2) {
        if (!CompareUtils.exists((Comparable)Integer.valueOf(n2), (Comparable[])new Integer[]{0, 1, 2, 3})) {
            return;
        }
        this.gravity = n2;
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.fabLayout.getLayoutParams();
        switch (n2) {
            case 0: 
            case 1: {
                layoutParams.addRule(10);
                layoutParams.addRule(12, 0);
                break;
            }
            case 2: 
            case 3: {
                layoutParams.addRule(12);
                layoutParams.addRule(10, 0);
            }
        }
        switch (n2) {
            case 0: 
            case 2: {
                if (Build.VERSION.SDK_INT >= 17) {
                    layoutParams.addRule(20);
                    layoutParams.addRule(21, 0);
                }
                layoutParams.addRule(9);
                layoutParams.addRule(11, 0);
                break;
            }
            case 1: 
            case 3: {
                if (Build.VERSION.SDK_INT >= 17) {
                    layoutParams.addRule(20, 0);
                    layoutParams.addRule(21);
                }
                layoutParams.addRule(9, 0);
                layoutParams.addRule(11);
            }
        }
        this.fabLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.fabLayout.requestLayout();
        this.badge.bringToFront();
    }

    public void setTopMargin(int n2) {
        this.topMargin = n2;
        this.refreshSize();
    }

    public void setBottomMargin(int n2) {
        this.bottomMargin = n2;
        this.refreshSize();
    }

    public void setLeftMargin(int n2) {
        this.leftMargin = n2;
        this.refreshSize();
    }

    public void setRightMargin(int n2) {
        this.rightMargin = n2;
        this.refreshSize();
    }

    private void refreshSize() {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.fabLayout.getLayoutParams();
        switch (this.gravity) {
            case 0: {
                layoutParams.setMargins(this.leftMargin, this.topMargin, 0, 0);
                break;
            }
            case 1: {
                layoutParams.setMargins(0, this.topMargin, this.rightMargin, 0);
                break;
            }
            case 2: {
                layoutParams.setMargins(this.leftMargin, 0, 0, this.bottomMargin);
                break;
            }
            case 3: {
                layoutParams.setMargins(0, 0, this.rightMargin, this.bottomMargin);
            }
        }
        this.fabLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.fabLayout.requestLayout();
        this.badge.bringToFront();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.subscription = RxBus.observable().onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe(new o(this));
        if (ChannelStore.getPlugin() != null) {
            this.checkedIn(ChannelStore.getPlugin());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
    }

    private void checkedIn(Plugin plugin) {
        if (plugin != null) {
            this.setVisibility(0);
            this.fab.setColorNormal(plugin.getBackgroundColor());
            this.fab.setColorPressed(Utils.addBlackMask(plugin.getBackgroundColor()));
            this.fab.setColorRipple(-1);
            this.fab.setImageResource(plugin.getTextColor() == -16777216 ? R.drawable.ch_plugin_balloon_black : R.drawable.ch_plugin_balloon);
            this.refreshCount();
            this.fabLayout.setVisibility(0);
        }
    }

    public void refreshCount() {
        this.setBadge(ChannelStore.getCount());
    }

    private void setBadge(int n2) {
        if (n2 <= 0) {
            this.badge.setVisibility(8);
            return;
        }
        this.badge.setVisibility(0);
        this.badge.setText((CharSequence)Utils.getCount(n2, true));
    }

    private void checkedOut() {
        this.setVisibility(8);
    }

    private void showPush(ProfileEntity profileEntity, String string2, UserChat userChat) {
        this.userChat = userChat;
        this.avatarLayout.set(profileEntity);
        if (profileEntity != null && profileEntity.getName() != null) {
            this.textName.setText((CharSequence)profileEntity.getName());
        } else {
            this.textName.setText((CharSequence)ResUtils.getString(this.context, "ch.unknown"));
        }
        this.textMessage.setText((CharSequence)(string2 != null ? string2 : ""));
        this.pushLayout.setVisibility(0);
        this.pushLayout.startAnimation(this.pushAnimation);
    }

    private void hidePush() {
        this.userChat = null;
        this.pushLayout.clearAnimation();
        this.pushLayout.setVisibility(8);
    }

    static /* synthetic */ Context access$000(ChannelView channelView) {
        return channelView.context;
    }

    static /* synthetic */ View access$100(ChannelView channelView) {
        return channelView.pushLayout;
    }

    static /* synthetic */ void access$200(ChannelView channelView) {
        channelView.hidePush();
    }

    static /* synthetic */ UserChat access$300(ChannelView channelView) {
        return channelView.userChat;
    }

    static /* synthetic */ void access$400(ChannelView channelView, Plugin plugin) {
        channelView.checkedIn(plugin);
    }

    static /* synthetic */ void access$500(ChannelView channelView) {
        channelView.checkedOut();
    }

    static /* synthetic */ void access$600(ChannelView channelView, ProfileEntity profileEntity, String string2, UserChat userChat) {
        channelView.showPush(profileEntity, string2, userChat);
    }

    static /* synthetic */ void access$700(ChannelView channelView, int n2) {
        channelView.setBadge(n2);
    }
}

