/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.io;

import com.splunk.mint.network.Counter;
import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.NetLogManager;
import com.splunk.mint.network.socket.MonitoringSocketImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class InputStreamMonitor
extends InputStream {
    private static final String IN_POSTFIX = "-bytes-in";
    private final InputStream original;
    private final Counter counter;
    private List<Byte> chars;
    private StringBuffer body;
    private boolean finishedReadingHeaders = false;
    public String exception = null;
    MonitoringSocketImpl monSocIm;
    private static final int MAX_POSSIBLE_HEADER_LENGTH = 90;
    boolean statusCodeFound = false;
    boolean contentLengthFound = false;
    HashMap<String, List<String>> headers = new HashMap(2);

    public InputStreamMonitor(String string, MonitorRegistry monitorRegistry, InputStream inputStream, MonitoringSocketImpl monitoringSocketImpl) {
        this.original = inputStream;
        this.counter = new Counter(string + IN_POSTFIX);
        this.chars = new ArrayList<Byte>();
        this.body = new StringBuffer();
        this.monSocIm = monitoringSocketImpl;
        this.finishedReadingHeaders = false;
        monitorRegistry.add(this.counter);
    }

    @Override
    public final int read() throws IOException {
        try {
            int n2 = this.original.read();
            if (n2 >= 0) {
                this.counter.inc();
            }
            if (!this.finishedReadingHeaders) {
                this.chars.add((byte)n2);
                this.updateBody();
            }
            return n2;
        }
        catch (IOException iOException) {
            this.exception = NetLogManager.exceptionToString(iOException);
            throw iOException;
        }
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        try {
            int n2 = this.original.read(byArray);
            if (n2 >= 0) {
                this.counter.inc(n2);
            }
            if (!this.finishedReadingHeaders) {
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    this.chars.add(byArray[i2]);
                }
                this.updateBody();
            }
            return n2;
        }
        catch (IOException iOException) {
            this.exception = NetLogManager.exceptionToString(iOException);
            throw iOException;
        }
    }

    @Override
    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            int n4 = this.original.read(byArray, n2, n3);
            if (n4 >= 0) {
                this.counter.inc(n4);
            }
            if (!this.finishedReadingHeaders) {
                while (n2 < n3) {
                    this.chars.add(byArray[n2]);
                    ++n2;
                }
                this.updateBody();
            }
            return n4;
        }
        catch (IOException iOException) {
            this.exception = NetLogManager.exceptionToString(iOException);
            throw iOException;
        }
    }

    private void updateBody() {
        byte[] byArray = new byte[this.chars.size()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = this.chars.get(i2);
        }
        this.chars.clear();
        this.body.append(new String(byArray));
        if (this.body.toString().contains("\r\n\r\n")) {
            this.finishedReadingHeaders = true;
            this.tryToReadHeaders();
        }
    }

    public final void tryToReadHeaders() {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.body.toString()));
        try {
            String[] stringArray;
            while ((stringArray = bufferedReader.readLine()) != null) {
                int n2;
                Object object;
                if (!this.statusCodeFound && stringArray.contains("HTTP/") && stringArray.length() < 90) {
                    try {
                        String[] stringArray2 = stringArray.split(" ");
                        object = new String[]{stringArray2[1].trim()};
                        this.headers.put("splk-statuscode", Arrays.asList(object));
                        this.statusCodeFound = true;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                }
                if (!this.contentLengthFound && stringArray.contains(":") && stringArray.length() < 90 && (n2 = stringArray.indexOf(":")) >= 0 && (object = stringArray.substring(0, n2).trim()).equals("Content-Length")) {
                    try {
                        stringArray = new String[]{stringArray.substring(n2 + 1, stringArray.length()).trim()};
                        this.headers.put((String)object, Arrays.asList(stringArray));
                        this.contentLengthFound = true;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                }
                if (!this.statusCodeFound || !this.contentLengthFound) continue;
                break;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        if (this.monSocIm != null) {
            this.monSocIm.readingDone();
        }
    }

    @Override
    public final void close() throws IOException {
        this.original.close();
    }

    public final HashMap<String, List<String>> getHeaders() {
        return this.headers;
    }
}

