package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zoyi.channel.plugin.android.R;

/**
 * Created by mika on 9/28/16.
 */
public class MenuButton extends RelativeLayout {
  MaskableFrameLayout mask;
  FrameLayout colorLayout;
  ImageView dummy;
  Drawable iconId;
  int color = Color.WHITE;
  private ActionType action;

  public MenuButton(Context context) {
    super(context);
    init(context, null);
  }

  public MenuButton(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public MenuButton(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  public MenuButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    super(context, attrs, defStyleAttr, defStyleRes);
    init(context, attrs);
  }

  private void init(Context context, AttributeSet attrs) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_menu_button, this);
    mask = (MaskableFrameLayout) findViewById(R.id.menu_icon_mask);
    colorLayout = (FrameLayout) findViewById(R.id.layout_color);
    dummy = (ImageView) findViewById(R.id.menu_icon_dummy);

    if (attrs != null) {
      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
          attrs,
          R.styleable.MenuButton,
          0,
          0);

      try {
        color = typedArray.getColor(R.styleable.MenuButton_ch_back_color, color);
        iconId = typedArray.getDrawable(R.styleable.MenuButton_ch_image);
      } finally {
        typedArray.recycle();
      }
    }

    setIcon(iconId);
    setColor(color);
  }

  public void setIcon(Drawable drawable) {
    if (drawable != null) {
      mask.setMask(drawable);
      dummy.setImageDrawable(drawable);
    }
  }

  public void setColor(int color) {
    colorLayout.setBackgroundColor(color);
  }

  public void setAction(ActionType action) {
    this.action = action;
    if (action != null && action.getIcon() != 0) {
      mask.setMask(action.getIcon());
      dummy.setImageResource(action.getIcon());
    }
  }

  public ActionType getAction() {
    return action;
  }

  public enum ActionType {
    DONE(3),
    MORE(4),
    BACK(5),
    EXIT(6),
    CAMERA(7),
    REFRESH(8);

    private int value;
    ActionType(int value) {
      this.value = value;
    }

    public int getIcon() {
      if (value == DONE.value) {
        return R.drawable.ch_plugin_ic_done_white_24dp;
      }
      if (value == MORE.value) {
        return R.drawable.ch_plugin_menu;
      }
      if (value == BACK.value) {
        return R.drawable.ch_plugin_chevron_left;
      }
      if (value == EXIT.value) {
        return R.drawable.ch_plugin_exit_white;
      }
      if (value == CAMERA.value) {
        return R.drawable.ch_plugin_ic_photo_camera_white_24dp;
      }
      if (value == REFRESH.value) {
        return R.drawable.ch_plugin_bar_refresh;
      }
      return 0;
    }
  }


  public enum MenuState {
    VISIBLE, DISABLED, HIDDEN
  }
}
