package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.model.wrapper.DeviceTokenBox;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ScriptsWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserVeilWrapper;
import com.zoyi.retrofit2.http.Body;
import com.zoyi.retrofit2.http.GET;
import com.zoyi.retrofit2.http.Header;
import com.zoyi.retrofit2.http.HeaderMap;
import com.zoyi.retrofit2.http.Headers;
import com.zoyi.retrofit2.http.Multipart;
import com.zoyi.retrofit2.http.POST;
import com.zoyi.retrofit2.http.PUT;
import com.zoyi.retrofit2.http.Part;
import com.zoyi.retrofit2.http.Path;
import com.zoyi.retrofit2.http.Query;
import com.zoyi.retrofit2.okhttp3.MultipartBody;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.Observable;

import java.util.Map;

/**
 * Created by mika on 2016. 1. 20..
 */
public interface ChannelApi {
  @GET("packages/{packageId}/versions/latest")
  Observable<PackageWrapper> getLastestPackage(@Path("packageId") String packageId, @Query("from") String from);

  @Headers({"Content-Type: application/json"})
  @POST("/app/plugins/{key}/check_in")
  Observable<PluginWrapper> checkIn(@HeaderMap Map<String, String> headers, @Path("key") String key, @Query("url") String url, @Body RequestBody body);

  @GET("/app/plugins/{key}")
  Observable<PluginWrapper> getPlugin(@Path("key") String key);

  @GET("/app/scripts")
  Observable<ScriptsWrapper> getScripts();

  @GET("/app/guests/me")
  Observable<GuestWrapper> getMe();

  @GET("/app/user_chats")
  Observable<UserChatsWrapper> getUserChats(@Query("sortField") String sortField, @Query("sortOrder") String sortOrder, @Query("limit") Integer limit);

  @GET("/app/user_chats/{userChatId}")
  Observable<UserChatWrapper> getUserChat(@Path("userChatId") String userChatId);

  @GET("/app/user_chats/{userChatId}/messages")
  Observable<MessagesWrapper> getMessages(@Path("userChatId") String userChatId, @Query("since") String since, @Query("limit") Integer limit, @Query("sortOrder") String sortOrder);

  @POST("/app/user_chats")
  Observable<UserChatWrapper> createUserChat(@Header("X-Plugin-Key") String key);

  @PUT("/app/user_chats/{userChatId}/messages/read_all")
  Observable<Void> readAll(@Path("userChatId") String userChatId);

  @Headers({"Content-Type: application/json"})
  @POST("/app/user_chats/{userChatId}/messages")
  Observable<MessageWrapper> sendMessage(@Path("userChatId") String userChatId, @Body RequestBody body);

  @Multipart
  @POST("/app/user_chats/{userChatId}/messages/file")
  Observable<MessageWrapper> uploadFile(@Path("userChatId") String userChatId, @Part MultipartBody.Part file, @Part("requestId") RequestBody requestId);

  @Headers({"Content-Type: application/json"})
  @PUT("/app/guests")
  Observable<UserVeilWrapper> updateGuest(@Body RequestBody body);

  @Headers({"Content-Type: application/json"})
  @POST("app/device_tokens")
  Observable<DeviceTokenBox> sendToken(@Body RequestBody body);
}
