/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.handler;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

public abstract class InfiniteScrollListener
extends RecyclerView.OnScrollListener {
    public static final int BOTTOM = -1;
    public static final int TOP = 1;
    private static int THRESHOLD = 3;
    int firstVisibleItem;
    int childCount;
    int totalItemCount;
    int previousTotal = 0;
    private LinearLayoutManager manager;
    private int direction;

    protected InfiniteScrollListener(LinearLayoutManager manager, int direction) {
        this.manager = manager;
        this.direction = direction;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        if (this.firstVisibleItem != this.manager.findFirstVisibleItemPosition()) {
            this.firstItem(this.manager.findFirstVisibleItemPosition());
        }
        this.childCount = recyclerView.getChildCount();
        this.totalItemCount = this.manager.getItemCount();
        this.firstVisibleItem = this.manager.findFirstVisibleItemPosition();
        if (this.childCount + this.firstVisibleItem >= this.totalItemCount) {
            this.scrollAttachedToBottom();
        }
        if (dy * this.direction > 0) {
            return;
        }
        if (this.totalItemCount == 0) {
            return;
        }
        this.previousTotal = this.totalItemCount;
        if (this.direction == 1 && this.firstVisibleItem > THRESHOLD) {
            return;
        }
        if (this.direction == -1 && this.totalItemCount - this.childCount > this.firstVisibleItem) {
            return;
        }
        this.refresh();
    }

    public void scrollAttachedToBottom() {
    }

    public abstract void refresh();

    public void firstItem(int index) {
    }
}

