/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.functions.Func2;
import com.zoyi.rx.observers.SerializedSubscriber;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import com.zoyi.rx.subscriptions.SerialSubscription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class OnSubscribeJoin<TLeft, TRight, TLeftDuration, TRightDuration, R>
implements Observable.OnSubscribe<R> {
    final Observable<TLeft> left;
    final Observable<TRight> right;
    final Func1<TLeft, Observable<TLeftDuration>> leftDurationSelector;
    final Func1<TRight, Observable<TRightDuration>> rightDurationSelector;
    final Func2<TLeft, TRight, R> resultSelector;

    public OnSubscribeJoin(Observable<TLeft> left, Observable<TRight> right, Func1<TLeft, Observable<TLeftDuration>> leftDurationSelector, Func1<TRight, Observable<TRightDuration>> rightDurationSelector, Func2<TLeft, TRight, R> resultSelector) {
        this.left = left;
        this.right = right;
        this.leftDurationSelector = leftDurationSelector;
        this.rightDurationSelector = rightDurationSelector;
        this.resultSelector = resultSelector;
    }

    @Override
    public void call(Subscriber<? super R> t1) {
        ResultSink result = new ResultSink(new SerializedSubscriber<R>(t1));
        result.run();
    }

    final class ResultSink
    extends HashMap<Integer, TLeft> {
        private static final long serialVersionUID = 3491669543549085380L;
        final CompositeSubscription group;
        final Subscriber<? super R> subscriber;
        boolean leftDone;
        int leftId;
        boolean rightDone;
        int rightId;
        final Map<Integer, TRight> rightMap;

        public ResultSink(Subscriber<? super R> subscriber) {
            this.subscriber = subscriber;
            this.group = new CompositeSubscription();
            this.rightMap = new HashMap();
        }

        HashMap<Integer, TLeft> leftMap() {
            return this;
        }

        public void run() {
            this.subscriber.add(this.group);
            LeftSubscriber s1 = new LeftSubscriber();
            RightSubscriber s2 = new RightSubscriber();
            this.group.add(s1);
            this.group.add(s2);
            OnSubscribeJoin.this.left.unsafeSubscribe(s1);
            OnSubscribeJoin.this.right.unsafeSubscribe(s2);
        }

        final class RightSubscriber
        extends Subscriber<TRight> {
            RightSubscriber() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void expire(int id, Subscription resource) {
                boolean complete = false;
                ResultSink resultSink = ResultSink.this;
                synchronized (resultSink) {
                    if (ResultSink.this.rightMap.remove(id) != null && ResultSink.this.rightMap.isEmpty() && ResultSink.this.rightDone) {
                        complete = true;
                    }
                }
                if (complete) {
                    ResultSink.this.subscriber.onCompleted();
                    ResultSink.this.subscriber.unsubscribe();
                } else {
                    ResultSink.this.group.remove(resource);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(TRight args) {
                int highLeftId;
                int id;
                ResultSink resultSink = ResultSink.this;
                synchronized (resultSink) {
                    id = ResultSink.this.rightId++;
                    ResultSink.this.rightMap.put(id, args);
                    highLeftId = ResultSink.this.leftId;
                }
                SerialSubscription md = new SerialSubscription();
                ResultSink.this.group.add(md);
                try {
                    Observable duration = OnSubscribeJoin.this.rightDurationSelector.call(args);
                    RightDurationSubscriber d2 = new RightDurationSubscriber(id);
                    ResultSink.this.group.add(d2);
                    duration.unsafeSubscribe(d2);
                    ArrayList leftValues = new ArrayList();
                    ResultSink resultSink2 = ResultSink.this;
                    synchronized (resultSink2) {
                        for (Map.Entry entry : ResultSink.this.leftMap().entrySet()) {
                            if (entry.getKey() >= highLeftId) continue;
                            leftValues.add(entry.getValue());
                        }
                    }
                    for (Object lv : leftValues) {
                        Object result = OnSubscribeJoin.this.resultSelector.call(lv, args);
                        ResultSink.this.subscriber.onNext(result);
                    }
                }
                catch (Throwable t) {
                    Exceptions.throwOrReport(t, this);
                }
            }

            @Override
            public void onError(Throwable e) {
                ResultSink.this.subscriber.onError(e);
                ResultSink.this.subscriber.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                boolean complete = false;
                ResultSink resultSink = ResultSink.this;
                synchronized (resultSink) {
                    ResultSink.this.rightDone = true;
                    if (ResultSink.this.leftDone || ResultSink.this.rightMap.isEmpty()) {
                        complete = true;
                    }
                }
                if (complete) {
                    ResultSink.this.subscriber.onCompleted();
                    ResultSink.this.subscriber.unsubscribe();
                } else {
                    ResultSink.this.group.remove(this);
                }
            }

            final class RightDurationSubscriber
            extends Subscriber<TRightDuration> {
                final int id;
                boolean once = true;

                public RightDurationSubscriber(int id) {
                    this.id = id;
                }

                @Override
                public void onNext(TRightDuration args) {
                    this.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    RightSubscriber.this.onError(e);
                }

                @Override
                public void onCompleted() {
                    if (this.once) {
                        this.once = false;
                        RightSubscriber.this.expire(this.id, this);
                    }
                }
            }
        }

        final class LeftSubscriber
        extends Subscriber<TLeft> {
            LeftSubscriber() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void expire(int id, Subscription resource) {
                boolean complete = false;
                ResultSink resultSink = ResultSink.this;
                synchronized (resultSink) {
                    if (ResultSink.this.leftMap().remove(id) != null && ResultSink.this.leftMap().isEmpty() && ResultSink.this.leftDone) {
                        complete = true;
                    }
                }
                if (complete) {
                    ResultSink.this.subscriber.onCompleted();
                    ResultSink.this.subscriber.unsubscribe();
                } else {
                    ResultSink.this.group.remove(resource);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(TLeft args) {
                int highRightId;
                int id;
                ResultSink resultSink = ResultSink.this;
                synchronized (resultSink) {
                    id = ResultSink.this.leftId++;
                    ResultSink.this.leftMap().put(id, args);
                    highRightId = ResultSink.this.rightId;
                }
                try {
                    Observable duration = OnSubscribeJoin.this.leftDurationSelector.call(args);
                    LeftDurationSubscriber d1 = new LeftDurationSubscriber(id);
                    ResultSink.this.group.add(d1);
                    duration.unsafeSubscribe(d1);
                    ArrayList rightValues = new ArrayList();
                    ResultSink resultSink2 = ResultSink.this;
                    synchronized (resultSink2) {
                        for (Map.Entry entry : ResultSink.this.rightMap.entrySet()) {
                            if (entry.getKey() >= highRightId) continue;
                            rightValues.add(entry.getValue());
                        }
                    }
                    for (Object r : rightValues) {
                        Object result = OnSubscribeJoin.this.resultSelector.call(args, r);
                        ResultSink.this.subscriber.onNext(result);
                    }
                }
                catch (Throwable t) {
                    Exceptions.throwOrReport(t, this);
                }
            }

            @Override
            public void onError(Throwable e) {
                ResultSink.this.subscriber.onError(e);
                ResultSink.this.subscriber.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                boolean complete = false;
                ResultSink resultSink = ResultSink.this;
                synchronized (resultSink) {
                    ResultSink.this.leftDone = true;
                    if (ResultSink.this.rightDone || ResultSink.this.leftMap().isEmpty()) {
                        complete = true;
                    }
                }
                if (complete) {
                    ResultSink.this.subscriber.onCompleted();
                    ResultSink.this.subscriber.unsubscribe();
                } else {
                    ResultSink.this.group.remove(this);
                }
            }

            final class LeftDurationSubscriber
            extends Subscriber<TLeftDuration> {
                final int id;
                boolean once = true;

                public LeftDurationSubscriber(int id) {
                    this.id = id;
                }

                @Override
                public void onNext(TLeftDuration args) {
                    this.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    LeftSubscriber.this.onError(e);
                }

                @Override
                public void onCompleted() {
                    if (this.once) {
                        this.once = false;
                        LeftSubscriber.this.expire(this.id, this);
                    }
                }
            }
        }
    }
}

