/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.presenter.settings;

import android.app.ProgressDialog;
import android.content.Context;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.model.wrapper.UserVeilWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.presenter.settings.ProfileEditContract;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

public class ProfileEditPresenter
implements ProfileEditContract.Presenter {
    private Context context;
    private ProgressDialog dialog;
    private ProfileEditContract.View view;

    public ProfileEditPresenter(Context context) {
        this.context = context;
    }

    @Override
    public void setView(ProfileEditContract.View view) {
        this.view = view;
    }

    @Override
    public void showProgress() {
        if (this.dialog == null || !this.dialog.isShowing()) {
            this.dialog = ProgressHelper.show(this.context, ResUtils.getString(this.context, "ch.settings.changing_message"));
        }
    }

    @Override
    public void hideProgress() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    @Override
    public void updateUserName(String name) {
        this.updateUser(RequestUtils.form().set("name", name).create());
    }

    @Override
    public void updateUserMobileNumber(String mobileNumber) {
        this.updateUser(RequestUtils.form().set("mobileNumber", mobileNumber).create());
    }

    private void updateUser(RequestBody body) {
        this.showProgress();
        ChannelPlugin.getApi().updateGuest(body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserVeilWrapper>(){

            @Override
            public void onError(RetrofitException e) {
                ProfileEditPresenter.this.hideProgress();
                ProfileEditPresenter.this.view.onUpdateFailed(e.getMessage());
            }

            @Override
            public void onNext(UserVeilWrapper wrapper) {
                ProfileEditPresenter.this.hideProgress();
                if (wrapper != null) {
                    ChannelStore.setUserVeil(wrapper.getUser(), wrapper.getVeil());
                    ProfileEditPresenter.this.view.onUpdateSuccessed();
                }
            }
        });
    }
}

