/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.animation.Animator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TopNavBus;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.ConstraintUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.dialog.WorkingTimeDialog;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimatorListener;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;
import java.util.List;

public class TopNavFragment
extends Fragment
implements View.OnClickListener {
    private static final int ANIMATION_DURATION = 400;
    private Context context;
    private ConstraintLayout root;
    private CHTextView textManagerDesc;
    private CHTextView textResponse;
    private CHTextView textResDesc;
    private CHTextView textWorkingTimeDetail;
    private AvatarLayout assignManager;
    private AvatarLayout firstAvatar;
    private AvatarLayout secondAvatar;
    private AvatarLayout thirdAvatar;
    private View layoutTopNav;
    private View layoutManagerBox;
    private View managerAvatarBox;
    private View layoutOnline;
    private View onlineFrame;
    private View layoutAvatarBox;
    private View layoutResponseBox;
    private View layoutWorkingTime;
    private View reconnectView;
    @Nullable
    private Channel channel;
    @Nullable
    private Person person;
    @Nullable
    private List<Manager> followingManagers;
    private boolean isReady = false;
    private boolean isAnimating = false;
    private boolean avatarAnimated = false;
    @Nullable
    private OnChatTopNavListener listener;
    private Subscription subscription;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.ch_plugin_fragment_chat_top_nav, container, false);
    }

    @Initializer
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.context = this.getActivity();
        this.root = (ConstraintLayout)view.findViewById(R.id.root_chat_top_nav);
        this.root.setOnClickListener((View.OnClickListener)this);
        this.layoutTopNav = view.findViewById(R.id.layout_top_nav);
        this.layoutManagerBox = view.findViewById(R.id.layout_manager_box);
        this.managerAvatarBox = view.findViewById(R.id.layout_manager_avatar_box);
        this.assignManager = (AvatarLayout)view.findViewById(R.id.layout_avatar_manager);
        this.textManagerDesc = (CHTextView)view.findViewById(R.id.tv_manager_description);
        this.layoutOnline = view.findViewById(R.id.layout_online);
        this.onlineFrame = view.findViewById(R.id.view_online_frame);
        this.layoutAvatarBox = view.findViewById(R.id.layout_avatar_box);
        this.firstAvatar = (AvatarLayout)view.findViewById(R.id.layout_avatar_first);
        this.secondAvatar = (AvatarLayout)view.findViewById(R.id.layout_avatar_second);
        this.thirdAvatar = (AvatarLayout)view.findViewById(R.id.layout_avatar_third);
        this.layoutResponseBox = view.findViewById(R.id.layout_response_box);
        this.textResponse = (CHTextView)view.findViewById(R.id.tv_chat_response);
        this.textResDesc = (CHTextView)view.findViewById(R.id.tv_chat_res_description);
        this.layoutWorkingTime = view.findViewById(R.id.layout_working_time);
        this.textWorkingTimeDetail = (CHTextView)view.findViewById(R.id.tv_working_time_detail);
        this.layoutWorkingTime.setOnClickListener((View.OnClickListener)this);
        this.reconnectView = view.findViewById(R.id.layout_reconnect);
        this.initChannel();
        this.subscribe();
    }

    public void onDestroyView() {
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        super.onDestroyView();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.root_chat_top_nav && this.listener != null) {
            this.listener.onClickTopNav();
        }
        if (id2 == R.id.layout_working_time && this.channel != null) {
            new WorkingTimeDialog(this.context, this.channel.getWorkingTime(this.context)).show();
        }
    }

    private void initChannel() {
        this.channel = ChannelSelector.getCurrentChannel();
        this.layoutTopNav.setBackgroundColor(ColorSelector.getBackgroundColor());
        this.onlineFrame.getBackground().setColorFilter(ColorSelector.getBackgroundColor(), PorterDuff.Mode.SRC_ATOP);
        this.assignManager.setBorderColor(ColorSelector.getBackgroundColor());
        this.firstAvatar.setBorderColor(ColorSelector.getBackgroundColor());
        this.secondAvatar.setBorderColor(ColorSelector.getBackgroundColor());
        this.thirdAvatar.setBorderColor(ColorSelector.getBackgroundColor());
        this.textManagerDesc.setTextColor(ColorSelector.getTextColor());
        this.textResponse.setTextColor(ColorSelector.getTextColor());
        this.textResDesc.setTextColor(ColorSelector.getTextColor());
        this.textWorkingTimeDetail.setTextColor(ColorSelector.getTextColor());
    }

    public void setReconnectVisibility(boolean show) {
        if (this.reconnectView == null) {
            return;
        }
        if (this.isReady) {
            ConstraintUtils.connect(this.root, R.id.layout_reconnect, 3, R.id.layout_top_nav, 4);
        } else {
            ConstraintUtils.connect(this.root, R.id.layout_reconnect, 3, R.id.root_chat_top_nav, 3);
        }
        this.reconnectView.setVisibility(UIUtils.getVisible(show, false));
    }

    public boolean isExpand() {
        return this.layoutTopNav != null && this.layoutTopNav.getVisibility() == 0;
    }

    public View getRoot() {
        return this.root;
    }

    public View getLayoutTopNav() {
        return this.layoutTopNav;
    }

    public int getExpectHeight() {
        int newWidthSpec = View.MeasureSpec.makeMeasureSpec((int)this.root.getWidth(), (int)0x40000000);
        this.layoutTopNav.measure(newWidthSpec, 0);
        return this.layoutTopNav.getMeasuredHeight();
    }

    public void setOnChatTopNavListener(OnChatTopNavListener listener) {
        this.listener = listener;
    }

    public void set(@Nullable Person person) {
        this.initChannel();
        this.layoutManagerBox.setVisibility(0);
        this.layoutResponseBox.setVisibility(8);
        this.layoutAvatarBox.setVisibility(8);
        this.layoutWorkingTime.setVisibility(8);
        boolean isSamePerson = this.isSamePerson(this.person, person);
        this.person = person;
        this.assignManager.set(person);
        if (person != null && person instanceof Manager) {
            this.layoutOnline.setVisibility(UIUtils.getVisible(((Manager)person).getOnline(), true));
        } else {
            this.layoutOnline.setVisibility(8);
        }
        if (!isSamePerson) {
            this.managerAvatarBox.animate().scaleX(1.0f).scaleY(1.0f).start();
        } else {
            this.managerAvatarBox.setScaleX(1.0f);
            this.managerAvatarBox.setScaleY(1.0f);
        }
        this.isReady = true;
    }

    private boolean isSamePerson(@Nullable Person p1, @Nullable Person p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.getPersonType().equals(p2.getPersonType()) && p1.getId().equals(p2.getId());
    }

    public void set(List<Manager> followingManagers) {
        this.initChannel();
        if (this.channel == null) {
            return;
        }
        this.layoutManagerBox.setVisibility(4);
        this.setAvatar(followingManagers);
        this.setResponse();
        this.setWorkingTime();
        this.isReady = true;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        this.setResponse();
        this.setWorkingTime();
        this.setAvatar();
    }

    private void setAvatar() {
        this.setAvatar(this.followingManagers);
    }

    public void setAvatar(@Nullable List<Manager> followingManagers) {
        int size;
        if (followingManagers == null || followingManagers.isEmpty()) {
            this.layoutAvatarBox.setVisibility(8);
            return;
        }
        this.followingManagers = followingManagers;
        this.layoutAvatarBox.setVisibility(0);
        int n = size = ChatResponseManager.showOnlyOneManager(this.channel) ? 1 : followingManagers.size();
        if (size == 1) {
            this.showOnlyFirstAvatar(followingManagers);
        } else if (size == 2) {
            this.firstAvatar.set(followingManagers.get(0));
            this.firstAvatar.setVisibility(0);
            this.secondAvatar.set(followingManagers.get(1));
            this.secondAvatar.setVisibility(0);
            this.thirdAvatar.setVisibility(8);
        } else {
            this.firstAvatar.set(followingManagers.get(0));
            this.firstAvatar.setVisibility(0);
            this.secondAvatar.set(followingManagers.get(1));
            this.secondAvatar.setVisibility(0);
            this.thirdAvatar.set(followingManagers.get(2));
            this.thirdAvatar.setVisibility(0);
        }
    }

    private void showOnlyFirstAvatar(List<Manager> followingManagers) {
        this.firstAvatar.set(followingManagers.get(0));
        this.firstAvatar.setVisibility(0);
        this.secondAvatar.setVisibility(8);
        this.thirdAvatar.setVisibility(8);
    }

    private void setResponse() {
        this.layoutResponseBox.setVisibility(0);
        this.textResponse.setCompoundDrawablesWithIntrinsicBounds(0, 0, ChatResponseManager.getResponseSymbol(this.channel), 0);
        this.textResponse.setTextByKey(ChatResponseManager.getResponseKey(this.channel));
        String responseDescription = ChatResponseManager.getResponseDescriptionKey(this.channel);
        this.textResDesc.setTextByKey(responseDescription);
    }

    private void setWorkingTime() {
        if (this.channel == null || this.channel.isWorking() || "never".equals(this.channel.getWorkingType()) || this.channel.getWorkingTime(this.context) == null) {
            this.layoutWorkingTime.setVisibility(8);
        } else {
            this.layoutWorkingTime.setVisibility(0);
        }
    }

    private void subscribe() {
        this.subscription = RxBus.observable().subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                if (o != null) {
                    if (o instanceof TopNavBus.TranslationY) {
                        TopNavFragment.this.setTranslationY(((TopNavBus.TranslationY)o).value);
                    } else if (o instanceof TopNavBus.Expand) {
                        TopNavFragment.this.expand();
                    } else if (o instanceof TopNavBus.Collapse) {
                        TopNavFragment.this.collapse();
                    }
                }
            }
        });
    }

    public void setTranslationY(float value) {
        if (this.root == null) {
            return;
        }
        this.layoutTopNav.setVisibility((float)this.layoutTopNav.getHeight() == Math.abs(value) ? 4 : 0);
        this.root.setTranslationY(value);
        this.animateAvatar();
    }

    public void expand() {
        if (!this.isReady) {
            return;
        }
        this.layoutTopNav.setVisibility(0);
        if (this.root == null || this.root.getHeight() <= 0 || this.isAnimating) {
            return;
        }
        this.root.animate().translationY(0.0f).setDuration(400L).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                TopNavFragment.this.isAnimating = true;
                TopNavFragment.this.animateAvatar();
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                TopNavFragment.this.isAnimating = false;
            }
        }).start();
    }

    private void animateAvatar() {
        if (!this.avatarAnimated) {
            this.avatarAnimated = true;
            this.processAvatarScale(this.firstAvatar, 200L);
            this.processAvatarScale(this.secondAvatar, 250L);
            this.processAvatarScale(this.thirdAvatar, 300L);
        }
    }

    private void processAvatarScale(final AvatarLayout avatarLayout, long delayMillis) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                avatarLayout.animate().scaleX(1.0f).scaleY(1.0f).start();
            }
        }, delayMillis);
    }

    public void collapse() {
        if (!this.isReady || this.root == null || this.root.getHeight() <= 0 || this.isAnimating) {
            return;
        }
        this.root.animate().translationY((float)(-this.layoutTopNav.getHeight())).setDuration(400L).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                TopNavFragment.this.isAnimating = true;
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                TopNavFragment.this.isAnimating = false;
                TopNavFragment.this.layoutTopNav.setVisibility(4);
            }
        }).start();
    }

    public static interface OnChatTopNavListener {
        public void onClickTopNav();
    }
}

