/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class DeviceUtils {
    @SuppressLint(value={"HardwareIds"})
    public static String getWId(Context context) {
        try {
            WifiInfo wifiInfo;
            WifiManager manager;
            if (Build.VERSION.SDK_INT < 23 && context != null && context.getApplicationContext() != null && (manager = (WifiManager)context.getApplicationContext().getSystemService("wifi")) != null && (wifiInfo = manager.getConnectionInfo()) != null && wifiInfo.getMacAddress() != null && !"02:00:00:00:00:00".equals(wifiInfo.getMacAddress())) {
                return manager.getConnectionInfo().getMacAddress();
            }
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            String interfaceName = "wlan0";
            for (NetworkInterface networkInterface : interfaces) {
                if (!networkInterface.getName().equalsIgnoreCase(interfaceName)) continue;
                byte[] mac = networkInterface.getHardwareAddress();
                if (mac == null) {
                    return null;
                }
                StringBuilder buf = new StringBuilder();
                for (byte aMac : mac) {
                    buf.append(String.format("%02X:", aMac));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                return buf.toString().trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

