/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.model.Error;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.reflect.TypeToken;
import com.zoyi.okhttp3.ResponseBody;
import com.zoyi.retrofit2.HttpException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class RetrofitException
extends RuntimeException {
    private List<Error> errors;
    private final Kind kind;

    private static RetrofitException networkError(IOException exception) {
        return new RetrofitException(Kind.NETWORK, new ArrayList<Error>(Collections.singleton(new Error("Network Error"))));
    }

    private static RetrofitException unexpectedError(Throwable exception) {
        return new RetrofitException(Kind.UNEXPECTED, new ArrayList<Error>(Collections.singleton(new Error(exception.getMessage()))));
    }

    public static RetrofitException create(Throwable throwable) {
        if (throwable instanceof HttpException) {
            HttpException httpException = (HttpException)throwable;
            ResponseBody errorResponse = httpException.response().errorBody();
            Gson gson = new Gson();
            try {
                if (errorResponse == null) {
                    return RetrofitException.unexpectedError(throwable);
                }
                JSONObject jsonObject = new JSONObject(errorResponse.toString());
                if (jsonObject.has("error")) {
                    return new RetrofitException(Kind.HTTP, new ArrayList<Error>(Collections.singleton((Error)gson.fromJson(jsonObject.getString("error"), Error.class))));
                }
                if (jsonObject.has("errors")) {
                    List errors = (List)gson.fromJson(jsonObject.getString("errors"), new TypeToken<List<Error>>(){}.getType());
                    return new RetrofitException(Kind.HTTP, errors);
                }
                return RetrofitException.unexpectedError(throwable);
            }
            catch (Exception e) {
                L.e(e.getMessage());
                return RetrofitException.unexpectedError(throwable);
            }
        }
        if (throwable instanceof IOException) {
            return RetrofitException.networkError((IOException)throwable);
        }
        return RetrofitException.unexpectedError(throwable);
    }

    private RetrofitException(Kind kind, List<Error> errors) {
        this.kind = kind;
        this.errors = errors;
    }

    public Kind getKind() {
        return this.kind;
    }

    @Override
    public String getMessage() {
        ArrayList<String> list = new ArrayList<String>();
        for (Error error : this.errors) {
            list.add(error.getMessage());
        }
        return StringUtils.join(list, "\n");
    }

    public static enum Kind {
        NETWORK,
        HTTP,
        UNEXPECTED;

    }
}

