package com.zoyi.channel.plugin.android.store;

import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.CompareUtils;

import java.util.Collection;

/**
 * Created by mika on 2018. 6. 18..
 */

public class UserChatStore extends RecordUpdatesCollectionStore<UserChat> {

  private boolean showClosed = true;
  private boolean canUpdate = false;

  @Override
  protected StoreType getStoreType() {
    return StoreType.USER_CHAT;
  }

  @Override
  protected boolean canUpdate(UserChat oldbie, UserChat newbie) {
    return super.canUpdate(oldbie, newbie) && canUpdate;
  }

  @Override
  public synchronized void set(Collection<UserChat> list) {
    canUpdate = true;
    super.set(list);
  }

  public void setCanUpdate(boolean canUpdate) {
    this.canUpdate = canUpdate;
  }

  public void setShowClosed(boolean showCompleted) {
    this.showClosed = showCompleted;
  }

  public String[] getStateFilters() {
    return (showClosed ? Const.USER_CHAT_STATE_CONTAIN_CLOSED : Const.USER_CHAT_STATE_EXCEPT_CLOSED).split("&");
  }

  @Override
  protected void updated(UserChat userChat) {
    if (userChat != null) {
      if (!CompareUtils.exists(userChat.getState(), getStateFilters())) {
        removed(userChat);
      } else {
        super.updated(userChat);
      }
    }
  }
}
