/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.com.bumptech.glide.h;
import com.zoyi.com.bumptech.glide.load.b.e;

public class AvatarLayout
extends FrameLayout {
    Context context;
    ImageView back;
    ImageView image;
    TextView text;

    public AvatarLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public AvatarLayout(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public AvatarLayout(Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context, attributeSet);
    }

    @TargetApi(value=21)
    public AvatarLayout(Context context, @Nullable AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.init(context, attributeSet);
    }

    protected void init(Context context, AttributeSet attributeSet) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_avatar, (ViewGroup)this);
        this.back = (ImageView)view.findViewById(R.id.back_profile);
        this.image = (ImageView)view.findViewById(R.id.image_profile);
        this.text = (TextView)view.findViewById(R.id.text_profile);
        int n2 = 16;
        if (attributeSet != null) {
            context = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.AvatarLayout, 0, 0);
            try {
                n2 = context.getDimensionPixelSize(R.styleable.AvatarLayout_ch_initialSize, 16);
            }
            finally {
                context.recycle();
            }
        }
        this.text.setTextSize(0, (float)n2);
    }

    private void reset(boolean bl) {
        if (bl) {
            this.back.setBackgroundColor(-1);
            this.image.setVisibility(0);
            this.text.setVisibility(8);
            return;
        }
        this.image.setVisibility(8);
        this.text.setVisibility(0);
    }

    public void set(ProfileEntity profileEntity) {
        if (profileEntity == null) {
            this.reset(false);
            this.back.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.ch_dark));
            this.text.setTextColor(-1);
            this.text.setText((CharSequence)"?");
            return;
        }
        if (profileEntity.getAvatarUrl() != null) {
            this.reset(true);
            h.b(this.getContext()).a(profileEntity.getAvatarUrl()).a().b().b(e.b).a(this.image);
            return;
        }
        this.reset(false);
        this.back.setBackgroundColor(profileEntity.getBackgroundColor());
        this.text.setTextColor(profileEntity.getTextColor());
        this.text.setText((CharSequence)profileEntity.getInitial());
    }

    public void setTextSize(int n2) {
        this.text.setTextSize(2, (float)n2);
    }
}

