/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.http;

import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.http.MonitorableHttpURLConnection;
import com.splunk.mint.network.http.URLStreamHandlerBase;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public final class HTTPURLStreamHandler
extends URLStreamHandlerBase {
    private static final String[] SYSTEM_CLASSES = new String[]{"libcore.net.http.HttpURLConnectionImpl", "org.apache.harmony.luni.internal.net.www.protocol.http.HttpURLConnectionImpl", "org.apache.harmony.luni.internal.net.www.protocol.http.HttpURLConnection"};
    private static final int PORT = 80;
    private static final String PROTOCOL = "http";
    private final MonitorRegistry registry;

    public HTTPURLStreamHandler(MonitorRegistry registry) throws ClassNotFoundException {
        super(SYSTEM_CLASSES);
        this.registry = registry;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection openConnection = super.openConnection(url);
        return new MonitorableHttpURLConnection(this.registry, openConnection);
    }

    @Override
    protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        URLConnection openConnection = super.openConnection(url, proxy);
        return new MonitorableHttpURLConnection(this.registry, openConnection);
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }
}

