/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.load.model;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.util.Log;
import com.zoyi.com.bumptech.glide.load.data.DataFetcher;
import com.zoyi.com.bumptech.glide.load.model.ModelLoader;

public class ResourceLoader<T>
implements ModelLoader<Integer, T> {
    private static final String TAG = "ResourceLoader";
    private final ModelLoader<Uri, T> uriLoader;
    private final Resources resources;

    public ResourceLoader(Context context, ModelLoader<Uri, T> uriLoader) {
        this(context.getResources(), uriLoader);
    }

    public ResourceLoader(Resources resources, ModelLoader<Uri, T> uriLoader) {
        this.resources = resources;
        this.uriLoader = uriLoader;
    }

    @Override
    public DataFetcher<T> getResourceFetcher(Integer model, int width, int height) {
        Uri uri;
        block3: {
            uri = null;
            try {
                uri = Uri.parse((String)("android.resource://" + this.resources.getResourcePackageName(model.intValue()) + '/' + this.resources.getResourceTypeName(model.intValue()) + '/' + this.resources.getResourceEntryName(model.intValue())));
            }
            catch (Resources.NotFoundException e) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block3;
                Log.w((String)TAG, (String)("Received invalid resource id: " + model), (Throwable)e);
            }
        }
        if (uri != null) {
            return this.uriLoader.getResourceFetcher(uri, width, height);
        }
        return null;
    }
}

