package com.zoyi.channel.plugin.android.presenter.userchat;

import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatCheckListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;

import java.util.Queue;

public interface UserChatAdapterContract {

  interface View {

    void setOnUserChatClickListener(OnUserChatClickListener clickListener);
    void setOnUserChatCheckListener(OnUserChatCheckListener checkListener);

    void setEditMode(boolean editMode);
    void removeUserChat(UserChat userChat);
    void checkUserChat(String chatId);
  }

  interface Model {

    void init(UserChatsWrapper wrapper);
    void stopRefreshBySocket();
    void receiveChannelModel(ChannelModel channelModel, boolean upsert);

    void clearCheckedChatId();
    boolean hasCheckedChatIds();
    String getCheckedChatId();
  }

}
