/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.annotation.SuppressLint;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.view.Display;
import android.view.WindowManager;
import com.splunk.mint.Logger;
import com.splunk.mint.Mint;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

class Utils {
    private static final int Verbose = 10;
    private static final int Debug = 20;
    private static final int Info = 30;
    private static final int Warning = 50;
    private static final int Error = 60;
    protected static final String CONNECTION = "connection";
    protected static final String STATE = "state";

    Utils() {
    }

    protected static String getRandomSessionNumber() {
        return UUID.randomUUID().toString();
    }

    protected static String getScreenOrientation(Context gContext) {
        Display display = ((WindowManager)gContext.getSystemService("window")).getDefaultDisplay();
        int orientation = display.getOrientation();
        String rotation = "NA";
        switch (orientation) {
            case 0: {
                rotation = "Portrait";
                break;
            }
            case 2: {
                rotation = "PortraitUpsideDown";
                break;
            }
            case 3: {
                rotation = "LandscapeLeft";
                break;
            }
            case 1: {
                rotation = "LandscapeRight";
            }
        }
        return rotation;
    }

    protected static final boolean isKitKat() {
        return Build.VERSION.SDK_INT == 19;
    }

    protected static int convertLoggingLevelToInt(MintLogLevel level) {
        if (level.equals((Object)MintLogLevel.Debug)) {
            return 20;
        }
        if (level.equals((Object)MintLogLevel.Error)) {
            return 60;
        }
        if (level.equals((Object)MintLogLevel.Info)) {
            return 30;
        }
        if (level.equals((Object)MintLogLevel.Verbose)) {
            return 10;
        }
        if (level.equals((Object)MintLogLevel.Warning)) {
            return 50;
        }
        return 10;
    }

    protected static HashMap<String, String> getConnectionInfo(Context context) {
        HashMap<String, String> infoMap;
        block13: {
            infoMap = new HashMap<String, String>(2);
            infoMap.put(CONNECTION, "NA");
            infoMap.put(STATE, "NA");
            if (context == null) {
                if (Mint.DEBUG) {
                    Logger.logError("Context in getConnection is null!");
                }
            } else {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager == null) {
                    if (Mint.DEBUG) {
                        Logger.logError("PackageManager in CheckNetworkConnection is null!");
                    }
                } else {
                    try {
                        if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", Properties.APP_PACKAGE) == 0) {
                            ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                            NetworkInfo info = mConnectivityManager.getActiveNetworkInfo();
                            if (info != null) {
                                if (info.getSubtypeName() == null || info.getSubtypeName().length() == 0) {
                                    infoMap.put(CONNECTION, info.getTypeName());
                                } else {
                                    infoMap.put(CONNECTION, info.getSubtypeName());
                                }
                                infoMap.put(STATE, info.getState().toString());
                            } else {
                                infoMap.put(CONNECTION, "No Connection");
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!Mint.DEBUG) break block13;
                        Logger.logError("Could not get network connection state");
                        e.printStackTrace();
                    }
                }
            }
        }
        return infoMap;
    }

    protected static byte isGPSOn(Context gContext) {
        byte gps_status;
        block5: {
            gps_status = 0;
            PackageManager packageManager = gContext.getPackageManager();
            try {
                if (packageManager.checkPermission("android.permission.ACCESS_FINE_LOCATION", Properties.APP_PACKAGE) == 0) {
                    LocationManager locManager = (LocationManager)gContext.getSystemService("location");
                    if (!locManager.isProviderEnabled("gps")) {
                        gps_status = 1;
                    }
                } else {
                    gps_status = 2;
                }
            }
            catch (Exception e) {
                gps_status = 2;
                if (!Mint.DEBUG) break block5;
                Logger.logError("Could not get GPS state");
                e.printStackTrace();
            }
        }
        return gps_status;
    }

    protected static final String getTime() {
        String time = String.valueOf(System.currentTimeMillis());
        try {
            time = String.valueOf(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L);
        }
        catch (Exception e) {
            Logger.logWarning("Could not get the UTC time");
        }
        return time;
    }

    protected static boolean checkForRoot() {
        String[] directories;
        boolean foundSU = false;
        for (String dir : directories = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"}) {
            File file = new File(dir + "su");
            if (!file.exists()) continue;
            foundSU = true;
            break;
        }
        return foundSU;
    }

    protected static final Long getMilisFromStart() {
        if (Properties.TIMESTAMP == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - Properties.TIMESTAMP;
    }

    protected static final String getCarrier(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        if (manager != null) {
            String carrier = null;
            try {
                if (manager.getSimState() == 5) {
                    carrier = manager.getSimOperatorName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (carrier == null || carrier.length() == 0) {
                    carrier = manager.getNetworkOperatorName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (carrier == null || carrier.length() == 0) {
                carrier = "NA";
            }
            return carrier;
        }
        return "NA";
    }

    protected static String readFile(String filePath) throws Exception {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath Argument is null");
        }
        StringBuilder sb1 = new StringBuilder();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(filePath));
            String line = null;
            while ((line = input.readLine()) != null) {
                sb1.append(line);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return sb1.toString();
    }

    protected static final String readLogs() {
        int lines = Properties.LOG_LINES;
        if (lines < 0) {
            lines = 100;
        }
        String filter = Properties.LOG_FILTER;
        StringBuilder log = new StringBuilder();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("logcat -d " + filter);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            ArrayList<String> linesList = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                linesList.add(line);
            }
            if (linesList.size() == 0) {
                return "You must add the android.permission.READ_LOGS permission to your manifest file!";
            }
            int start = linesList.size() - lines;
            if (start < 0) {
                start = 0;
            }
            for (int index = start; index < linesList.size(); ++index) {
                log.append((String)linesList.get(index) + "\n");
            }
            linesList = null;
            return log.toString().replaceAll(Pattern.quote("}{^"), "}{ ^");
        }
        catch (Exception e) {
            Logger.logError("Error reading logcat output!");
            return e.getMessage();
        }
    }

    protected static final HashMap<String, String> getMemoryInfo() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        try {
            boolean memTotalFound = false;
            boolean memFreeFound = false;
            String[] arguments = new String[]{"/system/bin/cat", "/proc/meminfo"};
            ProcessBuilder cmd = new ProcessBuilder(arguments);
            Process process = cmd.start();
            InputStream in = process.getInputStream();
            StringBuilder sb1 = new StringBuilder();
            byte[] re = new byte[1024];
            while (in.read(re) != -1) {
                sb1.append(new String(re));
                String[] lines = sb1.toString().split("kB");
                if (lines.length < 2) continue;
                DecimalFormat nft = new DecimalFormat("#.##");
                for (String line : lines) {
                    if (!memTotalFound && line.contains("MemTotal:")) {
                        String memTotal = line.substring(line.indexOf(" "), line.lastIndexOf(" ")).trim();
                        map.put("memTotal", String.valueOf(nft.format(Float.valueOf(memTotal).floatValue() / 1024.0f)));
                        memTotalFound = true;
                    }
                    if (memFreeFound || !line.contains("MemFree:")) continue;
                    String memFree = line.substring(line.indexOf(" "), line.lastIndexOf(" ")).trim();
                    map.put("memFree", String.valueOf(nft.format(Float.valueOf(memFree).floatValue() / 1024.0f)));
                    memFreeFound = true;
                }
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return map;
    }

    protected static boolean allowedToSendData() {
        if (!Properties.flushOnlyOverWiFi) {
            return true;
        }
        return Properties.CONNECTION.equals("WIFI");
    }

    @SuppressLint(value={"NewApi"})
    protected static String isFSEncrypted(Context context) {
        DevicePolicyManager devicePolicyManager;
        if (context != null && (devicePolicyManager = (DevicePolicyManager)context.getSystemService("device_policy")) != null && Build.VERSION.SDK_INT > 11) {
            try {
                int status = devicePolicyManager.getStorageEncryptionStatus();
                if (3 == status) {
                    return "true";
                }
                return "false";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "NA";
    }

    public static int getBatteryLevel(Context context) {
        Intent batteryIntent;
        int currentapiVersion = Build.VERSION.SDK_INT;
        if (currentapiVersion >= 5 && (batteryIntent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"))) != null) {
            int level = batteryIntent.getIntExtra("level", -1);
            int scale = batteryIntent.getIntExtra("scale", -1);
            if (level == -1 || scale == -1) {
                return 50;
            }
            return Math.round((float)level / (float)scale * 100.0f);
        }
        return 50;
    }
}

