/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Func0;
import com.zoyi.rx.observables.ConnectableObservable;
import com.zoyi.rx.observers.Subscribers;
import com.zoyi.rx.subjects.Subject;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class OperatorMulticast<T, R>
extends ConnectableObservable<R> {
    final Observable<? extends T> source;
    final Object guard;
    final Func0<? extends Subject<? super T, ? extends R>> subjectFactory;
    final AtomicReference<Subject<? super T, ? extends R>> connectedSubject;
    final List<Subscriber<? super R>> waitingForConnect;
    Subscriber<T> subscription;
    Subscription guardedSubscription;

    public OperatorMulticast(Observable<? extends T> source, Func0<? extends Subject<? super T, ? extends R>> subjectFactory) {
        this(new Object(), new AtomicReference<Subject<? super T, ? extends R>>(), new ArrayList<Subscriber<? super R>>(), source, subjectFactory);
    }

    private OperatorMulticast(final Object guard, final AtomicReference<Subject<? super T, ? extends R>> connectedSubject, final List<Subscriber<? super R>> waitingForConnect, Observable<? extends T> source, Func0<? extends Subject<? super T, ? extends R>> subjectFactory) {
        super(new Observable.OnSubscribe<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(Subscriber<? super R> subscriber) {
                Object object = guard;
                synchronized (object) {
                    if (connectedSubject.get() == null) {
                        waitingForConnect.add(subscriber);
                    } else {
                        ((Subject)connectedSubject.get()).unsafeSubscribe(subscriber);
                    }
                }
            }
        });
        this.guard = guard;
        this.connectedSubject = connectedSubject;
        this.waitingForConnect = waitingForConnect;
        this.source = source;
        this.subjectFactory = subjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Action1<? super Subscription> connection) {
        Subscriber<T> sub;
        Object object = this.guard;
        synchronized (object) {
            if (this.subscription != null) {
                connection.call(this.guardedSubscription);
                return;
            }
            Subject<T, R> subject = this.subjectFactory.call();
            this.subscription = Subscribers.from(subject);
            final AtomicReference<Subscription> gs = new AtomicReference<Subscription>();
            gs.set(Subscriptions.create(new Action0(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void call() {
                    Subscriber s;
                    Object object = OperatorMulticast.this.guard;
                    synchronized (object) {
                        if (OperatorMulticast.this.guardedSubscription != gs.get()) {
                            return;
                        }
                        s = OperatorMulticast.this.subscription;
                        OperatorMulticast.this.subscription = null;
                        OperatorMulticast.this.guardedSubscription = null;
                        OperatorMulticast.this.connectedSubject.set(null);
                    }
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            }));
            this.guardedSubscription = (Subscription)gs.get();
            for (final Subscriber<? super R> subscriber : this.waitingForConnect) {
                subject.unsafeSubscribe(new Subscriber<R>(subscriber){

                    @Override
                    public void onNext(R t) {
                        subscriber.onNext(t);
                    }

                    @Override
                    public void onError(Throwable e) {
                        subscriber.onError(e);
                    }

                    @Override
                    public void onCompleted() {
                        subscriber.onCompleted();
                    }
                });
            }
            this.waitingForConnect.clear();
            this.connectedSubject.set(subject);
        }
        connection.call(this.guardedSubscription);
        Object object2 = this.guard;
        synchronized (object2) {
            sub = this.subscription;
        }
        if (sub != null) {
            this.source.subscribe(sub);
        }
    }
}

