/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicLong;

public final class OperatorTakeLast<T>
implements Observable.Operator<T, T> {
    final int count;

    public OperatorTakeLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count cannot be negative");
        }
        this.count = count;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        final TakeLastSubscriber<? super T> parent = new TakeLastSubscriber<T>(subscriber, this.count);
        subscriber.add(parent);
        subscriber.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.requestMore(n);
            }
        });
        return parent;
    }

    static final class TakeLastSubscriber<T>
    extends Subscriber<T>
    implements Func1<Object, T> {
        final Subscriber<? super T> actual;
        final AtomicLong requested;
        final ArrayDeque<Object> queue;
        final int count;
        final NotificationLite<T> nl;

        public TakeLastSubscriber(Subscriber<? super T> actual, int count) {
            this.actual = actual;
            this.count = count;
            this.requested = new AtomicLong();
            this.queue = new ArrayDeque();
            this.nl = NotificationLite.instance();
        }

        @Override
        public void onNext(T t) {
            if (this.queue.size() == this.count) {
                this.queue.poll();
            }
            this.queue.offer(this.nl.next(t));
        }

        @Override
        public void onError(Throwable e) {
            this.queue.clear();
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            BackpressureUtils.postCompleteDone(this.requested, this.queue, this.actual, this);
        }

        @Override
        public T call(Object t) {
            return this.nl.getValue(t);
        }

        void requestMore(long n) {
            if (n > 0L) {
                BackpressureUtils.postCompleteRequest(this.requested, n, this.queue, this.actual, this);
            }
        }
    }
}

