/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout$1;

public class MaskableFrameLayout
extends FrameLayout {
    private static final String TAG = "MaskableFrameLayout";
    private static final int MODE_ADD = 0;
    private static final int MODE_CLEAR = 1;
    private static final int MODE_DARKEN = 2;
    private static final int MODE_DST = 3;
    private static final int MODE_DST_ATOP = 4;
    private static final int MODE_DST_IN = 5;
    private static final int MODE_DST_OUT = 6;
    private static final int MODE_DST_OVER = 7;
    private static final int MODE_LIGHTEN = 8;
    private static final int MODE_MULTIPLY = 9;
    private static final int MODE_OVERLAY = 10;
    private static final int MODE_SCREEN = 11;
    private static final int MODE_SRC = 12;
    private static final int MODE_SRC_ATOP = 13;
    private static final int MODE_SRC_IN = 14;
    private static final int MODE_SRC_OUT = 15;
    private static final int MODE_SRC_OVER = 16;
    private static final int MODE_XOR = 17;
    private Handler mHandler;
    private Drawable mDrawableMask = null;
    private Bitmap mFinalMask = null;
    private boolean mAntiAliasing = false;
    private Paint mPaint = null;
    private PorterDuffXfermode mPorterDuffXferMode = null;

    public MaskableFrameLayout(Context context) {
        super(context);
    }

    public MaskableFrameLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.construct(context, attributeSet);
    }

    public MaskableFrameLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.construct(context, attributeSet);
    }

    /*
     * Unable to fully structure code
     */
    private void construct(Context var1_1, AttributeSet var2_2) {
        this.mHandler = new Handler();
        this.setDrawingCacheEnabled(true);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.mPaint = this.createPaint(false);
        if ((var1_1 = var1_1.getTheme()) != null) {
            var1_1 = var1_1.obtainStyledAttributes(var2_2, R.styleable.MaskableLayout, 0, 0);
            try {
                this.initMask(this.loadMask((TypedArray)var1_1));
                this.mPorterDuffXferMode = this.getModeFromInteger(var1_1.getInteger(R.styleable.MaskableLayout_ch_porterduffxfermode, 0));
                this.initMask(this.mDrawableMask);
                if (!var1_1.getBoolean(R.styleable.MaskableLayout_ch_anti_aliasing, false)) ** GOTO lbl20
                this.mPaint = this.createPaint(true);
            }
            finally {
                if (var1_1 != null) {
                    var1_1.recycle();
                }
            }
        } else {
            this.log("Couldn't load theme, mask in xml won't be loaded.");
        }
lbl20:
        // 3 sources

        this.registerMeasure();
    }

    private Paint createPaint(boolean bl) {
        Paint paint = new Paint(1);
        paint.setAntiAlias(bl);
        paint.setXfermode((Xfermode)this.mPorterDuffXferMode);
        return paint;
    }

    private Drawable loadMask(TypedArray typedArray) {
        return typedArray.getDrawable(R.styleable.MaskableLayout_ch_mask);
    }

    private void initMask(Drawable drawable2) {
        if (drawable2 != null) {
            this.mDrawableMask = drawable2;
            if (this.mDrawableMask instanceof AnimationDrawable) {
                this.mDrawableMask.setCallback((Drawable.Callback)this);
                return;
            }
        } else {
            this.log("Are you sure you don't want to provide a mask ?");
        }
    }

    public Drawable getDrawableMask() {
        return this.mDrawableMask;
    }

    private Bitmap makeBitmapMask(Drawable drawable2) {
        if (drawable2 != null) {
            if (this.getMeasuredWidth() > 0 && this.getMeasuredHeight() > 0) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.getMeasuredWidth(), (int)this.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable2.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
                drawable2.draw(canvas);
                return bitmap;
            }
            this.log("Can't create a mask with height 0 or width 0. Or the layout has no children and is wrap content");
            return null;
        }
        this.log("No bitmap mask loaded, view will NOT be masked !");
        return null;
    }

    public void setMask(int n2) {
        Resources resources = this.getResources();
        if (resources != null) {
            this.setMask(resources.getDrawable(n2));
            return;
        }
        this.log("Unable to load resources, mask will not be loaded as drawable");
    }

    public void setMask(Drawable drawable2) {
        this.initMask(drawable2);
        this.swapBitmapMask(this.makeBitmapMask(this.mDrawableMask));
        this.invalidate();
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        this.setSize(n2, n3);
    }

    private void setSize(int n2, int n3) {
        if (n2 > 0 && n3 > 0) {
            if (this.mDrawableMask != null) {
                this.swapBitmapMask(this.makeBitmapMask(this.mDrawableMask));
                return;
            }
        } else {
            this.log("Width and height must be higher than 0");
        }
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mFinalMask != null && this.mPaint != null) {
            this.mPaint.setXfermode((Xfermode)this.mPorterDuffXferMode);
            canvas.drawBitmap(this.mFinalMask, 0.0f, 0.0f, this.mPaint);
            this.mPaint.setXfermode(null);
            return;
        }
        this.log("Mask or paint is null ...");
    }

    private void registerMeasure() {
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new MaskableFrameLayout$1(this, viewTreeObserver));
        }
    }

    private void log(String string2) {
    }

    public void invalidateDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            this.initMask(drawable2);
            this.swapBitmapMask(this.makeBitmapMask(drawable2));
            this.invalidate();
        }
    }

    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l2) {
        if (drawable2 != null && runnable != null) {
            this.mHandler.postAtTime(runnable, l2);
        }
    }

    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        if (drawable2 != null && runnable != null) {
            this.mHandler.removeCallbacks(runnable);
        }
    }

    private void swapBitmapMask(Bitmap bitmap) {
        if (bitmap != null) {
            if (this.mFinalMask != null && !this.mFinalMask.isRecycled()) {
                this.mFinalMask.recycle();
            }
            this.mFinalMask = bitmap;
        }
    }

    private PorterDuffXfermode getModeFromInteger(int n2) {
        PorterDuff.Mode mode;
        switch (n2) {
            case 0: {
            }
            case 1: {
                mode = PorterDuff.Mode.CLEAR;
                break;
            }
            case 2: {
                mode = PorterDuff.Mode.DARKEN;
                break;
            }
            case 3: {
                mode = PorterDuff.Mode.DST;
                break;
            }
            case 4: {
                mode = PorterDuff.Mode.DST_ATOP;
                break;
            }
            case 5: {
                mode = PorterDuff.Mode.DST_IN;
                break;
            }
            case 6: {
                mode = PorterDuff.Mode.DST_OUT;
                break;
            }
            case 7: {
                mode = PorterDuff.Mode.DST_OVER;
                break;
            }
            case 8: {
                mode = PorterDuff.Mode.LIGHTEN;
                break;
            }
            case 9: {
                mode = PorterDuff.Mode.MULTIPLY;
                break;
            }
            case 10: {
            }
            case 11: {
                mode = PorterDuff.Mode.SCREEN;
                break;
            }
            case 12: {
                mode = PorterDuff.Mode.SRC;
                break;
            }
            case 13: {
                mode = PorterDuff.Mode.SRC_ATOP;
                break;
            }
            case 14: {
                mode = PorterDuff.Mode.SRC_IN;
                break;
            }
            case 15: {
                mode = PorterDuff.Mode.SRC_OUT;
                break;
            }
            case 16: {
                mode = PorterDuff.Mode.SRC_OVER;
                break;
            }
            case 17: {
                mode = PorterDuff.Mode.XOR;
                break;
            }
            default: {
                mode = PorterDuff.Mode.DST_IN;
            }
        }
        return new PorterDuffXfermode(mode);
    }

    static /* synthetic */ void access$000(MaskableFrameLayout maskableFrameLayout, String string2) {
        maskableFrameLayout.log(string2);
    }

    static /* synthetic */ Drawable access$100(MaskableFrameLayout maskableFrameLayout) {
        return maskableFrameLayout.mDrawableMask;
    }

    static /* synthetic */ Bitmap access$200(MaskableFrameLayout maskableFrameLayout, Drawable drawable2) {
        return maskableFrameLayout.makeBitmapMask(drawable2);
    }

    static /* synthetic */ void access$300(MaskableFrameLayout maskableFrameLayout, Bitmap bitmap) {
        maskableFrameLayout.swapBitmapMask(bitmap);
    }
}

