/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.photoview.gestures;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.zoyi.channel.plugin.android.view.external.photoview.gestures.GestureDetector;
import com.zoyi.channel.plugin.android.view.external.photoview.gestures.OnGestureListener;
import com.zoyi.channel.plugin.android.view.external.photoview.log.LogManager;

public class CupcakeGestureDetector
implements GestureDetector {
    protected OnGestureListener mListener;
    private static final String LOG_TAG = "CupcakeGestureDetector";
    float mLastTouchX;
    float mLastTouchY;
    final float mTouchSlop;
    final float mMinimumVelocity;
    private VelocityTracker mVelocityTracker;
    private boolean mIsDragging;

    @Override
    public void setOnGestureListener(OnGestureListener onGestureListener) {
        this.mListener = onGestureListener;
    }

    public CupcakeGestureDetector(Context context) {
        context = ViewConfiguration.get((Context)context);
        this.mMinimumVelocity = context.getScaledMinimumFlingVelocity();
        this.mTouchSlop = context.getScaledTouchSlop();
    }

    float getActiveX(MotionEvent motionEvent) {
        return motionEvent.getX();
    }

    float getActiveY(MotionEvent motionEvent) {
        return motionEvent.getY();
    }

    @Override
    public boolean isScaling() {
        return false;
    }

    @Override
    public boolean isDragging() {
        return this.mIsDragging;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.mVelocityTracker = VelocityTracker.obtain();
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.addMovement(motionEvent);
                } else {
                    LogManager.getLogger().i(LOG_TAG, "Velocity tracker is null");
                }
                this.mLastTouchX = this.getActiveX(motionEvent);
                this.mLastTouchY = this.getActiveY(motionEvent);
                this.mIsDragging = false;
                break;
            }
            case 2: {
                float f2 = this.getActiveX(motionEvent);
                float f3 = this.getActiveY(motionEvent);
                float f4 = f2 - this.mLastTouchX;
                float f5 = f3 - this.mLastTouchY;
                if (!this.mIsDragging) {
                    boolean bl = this.mIsDragging = Math.sqrt(f4 * f4 + f5 * f5) >= (double)this.mTouchSlop;
                }
                if (!this.mIsDragging) break;
                this.mListener.onDrag(f4, f5);
                this.mLastTouchX = f2;
                this.mLastTouchY = f3;
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.addMovement(motionEvent);
                break;
            }
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 1: {
                if (this.mIsDragging && this.mVelocityTracker != null) {
                    this.mLastTouchX = this.getActiveX(motionEvent);
                    this.mLastTouchY = this.getActiveY(motionEvent);
                    this.mVelocityTracker.addMovement(motionEvent);
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float f6 = this.mVelocityTracker.getXVelocity();
                    float f7 = this.mVelocityTracker.getYVelocity();
                    if (Math.max(Math.abs(f6), Math.abs(f7)) >= this.mMinimumVelocity) {
                        this.mListener.onFling(this.mLastTouchX, this.mLastTouchY, -f6, -f7);
                    }
                }
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }
}

