/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation;

import android.util.Log;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.FloatEvaluator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.FloatKeyframeSet;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.IntEvaluator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.IntKeyframeSet;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Keyframe;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.KeyframeSet;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.PropertyValuesHolder$1;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.PropertyValuesHolder$FloatPropertyValuesHolder;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.PropertyValuesHolder$IntPropertyValuesHolder;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.TypeEvaluator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.util.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PropertyValuesHolder
implements Cloneable {
    String mPropertyName;
    protected Property mProperty;
    Method mSetter = null;
    private Method mGetter = null;
    Class mValueType;
    KeyframeSet mKeyframeSet = null;
    private static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    private static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    private static Class[] FLOAT_VARIANTS = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
    private static Class[] INTEGER_VARIANTS = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
    private static Class[] DOUBLE_VARIANTS = new Class[]{Double.TYPE, Double.class, Float.TYPE, Integer.TYPE, Float.class, Integer.class};
    private static final HashMap<Class, HashMap<String, Method>> sSetterPropertyMap = new HashMap();
    private static final HashMap<Class, HashMap<String, Method>> sGetterPropertyMap = new HashMap();
    final ReentrantReadWriteLock mPropertyMapLock = new ReentrantReadWriteLock();
    final Object[] mTmpValueArray = new Object[1];
    private TypeEvaluator mEvaluator;
    private Object mAnimatedValue;

    private PropertyValuesHolder(String string2) {
        this.mPropertyName = string2;
    }

    private PropertyValuesHolder(Property property) {
        this.mProperty = property;
        if (property != null) {
            this.mPropertyName = property.getName();
        }
    }

    public static PropertyValuesHolder ofInt(String string2, int ... nArray) {
        return new PropertyValuesHolder$IntPropertyValuesHolder(string2, nArray);
    }

    public static PropertyValuesHolder ofInt(Property<?, Integer> property, int ... nArray) {
        return new PropertyValuesHolder$IntPropertyValuesHolder(property, nArray);
    }

    public static PropertyValuesHolder ofFloat(String string2, float ... fArray) {
        return new PropertyValuesHolder$FloatPropertyValuesHolder(string2, fArray);
    }

    public static PropertyValuesHolder ofFloat(Property<?, Float> property, float ... fArray) {
        return new PropertyValuesHolder$FloatPropertyValuesHolder(property, fArray);
    }

    public static PropertyValuesHolder ofObject(String object, TypeEvaluator typeEvaluator, Object ... objectArray) {
        object = new PropertyValuesHolder((String)object);
        ((PropertyValuesHolder)object).setObjectValues(objectArray);
        ((PropertyValuesHolder)object).setEvaluator(typeEvaluator);
        return object;
    }

    public static <V> PropertyValuesHolder ofObject(Property object, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        object = new PropertyValuesHolder((Property)object);
        ((PropertyValuesHolder)object).setObjectValues(VArray);
        ((PropertyValuesHolder)object).setEvaluator(typeEvaluator);
        return object;
    }

    public static PropertyValuesHolder ofKeyframe(String object, Keyframe ... keyframeArray) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(keyframeArray);
        if (keyframeSet instanceof IntKeyframeSet) {
            return new PropertyValuesHolder$IntPropertyValuesHolder((String)object, (IntKeyframeSet)keyframeSet);
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            return new PropertyValuesHolder$FloatPropertyValuesHolder((String)object, (FloatKeyframeSet)keyframeSet);
        }
        object = new PropertyValuesHolder((String)object);
        v0.mKeyframeSet = keyframeSet;
        ((PropertyValuesHolder)object).mValueType = keyframeArray[0].getType();
        return object;
    }

    public static PropertyValuesHolder ofKeyframe(Property object, Keyframe ... keyframeArray) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(keyframeArray);
        if (keyframeSet instanceof IntKeyframeSet) {
            return new PropertyValuesHolder$IntPropertyValuesHolder((Property)object, (IntKeyframeSet)keyframeSet);
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            return new PropertyValuesHolder$FloatPropertyValuesHolder((Property)object, (FloatKeyframeSet)keyframeSet);
        }
        object = new PropertyValuesHolder((Property)object);
        v0.mKeyframeSet = keyframeSet;
        ((PropertyValuesHolder)object).mValueType = keyframeArray[0].getType();
        return object;
    }

    public void setIntValues(int ... nArray) {
        this.mValueType = Integer.TYPE;
        this.mKeyframeSet = KeyframeSet.ofInt(nArray);
    }

    public void setFloatValues(float ... fArray) {
        this.mValueType = Float.TYPE;
        this.mKeyframeSet = KeyframeSet.ofFloat(fArray);
    }

    public void setKeyframes(Keyframe ... keyframeArray) {
        int n2 = keyframeArray.length;
        Keyframe[] keyframeArray2 = new Keyframe[Math.max(n2, 2)];
        this.mValueType = keyframeArray[0].getType();
        for (int i2 = 0; i2 < n2; ++i2) {
            keyframeArray2[i2] = keyframeArray[i2];
        }
        this.mKeyframeSet = new KeyframeSet(keyframeArray2);
    }

    public void setObjectValues(Object ... objectArray) {
        this.mValueType = objectArray[0].getClass();
        this.mKeyframeSet = KeyframeSet.ofObject(objectArray);
    }

    private Method getPropertyFunction(Class clazz, String string2, Class classArray) {
        Method method = null;
        string2 = PropertyValuesHolder.getMethodName(string2, this.mPropertyName);
        if (classArray == null) {
            try {
                method = clazz.getMethod(string2, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getDeclaredMethod(string2, null);
                    method.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Log.e((String)"PropertyValuesHolder", (String)("Couldn't find no-arg method for property " + this.mPropertyName + ": " + noSuchMethodException));
                }
            }
        } else {
            Class[] classArray2;
            classArray = new Class[1];
            if (this.mValueType.equals(Float.class)) {
                classArray2 = FLOAT_VARIANTS;
            } else if (this.mValueType.equals(Integer.class)) {
                classArray2 = INTEGER_VARIANTS;
            } else if (this.mValueType.equals(Double.class)) {
                classArray2 = DOUBLE_VARIANTS;
            } else {
                Class[] classArray3 = new Class[1];
                classArray2 = classArray3;
                classArray3[0] = this.mValueType;
            }
            int n2 = classArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class clazz2;
                classArray[0] = clazz2 = classArray2[i2];
                try {
                    method = clazz.getMethod(string2, classArray);
                    this.mValueType = clazz2;
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method = clazz.getDeclaredMethod(string2, classArray);
                        method.setAccessible(true);
                        this.mValueType = clazz2;
                        return method;
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        continue;
                    }
                }
            }
            Log.e((String)"PropertyValuesHolder", (String)("Couldn't find setter/getter for property " + this.mPropertyName + " with value type " + this.mValueType));
        }
        return method;
    }

    private Method setupSetterOrGetter(Class clazz, HashMap<Class, HashMap<String, Method>> hashMap, String string2, Class clazz2) {
        Method method = null;
        try {
            this.mPropertyMapLock.writeLock().lock();
            HashMap<String, Method> hashMap2 = hashMap.get(clazz);
            if (hashMap2 != null) {
                method = hashMap2.get(this.mPropertyName);
            }
            if (method == null) {
                method = this.getPropertyFunction(clazz, string2, clazz2);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    hashMap.put(clazz, hashMap2);
                }
                hashMap2.put(this.mPropertyName, method);
            }
        }
        finally {
            this.mPropertyMapLock.writeLock().unlock();
        }
        return method;
    }

    void setupSetter(Class clazz) {
        this.mSetter = this.setupSetterOrGetter(clazz, sSetterPropertyMap, "set", this.mValueType);
    }

    private void setupGetter(Class clazz) {
        this.mGetter = this.setupSetterOrGetter(clazz, sGetterPropertyMap, "get", null);
    }

    void setupSetterAndGetter(Object object) {
        if (this.mProperty != null) {
            try {
                this.mProperty.get(object);
                for (Keyframe keyframe : this.mKeyframeSet.mKeyframes) {
                    if (keyframe.hasValue()) continue;
                    keyframe.setValue(this.mProperty.get(object));
                }
                return;
            }
            catch (ClassCastException classCastException) {
                Log.e((String)"PropertyValuesHolder", (String)("No such property (" + this.mProperty.getName() + ") on target object " + object + ". Trying reflection instead"));
                this.mProperty = null;
            }
        }
        Class<?> clazz = object.getClass();
        if (this.mSetter == null) {
            this.setupSetter(clazz);
        }
        for (Keyframe keyframe : this.mKeyframeSet.mKeyframes) {
            if (keyframe.hasValue()) continue;
            if (this.mGetter == null) {
                this.setupGetter(clazz);
            }
            try {
                keyframe.setValue(this.mGetter.invoke(object, new Object[0]));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
            }
        }
    }

    private void setupValue(Object object, Keyframe keyframe) {
        if (this.mProperty != null) {
            keyframe.setValue(this.mProperty.get(object));
        }
        try {
            if (this.mGetter == null) {
                Class<?> clazz = object.getClass();
                this.setupGetter(clazz);
            }
            keyframe.setValue(this.mGetter.invoke(object, new Object[0]));
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
            return;
        }
    }

    void setupStartValue(Object object) {
        this.setupValue(object, this.mKeyframeSet.mKeyframes.get(0));
    }

    void setupEndValue(Object object) {
        this.setupValue(object, this.mKeyframeSet.mKeyframes.get(this.mKeyframeSet.mKeyframes.size() - 1));
    }

    public PropertyValuesHolder clone() {
        try {
            PropertyValuesHolder propertyValuesHolder = (PropertyValuesHolder)super.clone();
            ((PropertyValuesHolder)super.clone()).mPropertyName = this.mPropertyName;
            propertyValuesHolder.mProperty = this.mProperty;
            propertyValuesHolder.mKeyframeSet = this.mKeyframeSet.clone();
            propertyValuesHolder.mEvaluator = this.mEvaluator;
            return propertyValuesHolder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    void setAnimatedValue(Object object) {
        if (this.mProperty != null) {
            this.mProperty.set(object, this.getAnimatedValue());
        }
        if (this.mSetter != null) {
            try {
                this.mTmpValueArray[0] = this.getAnimatedValue();
                this.mSetter.invoke(object, this.mTmpValueArray);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
            }
        }
    }

    void init() {
        if (this.mEvaluator == null) {
            TypeEvaluator typeEvaluator = this.mValueType == Integer.class ? sIntEvaluator : (this.mEvaluator = this.mValueType == Float.class ? sFloatEvaluator : null);
        }
        if (this.mEvaluator != null) {
            this.mKeyframeSet.setEvaluator(this.mEvaluator);
        }
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        this.mEvaluator = typeEvaluator;
        this.mKeyframeSet.setEvaluator(typeEvaluator);
    }

    void calculateValue(float f2) {
        this.mAnimatedValue = this.mKeyframeSet.getValue(f2);
    }

    public void setPropertyName(String string2) {
        this.mPropertyName = string2;
    }

    public void setProperty(Property property) {
        this.mProperty = property;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    public String toString() {
        return this.mPropertyName + ": " + this.mKeyframeSet.toString();
    }

    static String getMethodName(String string2, String string3) {
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        char c2 = Character.toUpperCase(string3.charAt(0));
        string3 = string3.substring(1);
        return string2 + c2 + string3;
    }

    /* synthetic */ PropertyValuesHolder(String string2, PropertyValuesHolder$1 propertyValuesHolder$1) {
        this(string2);
    }

    /* synthetic */ PropertyValuesHolder(Property property, PropertyValuesHolder$1 propertyValuesHolder$1) {
        this(property);
    }
}

