/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.FloatKeyframeSet;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.IntKeyframeSet;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Keyframe;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Keyframe$FloatKeyframe;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Keyframe$IntKeyframe;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Keyframe$ObjectKeyframe;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.Arrays;

class KeyframeSet {
    int mNumKeyframes;
    Keyframe mFirstKeyframe;
    Keyframe mLastKeyframe;
    Interpolator mInterpolator;
    ArrayList<Keyframe> mKeyframes;
    TypeEvaluator mEvaluator;

    public KeyframeSet(Keyframe ... keyframeArray) {
        this.mNumKeyframes = keyframeArray.length;
        this.mKeyframes = new ArrayList();
        this.mKeyframes.addAll(Arrays.asList(keyframeArray));
        this.mFirstKeyframe = this.mKeyframes.get(0);
        this.mLastKeyframe = this.mKeyframes.get(this.mNumKeyframes - 1);
        this.mInterpolator = this.mLastKeyframe.getInterpolator();
    }

    public static KeyframeSet ofInt(int ... nArray) {
        int n2 = nArray.length;
        Keyframe$IntKeyframe[] keyframe$IntKeyframeArray = new Keyframe$IntKeyframe[Math.max(n2, 2)];
        if (n2 == 1) {
            keyframe$IntKeyframeArray[0] = (Keyframe$IntKeyframe)Keyframe.ofInt(0.0f);
            keyframe$IntKeyframeArray[1] = (Keyframe$IntKeyframe)Keyframe.ofInt(1.0f, nArray[0]);
        } else {
            keyframe$IntKeyframeArray[0] = (Keyframe$IntKeyframe)Keyframe.ofInt(0.0f, nArray[0]);
            for (int i2 = 1; i2 < n2; ++i2) {
                keyframe$IntKeyframeArray[i2] = (Keyframe$IntKeyframe)Keyframe.ofInt((float)i2 / (float)(n2 - 1), nArray[i2]);
            }
        }
        return new IntKeyframeSet(keyframe$IntKeyframeArray);
    }

    public static KeyframeSet ofFloat(float ... fArray) {
        int n2 = fArray.length;
        Keyframe$FloatKeyframe[] keyframe$FloatKeyframeArray = new Keyframe$FloatKeyframe[Math.max(n2, 2)];
        if (n2 == 1) {
            keyframe$FloatKeyframeArray[0] = (Keyframe$FloatKeyframe)Keyframe.ofFloat(0.0f);
            keyframe$FloatKeyframeArray[1] = (Keyframe$FloatKeyframe)Keyframe.ofFloat(1.0f, fArray[0]);
        } else {
            keyframe$FloatKeyframeArray[0] = (Keyframe$FloatKeyframe)Keyframe.ofFloat(0.0f, fArray[0]);
            for (int i2 = 1; i2 < n2; ++i2) {
                keyframe$FloatKeyframeArray[i2] = (Keyframe$FloatKeyframe)Keyframe.ofFloat((float)i2 / (float)(n2 - 1), fArray[i2]);
            }
        }
        return new FloatKeyframeSet(keyframe$FloatKeyframeArray);
    }

    public static KeyframeSet ofKeyframe(Keyframe ... keyframeArray) {
        int n2 = keyframeArray.length;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (keyframeArray[i2] instanceof Keyframe$FloatKeyframe) {
                n3 = 1;
                continue;
            }
            if (keyframeArray[i2] instanceof Keyframe$IntKeyframe) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (n3 != 0 && !bl && !bl2) {
            Keyframe$FloatKeyframe[] keyframe$FloatKeyframeArray = new Keyframe$FloatKeyframe[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                keyframe$FloatKeyframeArray[n3] = (Keyframe$FloatKeyframe)keyframeArray[n3];
            }
            return new FloatKeyframeSet(keyframe$FloatKeyframeArray);
        }
        if (bl && n3 == 0 && !bl2) {
            Keyframe$IntKeyframe[] keyframe$IntKeyframeArray = new Keyframe$IntKeyframe[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                keyframe$IntKeyframeArray[n3] = (Keyframe$IntKeyframe)keyframeArray[n3];
            }
            return new IntKeyframeSet(keyframe$IntKeyframeArray);
        }
        return new KeyframeSet(keyframeArray);
    }

    public static KeyframeSet ofObject(Object ... objectArray) {
        int n2 = objectArray.length;
        Keyframe[] keyframeArray = new Keyframe$ObjectKeyframe[Math.max(n2, 2)];
        if (n2 == 1) {
            keyframeArray[0] = (Keyframe$ObjectKeyframe)Keyframe.ofObject(0.0f);
            keyframeArray[1] = (Keyframe$ObjectKeyframe)Keyframe.ofObject(1.0f, objectArray[0]);
        } else {
            keyframeArray[0] = (Keyframe$ObjectKeyframe)Keyframe.ofObject(0.0f, objectArray[0]);
            for (int i2 = 1; i2 < n2; ++i2) {
                keyframeArray[i2] = (Keyframe$ObjectKeyframe)Keyframe.ofObject((float)i2 / (float)(n2 - 1), objectArray[i2]);
            }
        }
        return new KeyframeSet(keyframeArray);
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        this.mEvaluator = typeEvaluator;
    }

    public KeyframeSet clone() {
        ArrayList<Keyframe> arrayList = this.mKeyframes;
        int n2 = this.mKeyframes.size();
        Keyframe[] keyframeArray = new Keyframe[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            keyframeArray[i2] = arrayList.get(i2).clone();
        }
        KeyframeSet keyframeSet = new KeyframeSet(keyframeArray);
        return keyframeSet;
    }

    public Object getValue(float f2) {
        if (this.mNumKeyframes == 2) {
            if (this.mInterpolator != null) {
                f2 = this.mInterpolator.getInterpolation(f2);
            }
            return this.mEvaluator.evaluate(f2, this.mFirstKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        if (f2 <= 0.0f) {
            Keyframe keyframe = this.mKeyframes.get(1);
            Interpolator interpolator = keyframe.getInterpolator();
            if (interpolator != null) {
                f2 = interpolator.getInterpolation(f2);
            }
            float f3 = this.mFirstKeyframe.getFraction();
            float f4 = (f2 - f3) / (keyframe.getFraction() - f3);
            return this.mEvaluator.evaluate(f4, this.mFirstKeyframe.getValue(), keyframe.getValue());
        }
        if (f2 >= 1.0f) {
            Keyframe keyframe = this.mKeyframes.get(this.mNumKeyframes - 2);
            Interpolator interpolator = this.mLastKeyframe.getInterpolator();
            if (interpolator != null) {
                f2 = interpolator.getInterpolation(f2);
            }
            float f5 = keyframe.getFraction();
            float f6 = (f2 - f5) / (this.mLastKeyframe.getFraction() - f5);
            return this.mEvaluator.evaluate(f6, keyframe.getValue(), this.mLastKeyframe.getValue());
        }
        Keyframe keyframe = this.mFirstKeyframe;
        for (int i2 = 1; i2 < this.mNumKeyframes; ++i2) {
            Keyframe keyframe2 = this.mKeyframes.get(i2);
            if (f2 < keyframe2.getFraction()) {
                Interpolator interpolator = keyframe2.getInterpolator();
                if (interpolator != null) {
                    f2 = interpolator.getInterpolation(f2);
                }
                float f7 = keyframe.getFraction();
                f2 = (f2 - f7) / (keyframe2.getFraction() - f7);
                return this.mEvaluator.evaluate(f2, keyframe.getValue(), keyframe2.getValue());
            }
            keyframe = keyframe2;
        }
        return this.mLastKeyframe.getValue();
    }

    public String toString() {
        String string2 = " ";
        for (int i2 = 0; i2 < this.mNumKeyframes; ++i2) {
            string2 = string2 + this.mKeyframes.get(i2).getValue() + "  ";
        }
        return string2;
    }
}

