/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.presenter.userchat;

import android.app.ProgressDialog;
import android.content.Context;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatCounter;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.userchat.UserChatListState;
import com.zoyi.channel.plugin.android.event.ChatCounterBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatDataSource;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatRepository;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract$Model;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract$View;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatContract$Presenter;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatContract$View;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatPresenter$1;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class UserChatPresenter
implements OnUserChatClickListener,
UserChatContract$Presenter {
    private UserChatContract$View userchatView;
    private UserChatAdapterContract$View adapterView;
    private UserChatAdapterContract$Model adapterModel;
    private UserChatRepository userChatRepository;
    private Context context;
    private ProgressDialog dialog;
    private UserChatCounter userChatCounter;
    private UserChatListState state = UserChatListState.WAITING_SOCKET;
    private boolean init = true;
    private String runningChatId;

    public UserChatPresenter(Context context) {
        this.context = context;
        this.userChatRepository = new UserChatRepository(new UserChatDataSource());
        this.userChatCounter = new UserChatCounter();
    }

    @Override
    public void showProgress() {
        if (this.dialog == null || !this.dialog.isShowing()) {
            this.dialog = ProgressHelper.show(this.context, ResUtils.getString(this.context, "ch.loading_information"));
        }
    }

    @Override
    public void hideProgress() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    @Override
    public void setView(UserChatContract$View userChatContract$View) {
        this.userchatView = userChatContract$View;
    }

    @Override
    public void setAdapterView(UserChatAdapterContract$View userChatAdapterContract$View) {
        this.adapterView = userChatAdapterContract$View;
        this.adapterView.setOnUserChatClickListener(this);
    }

    @Override
    public void setAdapterModel(UserChatAdapterContract$Model userChatAdapterContract$Model) {
        this.adapterModel = userChatAdapterContract$Model;
    }

    @Override
    public void setRunningChatId(String string2) {
        this.runningChatId = string2;
    }

    @Override
    public int getChatCount(String string2) {
        return this.userChatCounter.getCounter(string2);
    }

    @Override
    public void refresh() {
        switch (this.state) {
            case WAITING_SOCKET: {
                SocketManager.connect();
                return;
            }
            case USER_CHAT_LIST_NOT_LOADED: {
                this.getUserChats();
            }
        }
    }

    @Override
    public void setState(UserChatListState userChatListState) {
        this.state = userChatListState;
    }

    @Override
    public void getUserChats() {
        if (SocketManager.isReady()) {
            if (this.init) {
                this.showProgress();
            }
            this.userchatView.setReconnectVisibility(false);
            this.setState(UserChatListState.USER_CHAT_LIST_LOADING);
            this.userchatView.setRefreshVisibility(false);
            this.fetchUserChats();
            return;
        }
        this.setState(UserChatListState.WAITING_SOCKET);
        this.userchatView.setRefreshVisibility(false);
        SocketManager.reconnect();
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        switch (command) {
            case READY: {
                this.userchatView.setReconnectVisibility(false);
                if (UserChatListState.WAITING_SOCKET.equals((Object)this.state)) {
                    this.getUserChats();
                    return;
                }
                this.refresh();
                return;
            }
            case JOINED: {
                this.runningChatId = (String)object;
                return;
            }
            case SOCKET_DISCONNECTED: {
                this.setState(UserChatListState.WAITING_SOCKET);
                this.userchatView.setRefreshVisibility(true);
                this.adapterModel.stopRefreshBySocket();
                return;
            }
            case SOCKET_ERROR: {
                this.userchatView.setReconnectVisibility(true);
            }
        }
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean bl) {
        this.adapterModel.receiveChannelModel(channelModel, bl);
        if (channelModel instanceof Session) {
            if (!CompareUtils.exists((Comparable)((Object)((Session)(channelModel = (Session)channelModel)).getPersonType()), (Comparable[])new String[]{"User", "Veil"})) {
                return;
            }
            if (bl) {
                this.userChatCounter.upsert((Session)channelModel);
            } else {
                this.userChatCounter.delete((Session)channelModel);
            }
            if (((Session)channelModel).getId() != null && !CompareUtils.isSame(((Session)channelModel).getChatId(), this.runningChatId)) {
                RxBus.post(new ChatCounterBus(this.userChatCounter.getCounter(this.runningChatId)));
            }
        }
    }

    private void fetchUserChats() {
        this.userChatRepository.getUserChats(new UserChatPresenter$1(this));
    }

    public void handleError() {
        if (UserChatListState.USER_CHAT_LIST_LOADING.equals((Object)this.state)) {
            this.setState(UserChatListState.USER_CHAT_LIST_NOT_LOADED);
            this.userchatView.setRefreshVisibility(true);
        }
    }

    @Override
    public void onUserChatClick(String string2) {
        this.runningChatId = string2;
        this.userchatView.startChat(string2, this.userChatCounter.getCounter(string2), false);
    }

    static /* synthetic */ boolean access$002(UserChatPresenter userChatPresenter, boolean bl) {
        userChatPresenter.init = bl;
        return userChatPresenter.init;
    }

    static /* synthetic */ UserChatContract$View access$100(UserChatPresenter userChatPresenter) {
        return userChatPresenter.userchatView;
    }

    static /* synthetic */ UserChatAdapterContract$Model access$200(UserChatPresenter userChatPresenter) {
        return userChatPresenter.adapterModel;
    }

    static /* synthetic */ UserChatCounter access$300(UserChatPresenter userChatPresenter) {
        return userChatPresenter.userChatCounter;
    }

    static /* synthetic */ String access$400(UserChatPresenter userChatPresenter) {
        return userChatPresenter.runningChatId;
    }
}

