/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.annotation.SuppressLint;
import android.app.Application;
import android.location.Location;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.splunk.mint.ActionError;
import com.splunk.mint.ActionView;
import com.splunk.mint.Mint;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.SequentialExecutor;
import com.splunk.mint.network.NetLogManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

public class MintJavascript {
    private static final SequentialExecutor executor = new SequentialExecutor();
    private Application app;
    private WebView webview;
    private HashMap<String, Object> jExtraData = new HashMap(1);

    @SuppressLint(value={"NewApi"})
    public static String loadMintJavascript() {
        StringBuilder sb = new StringBuilder();
        sb.append("javascript:");
        MintJavascript.loadJavaScript(sb, "tracekit.js");
        MintJavascript.loadJavaScript(sb, "mint.js");
        return sb.toString();
    }

    private static void loadJavaScript(StringBuilder sb, String fileName) {
        try {
            String line;
            InputStream in = MintJavascript.class.getResourceAsStream(fileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MintJavascript(Application app, WebView webView) {
        this.app = app;
        this.webview = webView;
        this.jExtraData.put("webview", true);
    }

    @JavascriptInterface
    public void javascriptError(final String message, final String file, final String line, final String stacktrace, final String handled) {
        executor.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                byte excType = 1;
                if (handled != null && handled.toLowerCase().contains("true")) {
                    excType = 0;
                }
                ActionError actErr = new ActionError(0, message, file, line, stacktrace, MintJavascript.this.jExtraData, excType);
                actErr.save();
            }
        });
    }

    @JavascriptInterface
    public void logNetwork(String method, String url, String latency, String httpStatusCode, String responseDataSize) {
        NetLogManager.getInstance().logNetworkRequest(url, method, System.currentTimeMillis() - Long.valueOf(latency), System.currentTimeMillis(), Integer.valueOf(httpStatusCode), 0L, Long.valueOf(responseDataSize), "", this.jExtraData);
    }

    @JavascriptInterface
    public void initAndStartSession(String apikey) {
        Mint.initAndStartSession(this.app, apikey);
    }

    @JavascriptInterface
    public void initAndStartSessionHEC(String url, String token) {
        Mint.initAndStartSessionHEC(this.app, url, token);
    }

    @JavascriptInterface
    public void addExtraData(String key, String value) {
        Mint.addExtraData(key, value);
    }

    @JavascriptInterface
    public void clearExtraData() {
        Mint.clearExtraData();
    }

    @JavascriptInterface
    public void closeSession() {
        Mint.closeSession(this.app);
    }

    @JavascriptInterface
    public void flush() {
        Mint.flush();
    }

    @JavascriptInterface
    public void leaveBreadcrumb(String breadcrumb) {
        Mint.leaveBreadcrumb(breadcrumb);
    }

    @JavascriptInterface
    public void logEvent(String event, String jsonExtra) {
        HashMap<String, Object> extraData = MintJavascript.JsonStringToExtraData(jsonExtra);
        extraData.putAll(this.jExtraData);
        Mint.logEvent(event, MintLogLevel.Info, extraData);
    }

    @JavascriptInterface
    public void removeExtraData(String key) {
        Mint.removeExtraData(key);
    }

    @JavascriptInterface
    public void setLogging(int lines, String filter) {
        Mint.setLogging(lines, filter);
    }

    @JavascriptInterface
    public void setUserIdentifier(String userIdentifier) {
        Mint.setUserIdentifier(userIdentifier);
    }

    @JavascriptInterface
    public void setApplicationEnvironment(String environment) {
        Mint.setApplicationEnvironment(environment);
    }

    @JavascriptInterface
    public void setLocation(double latitude, double longitude, long timestamp) {
        Location location = new Location("");
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        location.setTime(timestamp);
        Mint.setLocation(location);
    }

    @JavascriptInterface
    public void startSession() {
        Mint.startSession(this.app);
    }

    @JavascriptInterface
    public String transactionStart(String name, String jsonExtra) {
        HashMap<String, Object> extraData = MintJavascript.JsonStringToExtraData(jsonExtra);
        extraData.putAll(this.jExtraData);
        return Mint.transactionStart(name, extraData);
    }

    @JavascriptInterface
    public void transactionStop(String id, String jsonExtra) {
        HashMap<String, Object> extraData = MintJavascript.JsonStringToExtraData(jsonExtra);
        extraData.putAll(this.jExtraData);
        Mint.transactionStop(id, extraData);
    }

    @JavascriptInterface
    public void transactionCancel(String id, String reason, String jsonExtra) {
        HashMap<String, Object> extraData = MintJavascript.JsonStringToExtraData(jsonExtra);
        extraData.putAll(this.jExtraData);
        Mint.transactionCancel(id, reason, extraData);
    }

    @JavascriptInterface
    public void logView(String currentView, String loadTime, String domainLookupTime, String serverTime, String domProcessingTime, String host, String jsonExtra) {
        HashMap<String, Object> extraData = new HashMap<String, Object>(2);
        extraData.put("webview", true);
        extraData.putAll(MintJavascript.JsonStringToExtraData(jsonExtra));
        Integer loadTimeInt = loadTime == null ? null : Integer.valueOf(loadTime);
        Integer domainLookupTimeInt = domainLookupTime == null ? null : Integer.valueOf(domainLookupTime);
        Integer serverTimeInt = serverTime == null ? null : Integer.valueOf(serverTime);
        Integer domProcessingTimeInt = domProcessingTime == null ? null : Integer.valueOf(domProcessingTime);
        ActionView.logView(currentView, domainLookupTimeInt, domProcessingTimeInt, serverTimeInt, host, loadTimeInt, extraData);
    }

    @JavascriptInterface
    public String timerStart(String name) {
        return Mint.timerStart(name);
    }

    @JavascriptInterface
    public void timerStop(String id) {
        Mint.timerStop(id);
    }

    private static synchronized HashMap<String, Object> JsonStringToExtraData(String jsontext) {
        HashMap<String, Object> extraData = new HashMap<String, Object>(2);
        if (jsontext == null || jsontext.length() <= 4 || jsontext.equals("undefined")) {
            return extraData;
        }
        try {
            JSONObject jObj = new JSONObject(jsontext);
            Iterator keysItr = jObj.keys();
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                Object value = jObj.get(key);
                extraData.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return extraData;
    }
}

