/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.cache2;

import com.zoyi.io.socket.okio.Buffer;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

final class FileOperator {
    private static final int BUFFER_SIZE = 8192;
    private final byte[] byteArray = new byte[8192];
    private final ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArray);
    private final FileChannel fileChannel;

    public FileOperator(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long pos, Buffer source, long byteCount) throws IOException {
        if (byteCount < 0L || byteCount > source.size()) {
            throw new IndexOutOfBoundsException();
        }
        while (byteCount > 0L) {
            try {
                int toWrite = (int)Math.min(8192L, byteCount);
                source.read(this.byteArray, 0, toWrite);
                this.byteBuffer.limit(toWrite);
                do {
                    int bytesWritten = this.fileChannel.write(this.byteBuffer, pos);
                    pos += (long)bytesWritten;
                } while (this.byteBuffer.hasRemaining());
                byteCount -= (long)toWrite;
            }
            finally {
                this.byteBuffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(long pos, Buffer sink, long byteCount) throws IOException {
        if (byteCount < 0L) {
            throw new IndexOutOfBoundsException();
        }
        while (byteCount > 0L) {
            try {
                this.byteBuffer.limit((int)Math.min(8192L, byteCount));
                if (this.fileChannel.read(this.byteBuffer, pos) == -1) {
                    throw new EOFException();
                }
                int bytesRead = this.byteBuffer.position();
                sink.write(this.byteArray, 0, bytesRead);
                pos += (long)bytesRead;
                byteCount -= (long)bytesRead;
            }
            finally {
                this.byteBuffer.clear();
            }
        }
    }
}

