/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.io;

import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import java.io.Serializable;

public enum IOCase implements Serializable
{
    SENSITIVE("Sensitive", true),
    INSENSITIVE("Insensitive", false),
    SYSTEM("System", !FilenameUtils.isSystemWindows());

    private static final long serialVersionUID = -6343169151696340687L;
    private final String name;
    private final transient boolean sensitive;

    public static IOCase forName(String string2) {
        for (IOCase iOCase : IOCase.values()) {
            if (!iOCase.getName().equals(string2)) continue;
            return iOCase;
        }
        throw new IllegalArgumentException("Invalid IOCase name: " + string2);
    }

    private IOCase(String string3, boolean bl) {
        this.name = string3;
        this.sensitive = bl;
    }

    private Object readResolve() {
        return IOCase.forName(this.name);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isCaseSensitive() {
        return this.sensitive;
    }

    public final int checkCompareTo(String string2, String string3) {
        if (string2 == null || string3 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        if (this.sensitive) {
            return string2.compareTo(string3);
        }
        return string2.compareToIgnoreCase(string3);
    }

    public final boolean checkEquals(String string2, String string3) {
        if (string2 == null || string3 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        if (this.sensitive) {
            return string2.equals(string3);
        }
        return string2.equalsIgnoreCase(string3);
    }

    public final boolean checkStartsWith(String string2, String string3) {
        return string2.regionMatches(!this.sensitive, 0, string3, 0, string3.length());
    }

    public final boolean checkEndsWith(String string2, String string3) {
        int n2 = string3.length();
        return string2.regionMatches(!this.sensitive, string2.length() - n2, string3, 0, n2);
    }

    public final int checkIndexOf(String string2, int n2, String string3) {
        int n3 = string2.length() - string3.length();
        if (n3 >= n2) {
            while (n2 <= n3) {
                if (this.checkRegionMatches(string2, n2, string3)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public final boolean checkRegionMatches(String string2, int n2, String string3) {
        return string2.regionMatches(!this.sensitive, n2, string3, 0, string3.length());
    }

    public final String toString() {
        return this.name;
    }
}

