package com.zoyi.channel.plugin.android.push;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.wrapper.DeviceTokenBox;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.util.Map;

public class ChannelPushManager {

  private static final int NOTIFICATION_ID = 95991298;

  private static Bundle convertMessageMapToBundle(Map<String, String> message) {
    Bundle bundle = new Bundle();

    for (Map.Entry<String, String> entry : message.entrySet()) {
      bundle.putString(entry.getKey(), entry.getValue());
    }
    return bundle;
  }

  public static boolean isChannelPluginMessage(Map<String, String> message) {
    return isChannelPluginMessage(convertMessageMapToBundle(message));
  }

  public static boolean isChannelPluginMessage(Bundle message) {
    if (message == null) {
      return false;
    }
    PushData pushData = new PushData(message);

    return pushData.isChannelPluginMessage();
  }

  @SuppressLint("HardwareIds")
  public static void sendTokenToChannelPlugin(final Context context) {
    String token = PrefSupervisor.getDeviceToken(context);

    if (!TextUtils.isEmpty(token)) {
      RequestBody body = RequestUtils.form()
          .set("platform", "android")
          .set("key", Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID))
          .set("token", token)
          .create();

      ChannelPlugin.getApi().sendToken(body)
          .subscribeOn(Schedulers.newThread())
          .observeOn(AndroidSchedulers.mainThread())
          .subscribe(new RestSubscriber<DeviceTokenBox>());
    }
  }

  public static void deleteToken(Context context) {
    // TODO : 체크아웃 할 할 때 호출
  }

  public static void handlePush(Context context, Map<String, String> message) {
    handlePush(context, convertMessageMapToBundle(message));
  }

  public static void handlePush(Context context, Bundle message) {
    if (CheckInPrefSupervisor.hasCheckInData(context)) {
      sendNotification(context, message);
    }
  }

  private static void sendNotification(Context context, Bundle message) {
    Notification notification = NotificationFactory.createPushMessage(context, new PushData(message));

    if (notification != null) {
      NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);

      notificationManager.notify(NOTIFICATION_ID, notification);
    }
  }

  static void clearNotification(Context context) {
    try {
      NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);

      notificationManager.cancel(NOTIFICATION_ID);
    } catch (Exception ex) {
      L.e(ex.getMessage());
    }
  }
}
