/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerAdapter;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.presenter.photopicker.PhotoPickerContract;
import com.zoyi.channel.plugin.android.presenter.photopicker.PhotoPickerPresenter;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import java.util.ArrayList;

public class PhotoPickerActivity
extends BaseActivity
implements PhotoPickerContract.View {
    private LinearLayout emptyLayout;
    private PhotoPickerContract.Presenter presenter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_photo_picker);
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view_photo_picker);
        this.emptyLayout = (LinearLayout)this.findViewById(R.id.no_album);
        this.getBigBar().withActivity(this).setTitle(ResUtils.getString((Context)this, "ch.photo.all_images")).addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.CAMERA, BigBar.MenuPosition.RIGHT).addMenu(MenuButton.ActionType.DONE, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.DISABLED).build();
        PhotoPickerAdapter adapter = new PhotoPickerAdapter(this);
        this.presenter = new PhotoPickerPresenter((Context)this);
        this.presenter.setView(this);
        this.presenter.setAdapterView(adapter);
        this.presenter.setAdapterModel(adapter);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, 3));
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        recyclerView.setItemAnimator(null);
        this.setStyle();
    }

    private void setStyle() {
        Plugin plugin = ChannelStore.getPlugin();
        if (plugin != null) {
            this.setStatusBarColor(plugin.getBackgroundColor());
            this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
        }
    }

    protected void onResume() {
        super.onResume();
        this.fetchPhotoItems();
    }

    public void onBackPressed() {
        this.setResult(0);
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 3000: {
                    String photoPath = Executor.getPhotoPath();
                    if (!TextUtils.isEmpty((CharSequence)photoPath)) {
                        Executor.startFileMediaScan((Activity)this, photoPath);
                        this.sendPhotoPath(Executor.getPhotoPath());
                    }
                    return;
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        super.optionClicked(actionType);
        switch (actionType) {
            case BACK: {
                this.onBackPressed();
                break;
            }
            case CAMERA: {
                this.openCamera();
                break;
            }
            case DONE: {
                this.presenter.collectSelectedPhotoItem();
            }
        }
    }

    @Override
    public void loadPhotoItems(ArrayList<PhotoItem> photoItems) {
        this.setEmptyLayoutVisibility(photoItems.isEmpty());
    }

    @Override
    public void sendPhotoPaths(ArrayList<String> imagePaths) {
        Intent i = new Intent();
        i.putStringArrayListExtra("PHOTO_INTENT_KEY", imagePaths);
        this.setResult(12, i);
        this.finish();
    }

    @Override
    public void setMenuState(int selectedCount) {
        this.getBigBar().setMenuState(MenuButton.ActionType.DONE, selectedCount > 0 ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.DISABLED);
    }

    @Override
    public void setPresenter(PhotoPickerContract.Presenter presenter) {
    }

    private void fetchPhotoItems() {
        if (this.checkPermission(2)) {
            this.presenter.fetchPhotoItems();
        }
    }

    private void setEmptyLayoutVisibility(boolean visible) {
        this.emptyLayout.setVisibility(visible ? 0 : 8);
    }

    @Override
    protected void permissionAccepted(int requestCode) {
        switch (requestCode) {
            case 2: {
                this.fetchPhotoItems();
                break;
            }
            case 3: {
                this.openCamera();
            }
        }
    }

    @Override
    protected void permissionRejected(int requestCode) {
        if (requestCode == 2) {
            this.finish();
        }
    }

    private void sendPhotoPath(String photoPath) {
        ArrayList<String> photoPaths = new ArrayList<String>();
        photoPaths.add(photoPath);
        this.sendPhotoPaths(photoPaths);
    }

    private void openCamera() {
        if (this.checkPermission(3)) {
            Executor.takePhoto((Activity)this);
        }
    }
}

