/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$ActionType;

public class MenuButton
extends RelativeLayout {
    MaskableFrameLayout mask;
    FrameLayout colorLayout;
    ImageView dummy;
    Drawable iconId;
    int color = -1;
    private MenuButton$ActionType action;

    public MenuButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public MenuButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public MenuButton(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context, attributeSet);
    }

    @TargetApi(value=21)
    public MenuButton(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_menu_button, (ViewGroup)this);
        this.mask = (MaskableFrameLayout)this.findViewById(R.id.menu_icon_mask);
        this.colorLayout = (FrameLayout)this.findViewById(R.id.layout_color);
        this.dummy = (ImageView)this.findViewById(R.id.menu_icon_dummy);
        if (attributeSet != null) {
            context = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.MenuButton, 0, 0);
            try {
                this.color = context.getColor(R.styleable.MenuButton_ch_back_color, this.color);
                this.iconId = context.getDrawable(R.styleable.MenuButton_ch_image);
            }
            finally {
                context.recycle();
            }
        }
        this.setIcon(this.iconId);
        this.setColor(this.color);
    }

    public void setIcon(Drawable drawable2) {
        if (drawable2 != null) {
            this.mask.setMask(drawable2);
            this.dummy.setImageDrawable(drawable2);
        }
    }

    public void setColor(int n2) {
        this.colorLayout.setBackgroundColor(n2);
    }

    public void setAction(MenuButton$ActionType menuButton$ActionType) {
        this.action = menuButton$ActionType;
        if (menuButton$ActionType != null && menuButton$ActionType.getIcon() != 0) {
            this.mask.setMask(menuButton$ActionType.getIcon());
            this.dummy.setImageResource(menuButton$ActionType.getIcon());
        }
    }

    public MenuButton$ActionType getAction() {
        return this.action;
    }
}

