package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;

import java.io.File;

public class FileUtils {

  public static boolean createDirectory(File dir) {
    if (!dir.exists()) {
      boolean created = dir.mkdirs();

      if (!created) {
        return false;
      }
    }
    return true;
  }

  public static boolean deleteFile(File file) {
    return file.exists() && file.delete();
  }

  public static boolean hasFileExtension(String path) {
    MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
    String ext = mimeTypeMap.getMimeTypeFromExtension(FilenameUtils.getExtension(path.toLowerCase()));

    return !TextUtils.isEmpty(ext);
  }

  public static String getRealPathFromURI(Context context, Uri contentUri) {
    String path = null;
    Cursor cursor = null;

    try {
      String[] proj = { MediaStore.Images.Media.DATA };
      cursor = context.getContentResolver().query(contentUri, proj, null, null, null);

      if (cursor != null) {
        int column_index = cursor.getColumnIndexOrThrow(MediaStore.Images.Media.DATA);

        cursor.moveToFirst();

        path = cursor.getString(column_index);
      }
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      if (cursor != null) {
        cursor.close();
      }
    }
    return path;
  }

  @SuppressWarnings({"ConstantConditions", "ResultOfMethodCallIgnored"})
  public static File getPhotoDirectory() {
    File dir = new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES), Const.EXTERNAL_DOWNLOAD_PATH);

    if (dir != null && !dir.exists()) {
      dir.mkdir();
    }
    return dir;
  }

}
