/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.webp.decoder;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.signature.ObjectKey;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class WebpFrameLoader {
    private final GifDecoder gifDecoder;
    private final Handler handler;
    private final List<FrameCallback> callbacks = new ArrayList<FrameCallback>();
    final RequestManager requestManager;
    private final BitmapPool bitmapPool;
    private boolean isRunning = false;
    private boolean isLoadPending = false;
    private boolean startFromFirstFrame = false;
    private RequestBuilder<Bitmap> requestBuilder;
    private DelayTarget current;
    private boolean isCleared;
    private DelayTarget next;
    private Bitmap firstFrame;
    private Transformation<Bitmap> transformation;
    private DelayTarget pendingTarget;
    @Nullable
    private OnEveryFrameListener onEveryFrameListener;

    public WebpFrameLoader(Glide glide, GifDecoder gifDecoder, int width, int height, Transformation<Bitmap> transformation, Bitmap firstFrame) {
        this(glide.getBitmapPool(), Glide.with((Context)glide.getContext()), gifDecoder, null, WebpFrameLoader.getRequestBuilder(Glide.with((Context)glide.getContext()), width, height), transformation, firstFrame);
    }

    WebpFrameLoader(BitmapPool bitmapPool, RequestManager requestManager, GifDecoder gifDecoder, Handler handler, RequestBuilder<Bitmap> requestBuilder, Transformation<Bitmap> transformation, Bitmap firstFrame) {
        this.requestManager = requestManager;
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new FrameLoaderCallback());
        }
        this.bitmapPool = bitmapPool;
        this.handler = handler;
        this.requestBuilder = requestBuilder;
        this.gifDecoder = gifDecoder;
        this.setFrameTransformation(transformation, firstFrame);
    }

    void setFrameTransformation(Transformation<Bitmap> transformation, Bitmap firstFrame) {
        this.transformation = (Transformation)Preconditions.checkNotNull(transformation);
        this.firstFrame = (Bitmap)Preconditions.checkNotNull((Object)firstFrame);
        this.requestBuilder = this.requestBuilder.apply(new RequestOptions().transform(transformation));
    }

    Transformation<Bitmap> getFrameTransformation() {
        return this.transformation;
    }

    Bitmap getFirstFrame() {
        return this.firstFrame;
    }

    void subscribe(FrameCallback frameCallback) {
        if (this.isCleared) {
            throw new IllegalStateException("Cannot subscribe to a cleared frame loader");
        }
        if (this.callbacks.contains(frameCallback)) {
            throw new IllegalStateException("Cannot subscribe twice in a row");
        }
        boolean start = this.callbacks.isEmpty();
        this.callbacks.add(frameCallback);
        if (start) {
            this.start();
        }
    }

    void unsubscribe(FrameCallback frameCallback) {
        this.callbacks.remove(frameCallback);
        if (this.callbacks.isEmpty()) {
            this.stop();
        }
    }

    int getWidth() {
        return this.getCurrentFrame().getWidth();
    }

    int getHeight() {
        return this.getCurrentFrame().getHeight();
    }

    int getSize() {
        return this.gifDecoder.getByteSize() + this.getFrameSize();
    }

    int getCurrentIndex() {
        return this.current != null ? this.current.index : -1;
    }

    private int getFrameSize() {
        return Util.getBitmapByteSize((int)this.getCurrentFrame().getWidth(), (int)this.getCurrentFrame().getHeight(), (Bitmap.Config)this.getCurrentFrame().getConfig());
    }

    ByteBuffer getBuffer() {
        return this.gifDecoder.getData().asReadOnlyBuffer();
    }

    int getFrameCount() {
        return this.gifDecoder.getFrameCount();
    }

    int getLoopCount() {
        return this.gifDecoder.getTotalIterationCount();
    }

    private void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.isCleared = false;
        this.loadNextFrame();
    }

    private void stop() {
        this.isRunning = false;
    }

    void clear() {
        this.callbacks.clear();
        this.recycleFirstFrame();
        this.stop();
        if (this.current != null) {
            this.requestManager.clear((Target)this.current);
            this.current = null;
        }
        if (this.next != null) {
            this.requestManager.clear((Target)this.next);
            this.next = null;
        }
        if (this.pendingTarget != null) {
            this.requestManager.clear((Target)this.pendingTarget);
            this.pendingTarget = null;
        }
        this.gifDecoder.clear();
        this.isCleared = true;
    }

    Bitmap getCurrentFrame() {
        return this.current != null ? this.current.getResource() : this.firstFrame;
    }

    private void loadNextFrame() {
        if (!this.isRunning || this.isLoadPending) {
            return;
        }
        if (this.startFromFirstFrame) {
            Preconditions.checkArgument((this.pendingTarget == null ? 1 : 0) != 0, (String)"Pending target must be null when starting from the first frame");
            this.gifDecoder.resetFrameIndex();
            this.startFromFirstFrame = false;
        }
        if (this.pendingTarget != null) {
            DelayTarget temp = this.pendingTarget;
            this.pendingTarget = null;
            this.onFrameReady(temp);
            return;
        }
        this.isLoadPending = true;
        int delay = this.gifDecoder.getNextDelay();
        long targetTime = SystemClock.uptimeMillis() + (long)delay;
        this.gifDecoder.advance();
        this.next = new DelayTarget(this.handler, this.gifDecoder.getCurrentFrameIndex(), targetTime);
        this.requestBuilder.apply(RequestOptions.signatureOf((Key)WebpFrameLoader.getFrameSignature())).load((Object)this.gifDecoder).into((Target)this.next);
    }

    private void recycleFirstFrame() {
        if (this.firstFrame != null) {
            this.bitmapPool.put(this.firstFrame);
            this.firstFrame = null;
        }
    }

    void setNextStartFromFirstFrame() {
        Preconditions.checkArgument((!this.isRunning ? 1 : 0) != 0, (String)"Can't restart a running animation");
        this.startFromFirstFrame = true;
        if (this.pendingTarget != null) {
            this.requestManager.clear((Target)this.pendingTarget);
            this.pendingTarget = null;
        }
    }

    void setOnEveryFrameReadyListener(@Nullable OnEveryFrameListener onEveryFrameListener) {
        this.onEveryFrameListener = onEveryFrameListener;
    }

    void onFrameReady(DelayTarget delayTarget) {
        if (this.onEveryFrameListener != null) {
            this.onEveryFrameListener.onFrameReady();
        }
        this.isLoadPending = false;
        if (this.isCleared) {
            this.handler.obtainMessage(2, (Object)delayTarget).sendToTarget();
            return;
        }
        if (!this.isRunning) {
            this.pendingTarget = delayTarget;
            return;
        }
        if (delayTarget.getResource() != null) {
            this.recycleFirstFrame();
            DelayTarget previous = this.current;
            this.current = delayTarget;
            for (int i = this.callbacks.size() - 1; i >= 0; --i) {
                FrameCallback cb = this.callbacks.get(i);
                cb.onFrameReady();
            }
            if (previous != null) {
                this.handler.obtainMessage(2, (Object)previous).sendToTarget();
            }
        }
        this.loadNextFrame();
    }

    private static RequestBuilder<Bitmap> getRequestBuilder(RequestManager requestManager, int width, int height) {
        return requestManager.asBitmap().apply(RequestOptions.diskCacheStrategyOf((DiskCacheStrategy)DiskCacheStrategy.NONE).useAnimationPool(true).skipMemoryCache(true).override(width, height));
    }

    private static Key getFrameSignature() {
        return new ObjectKey((Object)Math.random());
    }

    static interface OnEveryFrameListener {
        public void onFrameReady();
    }

    static class DelayTarget
    extends SimpleTarget<Bitmap> {
        private final Handler handler;
        final int index;
        private final long targetTime;
        private Bitmap resource;

        DelayTarget(Handler handler, int index, long targetTime) {
            this.handler = handler;
            this.index = index;
            this.targetTime = targetTime;
        }

        Bitmap getResource() {
            return this.resource;
        }

        public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
            this.resource = resource;
            Message msg = this.handler.obtainMessage(1, (Object)this);
            this.handler.sendMessageAtTime(msg, this.targetTime);
        }
    }

    private class FrameLoaderCallback
    implements Handler.Callback {
        static final int MSG_DELAY = 1;
        static final int MSG_CLEAR = 2;

        FrameLoaderCallback() {
        }

        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                DelayTarget target = (DelayTarget)((Object)msg.obj);
                WebpFrameLoader.this.onFrameReady(target);
                return true;
            }
            if (msg.what == 2) {
                DelayTarget target = (DelayTarget)((Object)msg.obj);
                WebpFrameLoader.this.requestManager.clear((Target)target);
            }
            return false;
        }
    }

    public static interface FrameCallback {
        public void onFrameReady();
    }
}

