/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.webp;

import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Base64;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import com.bumptech.glide.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WebpHeaderParser {
    public static final int MAX_WEBP_HEADER_SIZE = 21;
    private static final int RIFF_HEADER = 1380533830;
    private static final int WEBP_HEADER = 1464156752;
    private static final int WEBP_VP8_HEADER = 1448097824;
    private static final int WEBP_VP8L_HEADER = 1448097868;
    private static final int WEBP_VP8X_HEADER = 1448097880;
    private static final int WEBP_EXTENDED_ALPHA_FLAG = 16;
    private static final int WEBP_EXTENDED_ANIM_FLAG = 2;
    private static final int WEBP_LOSSLESS_ALPHA_FLAG = 8;
    private static final String VP8X_WEBP_BASE64 = "UklGRkoAAABXRUJQVlA4WAoAAAAQAAAAAAAAAAAAQUxQSAwAAAARBxAR/Q9ERP8DAABWUDggGAAAABQBAJ0BKgEAAQAAAP4AAA3AAP7mtQAAAA==";
    public static final boolean sIsExtendedWebpSupported = WebpHeaderParser.isExtendedWebpSupported();

    public static boolean isExtendedWebpSupported() {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        if (Build.VERSION.SDK_INT == 17) {
            byte[] decodedBytes = Base64.decode((String)VP8X_WEBP_BASE64, (int)0);
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length, (BitmapFactory.Options)opts);
            if (opts.outHeight != 1 || opts.outWidth != 1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isStaticWebpType(WebpImageType imageType) {
        return imageType == WebpImageType.WEBP_SIMPLE || imageType == WebpImageType.WEBP_LOSSLESS || imageType == WebpImageType.WEBP_LOSSLESS_WITH_ALPHA || imageType == WebpImageType.WEBP_EXTENDED || imageType == WebpImageType.WEBP_EXTENDED_WITH_ALPHA;
    }

    public static boolean isNonSimpleWebpType(WebpImageType imageType) {
        return imageType != WebpImageType.NONE_WEBP && imageType != WebpImageType.WEBP_SIMPLE;
    }

    public static boolean isAnimatedWebpType(WebpImageType imageType) {
        return imageType == WebpImageType.WEBP_EXTENDED_ANIMATED;
    }

    public static WebpImageType getType(InputStream is, ArrayPool byteArrayPool) throws IOException {
        if (is == null) {
            return WebpImageType.NONE_WEBP;
        }
        if (!is.markSupported()) {
            is = new RecyclableBufferedInputStream(is, byteArrayPool);
        }
        is.mark(21);
        try {
            WebpImageType webpImageType = WebpHeaderParser.getType(new StreamReader((InputStream)Preconditions.checkNotNull((Object)is)));
            return webpImageType;
        }
        finally {
            is.reset();
        }
    }

    public static WebpImageType getType(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return WebpImageType.NONE_WEBP;
        }
        return WebpHeaderParser.getType(new ByteBufferReader((ByteBuffer)Preconditions.checkNotNull((Object)byteBuffer)));
    }

    public static WebpImageType getType(byte[] headers) throws IOException {
        return WebpHeaderParser.getType(headers, 0, headers.length);
    }

    public static WebpImageType getType(byte[] headers, int offset, int headerSize) throws IOException {
        return WebpHeaderParser.getType(new ByteArrayReader(headers, offset, headerSize));
    }

    private static WebpImageType getType(Reader reader) throws IOException {
        int firstFourBytes = reader.getUInt16() << 16 & 0xFFFF0000 | reader.getUInt16() & 0xFFFF;
        if (firstFourBytes != 1380533830) {
            return WebpImageType.NONE_WEBP;
        }
        reader.skip(4L);
        int thirdFourBytes = reader.getUInt16() << 16 & 0xFFFF0000 | reader.getUInt16() & 0xFFFF;
        if (thirdFourBytes != 1464156752) {
            return WebpImageType.NONE_WEBP;
        }
        int fourthFourBytes = reader.getUInt16() << 16 & 0xFFFF0000 | reader.getUInt16() & 0xFFFF;
        if (fourthFourBytes == 1448097824) {
            return WebpImageType.WEBP_SIMPLE;
        }
        if (fourthFourBytes == 1448097868) {
            reader.skip(4L);
            return (reader.getByte() & 8) != 0 ? WebpImageType.WEBP_LOSSLESS_WITH_ALPHA : WebpImageType.WEBP_LOSSLESS;
        }
        if (fourthFourBytes == 1448097880) {
            reader.skip(4L);
            int meta = reader.getByte();
            if ((meta & 2) != 0) {
                return WebpImageType.WEBP_EXTENDED_ANIMATED;
            }
            if ((meta & 0x10) != 0) {
                return WebpImageType.WEBP_EXTENDED_WITH_ALPHA;
            }
            return WebpImageType.WEBP_EXTENDED;
        }
        return WebpImageType.NONE_WEBP;
    }

    private static final class StreamReader
    implements Reader {
        private final InputStream is;

        StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public int getUInt16() throws IOException {
            return this.is.read() << 8 & 0xFF00 | this.is.read() & 0xFF;
        }

        @Override
        public short getUInt8() throws IOException {
            return (short)(this.is.read() & 0xFF);
        }

        @Override
        public long skip(long total) throws IOException {
            if (total < 0L) {
                return 0L;
            }
            long toSkip = total;
            while (toSkip > 0L) {
                long skipped = this.is.skip(toSkip);
                if (skipped > 0L) {
                    toSkip -= skipped;
                    continue;
                }
                int testEofByte = this.is.read();
                if (testEofByte == -1) break;
                --toSkip;
            }
            return total - toSkip;
        }

        @Override
        public int read(byte[] buffer, int byteCount) throws IOException {
            int toRead;
            int read;
            for (toRead = byteCount; toRead > 0 && (read = this.is.read(buffer, byteCount - toRead, toRead)) != -1; toRead -= read) {
            }
            return byteCount - toRead;
        }

        @Override
        public int getByte() throws IOException {
            return this.is.read();
        }
    }

    private static final class ByteBufferReader
    implements Reader {
        private final ByteBuffer byteBuffer;

        ByteBufferReader(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }

        @Override
        public int getUInt16() throws IOException {
            return this.getByte() << 8 & 0xFF00 | this.getByte() & 0xFF;
        }

        @Override
        public short getUInt8() throws IOException {
            return (short)(this.getByte() & 0xFF);
        }

        @Override
        public long skip(long total) throws IOException {
            int toSkip = (int)Math.min((long)this.byteBuffer.remaining(), total);
            this.byteBuffer.position(this.byteBuffer.position() + toSkip);
            return toSkip;
        }

        @Override
        public int read(byte[] buffer, int byteCount) throws IOException {
            int toRead = Math.min(byteCount, this.byteBuffer.remaining());
            if (toRead == 0) {
                return -1;
            }
            this.byteBuffer.get(buffer, 0, toRead);
            return toRead;
        }

        @Override
        public int getByte() throws IOException {
            if (this.byteBuffer.remaining() < 1) {
                return -1;
            }
            return this.byteBuffer.get();
        }
    }

    private static final class ByteArrayReader
    implements Reader {
        private final byte[] data;
        private final int offset;
        private final int size;
        private int pos;

        ByteArrayReader(byte[] data, int offset, int size) {
            this.data = data;
            this.offset = offset;
            this.size = size;
            this.pos = offset;
        }

        @Override
        public int getUInt16() throws IOException {
            return this.getByte() << 8 & 0xFF00 | this.getByte() & 0xFF;
        }

        @Override
        public short getUInt8() throws IOException {
            return (short)(this.getByte() & 0xFF);
        }

        @Override
        public long skip(long total) throws IOException {
            int toSkip = (int)Math.min((long)(this.offset + this.size - this.pos), total);
            this.pos += toSkip;
            return toSkip;
        }

        @Override
        public int read(byte[] buffer, int byteCount) throws IOException {
            int toRead = Math.min(this.offset + this.size - this.pos, byteCount);
            if (toRead == 0) {
                return -1;
            }
            System.arraycopy(this.data, this.pos, buffer, 0, toRead);
            return toRead;
        }

        @Override
        public int getByte() throws IOException {
            if (this.pos >= this.offset + this.size) {
                return -1;
            }
            return this.data[this.pos++];
        }
    }

    private static interface Reader {
        public int getUInt16() throws IOException;

        public short getUInt8() throws IOException;

        public long skip(long var1) throws IOException;

        public int read(byte[] var1, int var2) throws IOException;

        public int getByte() throws IOException;
    }

    public static enum WebpImageType {
        WEBP_SIMPLE(false, false),
        WEBP_LOSSLESS(false, false),
        WEBP_LOSSLESS_WITH_ALPHA(true, false),
        WEBP_EXTENDED(false, false),
        WEBP_EXTENDED_WITH_ALPHA(true, false),
        WEBP_EXTENDED_ANIMATED(false, true),
        NONE_WEBP(false, false);

        private final boolean hasAlpha;
        private final boolean hasAnimation;

        private WebpImageType(boolean hasAlpha, boolean hasAnimation) {
            this.hasAlpha = hasAlpha;
            this.hasAnimation = hasAnimation;
        }

        public boolean hasAlpha() {
            return this.hasAlpha;
        }

        public boolean hasAnimation() {
            return this.hasAnimation;
        }
    }
}

