/*
 * Decompiled with CFR 0.152.
 */
package com.zingat.andversion;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.zingat.andversion.AndVersionContract;
import com.zingat.andversion.AndVersionPresenter;
import com.zingat.andversion.IServerResponseListener;
import com.zingat.andversion.OnCompletedListener;
import com.zingat.andversion.ParsedContentModel;
import com.zingat.andversion.R;
import java.io.IOException;

public class AndVersion
implements AndVersionContract.View {
    private Activity activity;
    private MaterialDialog mDialog;
    private static AndVersion andVersion;
    private AndVersionPresenter mPresenter = new AndVersionPresenter();

    public static AndVersion getInstance() {
        if (andVersion == null) {
            andVersion = new AndVersion();
        }
        return andVersion;
    }

    public AndVersion setActivity(Activity activity) {
        this.activity = activity;
        this.init();
        return this;
    }

    private void init() {
        this.mPresenter.setActivity(this.activity);
        this.mPresenter.setPackageInfoForPresenter();
        this.mPresenter.setView(this);
    }

    public AndVersion setUri(String uri) {
        this.mPresenter.setUri(uri);
        return this;
    }

    public AndVersion addHeader(String key, String value) {
        this.mPresenter.addHeader(key, value);
        return this;
    }

    private AndVersion() {
    }

    public AndVersion checkForceUpdate(OnCompletedListener completedListener) {
        try {
            this.mPresenter.getJsonFromUrl(completedListener, new IServerResponseListener(){

                @Override
                public void onParsedData(ParsedContentModel content) {
                    AndVersion.this.mPresenter.checkForceUpdate(content);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public AndVersion checkNews() {
        try {
            this.mPresenter.getJsonFromUrl(null, new IServerResponseListener(){

                @Override
                public void onParsedData(final ParsedContentModel content) {
                    AndVersion.this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AndVersion.this.mPresenter.checkNewVersionFeatures(content);
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public AndVersion checkUpdate(@Nullable OnCompletedListener completedListener) {
        try {
            this.mPresenter.getJsonFromUrl(completedListener, new IServerResponseListener(){

                @Override
                public void onParsedData(ParsedContentModel content) {
                    AndVersion.this.mPresenter.checkUpdateRules(content);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void closeDialog() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    @Override
    public void showForceUpdateDialog(String whatsNew, final String packageName) {
        this.mDialog = new MaterialDialog.Builder((Context)this.activity).cancelable(false).title(R.string.andversion_forceupdate_title).content((CharSequence)whatsNew).positiveText(R.string.andversion_ok).negativeText(R.string.andversion_exit_app).onNegative(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                AndVersion.this.activity.finish();
            }
        }).onPositive(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                AndVersion.this.mPresenter.sendUserToGooglePlay(packageName);
            }
        }).show();
    }

    @Override
    public void showNews(String features, final @Nullable OnCompletedListener completedListener) {
        this.mDialog = new MaterialDialog.Builder((Context)this.activity).cancelable(false).title(R.string.andversion_forceupdate_title).content((CharSequence)features).positiveText(R.string.andversion_ok).onPositive(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                if (completedListener != null) {
                    completedListener.onCompleted();
                }
            }
        }).show();
    }

    @Override
    public void showNews(String features) {
        this.showNews(features, null);
    }
}

