/*
 * Decompiled with CFR 0.152.
 */
package com.zingat.andversion;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zingat.andversion.AndVersionContract;
import com.zingat.andversion.JsonParseHelper;
import com.zingat.andversion.OnCompletedListener;
import java.io.IOException;
import java.util.ArrayList;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

class AndVersionPresenter
implements AndVersionContract.Presenter {
    private AndVersionContract.View mView;
    private OkHttpClient mClient = new OkHttpClient();
    private JsonParseHelper mJsonParseHelper = new JsonParseHelper();
    private int currentVersionCode;
    private int lastSessionVersion;
    private String packageName;
    private Activity activity;
    private OnCompletedListener mCompletedListener;
    private int minSupportVersion;
    private int currentUpdateVersion;

    AndVersionPresenter() {
    }

    @Override
    public void setView(AndVersionContract.View view) {
        this.mView = view;
    }

    @Override
    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Override
    public void setPackageInfoForPresenter() {
        try {
            PackageInfo packageInfo = this.activity.getPackageManager().getPackageInfo(this.activity.getPackageName(), 0);
            this.currentVersionCode = packageInfo.versionCode;
            this.packageName = packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void checkLastSessionVersion(String features, int currentUpdateVersion) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        this.lastSessionVersion = preferences.getInt("lastSessionVersion", 0);
        SharedPreferences.Editor editor = preferences.edit();
        if (this.lastSessionVersion != this.currentVersionCode) {
            if (this.lastSessionVersion != 0 && this.currentVersionCode == currentUpdateVersion) {
                this.mView.showNews(features, this.mCompletedListener);
            } else {
                this.mCompletedListener.onCompleted();
            }
            this.lastSessionVersion = this.currentVersionCode;
            editor.putInt("lastSessionVersion", this.lastSessionVersion);
            editor.apply();
        } else {
            this.mCompletedListener.onCompleted();
        }
    }

    @Override
    public void sendUserToGooglePlay(String packageName) {
        try {
            this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packageName))));
        }
        catch (ActivityNotFoundException anfe) {
            this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + packageName))));
        }
    }

    @Override
    public void getJsonFromUrl(@NonNull String url, final @Nullable OnCompletedListener completedListener) throws IOException {
        this.mCompletedListener = completedListener;
        Request request = new Request.Builder().url(url).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                AndVersionPresenter.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (completedListener != null) {
                            completedListener.onCompleted();
                        }
                    }
                });
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    try {
                        final String features = AndVersionPresenter.this.parseFeaturesContent(responseBody);
                        if (AndVersionPresenter.this.currentUpdateVersion != -1 && AndVersionPresenter.this.minSupportVersion != -1) {
                            AndVersionPresenter.this.activity.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (AndVersionPresenter.this.currentVersionCode < AndVersionPresenter.this.minSupportVersion) {
                                        AndVersionPresenter.this.mView.showForceUpdateDialogs(features, AndVersionPresenter.this.packageName);
                                    } else if (!features.equals("")) {
                                        AndVersionPresenter.this.mView.checkLastSessionVersion(features, AndVersionPresenter.this.currentUpdateVersion);
                                    }
                                }
                            });
                            return;
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                AndVersionPresenter.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (completedListener != null) {
                            completedListener.onCompleted();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getForceUpdateInfoFromUrl(String url, @Nullable OnCompletedListener onCompletedListener) {
        this.mCompletedListener = onCompletedListener;
        Request request = new Request.Builder().url(url).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                AndVersionPresenter.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (AndVersionPresenter.this.mCompletedListener != null) {
                            AndVersionPresenter.this.mCompletedListener.onCompleted();
                        }
                    }
                });
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    try {
                        final String features = AndVersionPresenter.this.parseFeaturesContent(responseBody);
                        if (AndVersionPresenter.this.minSupportVersion != -1 && AndVersionPresenter.this.currentVersionCode < AndVersionPresenter.this.minSupportVersion) {
                            AndVersionPresenter.this.activity.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    AndVersionPresenter.this.mView.showForceUpdateDialogs(features, AndVersionPresenter.this.packageName);
                                }
                            });
                            return;
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                AndVersionPresenter.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (AndVersionPresenter.this.mCompletedListener != null) {
                            AndVersionPresenter.this.mCompletedListener.onCompleted();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getVersionInfoFromUrl(String url) {
        Request request = new Request.Builder().url(url).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                e.printStackTrace();
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    try {
                        String features = AndVersionPresenter.this.parseFeaturesContent(responseBody);
                        if (AndVersionPresenter.this.currentUpdateVersion != -1 && !features.equals("")) {
                            AndVersionPresenter.this.mView.checkNewsLastSessionVersion(features, AndVersionPresenter.this.currentUpdateVersion);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void checkNewsLastSessionVersion(final String features, int currentUpdateVersion) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        this.lastSessionVersion = preferences.getInt("lastSessionVersion", 0);
        SharedPreferences.Editor editor = preferences.edit();
        if (this.lastSessionVersion != this.currentVersionCode) {
            if (this.lastSessionVersion != 0 && this.currentVersionCode <= currentUpdateVersion && this.currentVersionCode == currentUpdateVersion) {
                this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AndVersionPresenter.this.mView.showNews(features);
                    }
                });
            }
            this.lastSessionVersion = this.currentVersionCode;
            editor.putInt("lastSessionVersion", this.lastSessionVersion);
            editor.apply();
        }
    }

    private String parseFeaturesContent(ResponseBody responseBody) throws IOException, JSONException {
        this.mJsonParseHelper.setAndVersionObject(new JSONObject(responseBody.string()));
        this.minSupportVersion = this.mJsonParseHelper.getMinSupportVersion();
        this.currentUpdateVersion = this.mJsonParseHelper.getCurrentVersion();
        ArrayList<String> whatsNew = this.mJsonParseHelper.getWhatsNew();
        StringBuilder features = new StringBuilder();
        if (whatsNew != null) {
            for (int i = 0; i < whatsNew.size(); ++i) {
                features.append("- ").append(whatsNew.get(i)).append("\n");
            }
        }
        return features.toString();
    }
}

