/*
 * Decompiled with CFR 0.152.
 */
package com.zingat.andversion;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.zingat.andversion.AndVersionContract;
import com.zingat.andversion.AndVersionPresenter;
import com.zingat.andversion.OnCompletedListener;
import com.zingat.andversion.R;
import java.io.IOException;

public class AndVersion
implements AndVersionContract.View {
    private Activity activity;
    private String uri;
    private MaterialDialog mDialog;
    private static AndVersion andVersion;
    private AndVersionPresenter mPresenter = new AndVersionPresenter();

    public static AndVersion getInstance() {
        if (andVersion == null) {
            andVersion = new AndVersion();
        }
        return andVersion;
    }

    public AndVersion setActivity(Activity activity) {
        this.activity = activity;
        this.init();
        return this;
    }

    private void init() {
        this.mPresenter.setActivity(this.activity);
        this.mPresenter.setPackageInfoForPresenter();
        this.mPresenter.setView(this);
    }

    public AndVersion setUri(String uri) {
        this.uri = uri;
        return this;
    }

    private AndVersion() {
    }

    public AndVersion checkForceUpdate(OnCompletedListener completedListener) {
        this.mPresenter.getForceUpdateInfoFromUrl(this.uri, completedListener);
        return this;
    }

    public AndVersion checkNews() {
        this.mPresenter.getVersionInfoFromUrl(this.uri);
        return this;
    }

    public void checkUpdate(@Nullable OnCompletedListener completedListener) {
        try {
            this.mPresenter.getJsonFromUrl(this.uri, completedListener);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeDialog() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    @Override
    public void showForceUpdateDialogs(String whatsNew, final String packageName) {
        this.mDialog = new MaterialDialog.Builder((Context)this.activity).cancelable(false).title(R.string.andversion_forceupdate_title).content((CharSequence)whatsNew).positiveText(R.string.andversion_ok).negativeText(R.string.andversion_exit_app).onNegative(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                AndVersion.this.activity.finish();
            }
        }).onPositive(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                AndVersion.this.mPresenter.sendUserToGooglePlay(packageName);
            }
        }).show();
    }

    @Override
    public void checkLastSessionVersion(String features, int currentUpdateVersion) {
        this.mPresenter.checkLastSessionVersion(features, currentUpdateVersion);
    }

    @Override
    public void checkNewsLastSessionVersion(String features, int currentUdateVersion) {
        this.mPresenter.checkNewsLastSessionVersion(features, currentUdateVersion);
    }

    @Override
    public void showNews(String features, final @Nullable OnCompletedListener completedListener) {
        this.mDialog = new MaterialDialog.Builder((Context)this.activity).cancelable(false).title(R.string.andversion_forceupdate_title).content((CharSequence)features).positiveText(R.string.andversion_ok).onPositive(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                if (completedListener != null) {
                    completedListener.onCompleted();
                }
            }
        }).show();
    }

    @Override
    public void showNews(String features) {
        this.showNews(features, null);
    }
}

