/*
 * Decompiled with CFR 0.152.
 */
package com.zingat.andversion;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.zingat.andversion.AndVersionContract;
import com.zingat.andversion.AndVersionPresenter;
import com.zingat.andversion.OnCompletedListener;
import java.io.IOException;
import java.util.HashMap;

public class AndVersion
implements AndVersionContract.View {
    private Activity activity;
    private String uri;
    private MaterialDialog mDialog;
    private static AndVersion andVersion;
    private AndVersionPresenter mPresenter = new AndVersionPresenter();

    public static AndVersion getInstance() {
        if (andVersion == null) {
            andVersion = new AndVersion();
        }
        return andVersion;
    }

    public AndVersion setActivity(Activity activity) {
        this.activity = activity;
        this.mPresenter.setPackageInfoForPresenter(activity);
        return this;
    }

    public AndVersion setUri(String uri) {
        this.uri = uri;
        return this;
    }

    private AndVersion() {
        this.mPresenter.setView(this);
    }

    public void checkUpdate(OnCompletedListener completedListener) {
        try {
            this.mPresenter.getJsonFromUrl(this.uri, completedListener);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public AndVersion checForceUpdate(OnCompletedListener completedListener) {
        this.mPresenter.getForceUpdateInfoFromUrl(this.uri, completedListener);
        return this;
    }

    public AndVersion checkNews() {
        this.mPresenter.getVersionInfoFromUrl(this.uri);
        return this;
    }

    public void closeDialog() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    @Override
    public void showForceUpdateDialogs(final String whatsNew, final String packageName) {
        final HashMap<String, String> stringValuesMap = this.mPresenter.getStringValues();
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AndVersion.this.mDialog = new MaterialDialog.Builder((Context)AndVersion.this.activity).cancelable(false).title((CharSequence)stringValuesMap.get("andversion_forceupdate_title")).content((CharSequence)whatsNew).positiveText((CharSequence)stringValuesMap.get("andversion_update")).negativeText((CharSequence)stringValuesMap.get("andversion_exit_app")).onNegative(new MaterialDialog.SingleButtonCallback(){

                    public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                        AndVersion.this.activity.finish();
                    }
                }).onPositive(new MaterialDialog.SingleButtonCallback(){

                    public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                        AndVersion.this.mPresenter.sendUserToGooglePlay(packageName);
                    }
                }).show();
            }
        });
    }

    @Override
    public void checkLastSessionVersion(String features, int currentUpdateVersion) {
        this.mPresenter.checkLastSessionVersion(this.activity, features, currentUpdateVersion);
    }

    @Override
    public void checkNewsLastSessionVersion(String features, int currentUdateVersion) {
        this.mPresenter.checkNewsLastSessionVersion(this.activity, features, currentUdateVersion);
    }

    @Override
    public void showUpdateFeatures(final String features, final OnCompletedListener completedListener) {
        final HashMap<String, String> stringValuesMap = this.mPresenter.getStringValues();
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AndVersion.this.mDialog = new MaterialDialog.Builder((Context)AndVersion.this.activity).cancelable(false).title((CharSequence)stringValuesMap.get("andversion_whatsnew_title")).content((CharSequence)features).positiveText((CharSequence)stringValuesMap.get("andversion_ok")).onPositive(new MaterialDialog.SingleButtonCallback(){

                    public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                        completedListener.onCompleted();
                    }
                }).show();
            }
        });
    }

    @Override
    public void showNews(final String features) {
        final HashMap<String, String> stringValuesMap = this.mPresenter.getStringValues();
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AndVersion.this.mDialog = new MaterialDialog.Builder((Context)AndVersion.this.activity).cancelable(false).title((CharSequence)stringValuesMap.get("andversion_whatsnew_title")).content((CharSequence)features).positiveText((CharSequence)stringValuesMap.get("andversion_ok")).show();
            }
        });
    }
}

