/*
 * Decompiled with CFR 0.152.
 */
package com.zingat.andversion;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.preference.PreferenceManager;
import com.zingat.andversion.AndVersionContract;
import com.zingat.andversion.JsonParseHelper;
import com.zingat.andversion.OnCompletedListener;
import com.zingat.andversion.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

public class AndVersionPresenter
implements AndVersionContract.Presenter {
    private AndVersionContract.View mView;
    private OkHttpClient mClient;
    private JsonParseHelper mJsonParseHelper;
    private int currentVersionCode;
    private int lastSessionVersion;
    private String packageName;
    private Activity activity;
    private OnCompletedListener mCompletedListener;

    @Inject
    AndVersionPresenter() {
    }

    @Inject
    void setClient(OkHttpClient client) {
        this.mClient = client;
    }

    @Inject
    void setJsonParseHelper(JsonParseHelper jsonParseHelper) {
        this.mJsonParseHelper = jsonParseHelper;
    }

    @Override
    public void setView(AndVersionContract.View view) {
        this.mView = view;
    }

    @Override
    public void setPackageInfoForPresenter(Activity activity) {
        try {
            this.activity = activity;
            PackageInfo packageInfo = this.activity.getPackageManager().getPackageInfo(activity.getPackageName(), 0);
            this.currentVersionCode = packageInfo.versionCode;
            this.packageName = packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void checkLastSessionVersion(Activity activity, String features, int currentUpdateVersion) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        this.lastSessionVersion = preferences.getInt("lastSessionVersion", 0);
        SharedPreferences.Editor editor = preferences.edit();
        if (this.lastSessionVersion != this.currentVersionCode) {
            if (this.lastSessionVersion != 0 && this.currentVersionCode <= currentUpdateVersion && this.currentVersionCode == currentUpdateVersion) {
                this.mView.showUpdateFeatures(features, this.mCompletedListener);
            } else {
                this.mCompletedListener.onCompleted();
            }
            this.lastSessionVersion = this.currentVersionCode;
            editor.putInt("lastSessionVersion", this.lastSessionVersion);
            editor.apply();
        } else {
            this.mCompletedListener.onCompleted();
        }
    }

    @Override
    public void sendUserToGooglePlay(String packageName) {
        try {
            this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packageName))));
        }
        catch (ActivityNotFoundException anfe) {
            this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + packageName))));
        }
    }

    @Override
    public void getJsonFromUrl(String url, final OnCompletedListener completedListener) throws IOException {
        this.mCompletedListener = completedListener;
        Request request = new Request.Builder().url(url).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                completedListener.onCompleted();
            }

            public void onResponse(Call call, Response response) throws IOException {
                block11: {
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        try {
                            AndVersionPresenter.this.mJsonParseHelper.setAndVersionObject(new JSONObject(responseBody.string()));
                            int minSupportVersion = AndVersionPresenter.this.mJsonParseHelper.getMinSupportVersion();
                            int currentUpdateVersion = AndVersionPresenter.this.mJsonParseHelper.getCurrentVersion();
                            ArrayList<String> whatsNew = AndVersionPresenter.this.mJsonParseHelper.getWhatsNew();
                            String features = "";
                            if (whatsNew != null) {
                                for (int i = 0; i < whatsNew.size(); ++i) {
                                    features = features + "- " + whatsNew.get(i) + "\n";
                                }
                            }
                            if (currentUpdateVersion != -1 && minSupportVersion != -1) {
                                if (AndVersionPresenter.this.currentVersionCode < minSupportVersion) {
                                    AndVersionPresenter.this.mView.showForceUpdateDialogs(features, AndVersionPresenter.this.packageName);
                                } else if (!features.equals("")) {
                                    AndVersionPresenter.this.mView.checkLastSessionVersion(features, currentUpdateVersion);
                                } else {
                                    completedListener.onCompleted();
                                }
                                break block11;
                            }
                            completedListener.onCompleted();
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            completedListener.onCompleted();
                        }
                    } else {
                        completedListener.onCompleted();
                    }
                }
            }
        });
    }

    @Override
    public HashMap<String, String> getStringValues() {
        HashMap<String, String> stringValuesMap = new HashMap<String, String>();
        String[] stringKeys = this.activity.getResources().getStringArray(R.array.string_keys);
        String[] stringValues = this.activity.getResources().getStringArray(R.array.string_values);
        for (int i = 0; i < stringKeys.length; ++i) {
            String stringValue;
            int identifier = this.activity.getResources().getIdentifier(stringKeys[i], "string", this.packageName);
            if (identifier != 0) {
                stringValue = this.activity.getResources().getString(identifier);
                stringValuesMap.put(stringKeys[i], stringValue);
                continue;
            }
            stringValue = stringValues[i];
            stringValuesMap.put(stringKeys[i], stringValue);
        }
        return stringValuesMap;
    }

    @Override
    public void getForceUpdateInfoFromUrl(String url, OnCompletedListener onCompletedListener) {
        this.mCompletedListener = onCompletedListener;
        Request request = new Request.Builder().url(url).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                AndVersionPresenter.this.mCompletedListener.onCompleted();
            }

            public void onResponse(Call call, Response response) throws IOException {
                block9: {
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        try {
                            AndVersionPresenter.this.mJsonParseHelper.setAndVersionObject(new JSONObject(responseBody.string()));
                            int minSupportVersion = AndVersionPresenter.this.mJsonParseHelper.getMinSupportVersion();
                            ArrayList<String> whatsNew = AndVersionPresenter.this.mJsonParseHelper.getWhatsNew();
                            String features = "";
                            if (whatsNew != null) {
                                for (int i = 0; i < whatsNew.size(); ++i) {
                                    features = features + "- " + whatsNew.get(i) + "\n";
                                }
                            }
                            if (minSupportVersion != -1) {
                                if (AndVersionPresenter.this.currentVersionCode < minSupportVersion) {
                                    AndVersionPresenter.this.mView.showForceUpdateDialogs(features, AndVersionPresenter.this.packageName);
                                } else {
                                    AndVersionPresenter.this.mCompletedListener.onCompleted();
                                }
                                break block9;
                            }
                            AndVersionPresenter.this.mCompletedListener.onCompleted();
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            AndVersionPresenter.this.mCompletedListener.onCompleted();
                        }
                    } else {
                        AndVersionPresenter.this.mCompletedListener.onCompleted();
                    }
                }
            }
        });
    }

    @Override
    public void getVersionInfoFromUrl(String url) {
        Request request = new Request.Builder().url(url).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    try {
                        AndVersionPresenter.this.mJsonParseHelper.setAndVersionObject(new JSONObject(responseBody.string()));
                        int currentUpdateVersion = AndVersionPresenter.this.mJsonParseHelper.getCurrentVersion();
                        ArrayList<String> whatsNew = AndVersionPresenter.this.mJsonParseHelper.getWhatsNew();
                        String features = "";
                        if (whatsNew != null) {
                            for (int i = 0; i < whatsNew.size(); ++i) {
                                features = features + "- " + whatsNew.get(i) + "\n";
                            }
                        }
                        if (currentUpdateVersion != -1 && !features.equals("")) {
                            AndVersionPresenter.this.mView.checkNewsLastSessionVersion(features, currentUpdateVersion);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void checkNewsLastSessionVersion(Activity activity, String features, int currentUpdateVersion) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        this.lastSessionVersion = preferences.getInt("lastSessionVersion", 0);
        SharedPreferences.Editor editor = preferences.edit();
        if (this.lastSessionVersion != this.currentVersionCode) {
            if (this.lastSessionVersion != 0 && this.currentVersionCode <= currentUpdateVersion && this.currentVersionCode == currentUpdateVersion) {
                this.mView.showNews(features);
            }
            this.lastSessionVersion = this.currentVersionCode;
            editor.putInt("lastSessionVersion", this.lastSessionVersion);
            editor.apply();
        }
    }
}

