/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.stat;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.zhuge.analysis.stat.ZhugeSDK;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class CodeLessConfig {
    private static final Object sInstanceLock = new Object();
    private static CodeLessConfig sInstance;
    private static boolean DEBUG;
    private static boolean mDisableGestureBindingUI;
    public static final int UI_FEATURES_MIN_API = 16;
    private Context mContext;

    public void track(String eventName, JSONObject pro) {
        ZhugeSDK.getInstance().track(this.mContext, eventName, pro);
    }

    CodeLessConfig(Context context) {
        this.mContext = context;
    }

    public static String getEventUrl() {
        return "https://api.zhugeio.com/v1/events/codeless/appkey/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeLessConfig getInstance(Context context) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (null == sInstance) {
                Context appContext = context.getApplicationContext();
                sInstance = new CodeLessConfig(appContext);
            }
            return sInstance;
        }
    }

    public Map<String, String> getDeviceInfo() {
        HashMap<String, String> deviceInfo = new HashMap<String, String>();
        deviceInfo.put("android_lib_version", "v2.2.0");
        deviceInfo.put("android_os", "Android");
        deviceInfo.put("os_version", Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE);
        deviceInfo.put("android_manufacturer", Build.MANUFACTURER == null ? "UNKNOWN" : Build.MANUFACTURER);
        deviceInfo.put("android_brand", Build.BRAND == null ? "UNKNOWN" : Build.BRAND);
        deviceInfo.put("android_model", Build.MODEL == null ? "UNKNOWN" : Build.MODEL);
        try {
            PackageManager manager = this.mContext.getPackageManager();
            PackageInfo info = manager.getPackageInfo(this.mContext.getPackageName(), 0);
            deviceInfo.put("app_version", info.versionName);
            deviceInfo.put("app_version_code", Integer.toString(info.versionCode));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"codeLess", (String)"Exception getting app version name", (Throwable)e);
        }
        return Collections.unmodifiableMap(deviceInfo);
    }

    static void openDebug() {
        DEBUG = true;
    }

    public static boolean getDisableGestureBindingUI() {
        return mDisableGestureBindingUI;
    }

    static void openGestureBindingUI() {
        mDisableGestureBindingUI = false;
    }

    public static String getEditorUrl() {
        return "ws://codeless.zhugeio.com/connect?ctype=client&platform=android&appkey=";
    }

    public void debug(String message) {
        if (DEBUG) {
            Log.e((String)"Zhuge.Codeless", (String)message);
        }
    }

    public static boolean isDEBUG() {
        return DEBUG;
    }

    static {
        DEBUG = false;
        mDisableGestureBindingUI = true;
    }
}

