/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.java_websocket;

import com.zhuge.analysis.java_websocket.WebSocket;
import com.zhuge.analysis.java_websocket.WebSocketListener;
import com.zhuge.analysis.java_websocket.drafts.Draft;
import com.zhuge.analysis.java_websocket.exceptions.InvalidDataException;
import com.zhuge.analysis.java_websocket.exceptions.InvalidHandshakeException;
import com.zhuge.analysis.java_websocket.framing.Framedata;
import com.zhuge.analysis.java_websocket.framing.FramedataImpl1;
import com.zhuge.analysis.java_websocket.handshake.ClientHandshake;
import com.zhuge.analysis.java_websocket.handshake.HandshakeImpl1Server;
import com.zhuge.analysis.java_websocket.handshake.ServerHandshake;
import com.zhuge.analysis.java_websocket.handshake.ServerHandshakeBuilder;
import java.net.InetSocketAddress;

public abstract class WebSocketAdapter
implements WebSocketListener {
    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketMessageFragment(WebSocket conn, Framedata frame) {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        FramedataImpl1 resp = new FramedataImpl1(f);
        resp.setOptcode(Framedata.Opcode.PONG);
        conn.sendFrame(resp);
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }

    @Override
    public String getFlashPolicy(WebSocket conn) throws InvalidDataException {
        InetSocketAddress adr = conn.getLocalSocketAddress();
        if (null == adr) {
            throw new InvalidHandshakeException("socket not bound");
        }
        StringBuffer sb = new StringBuffer(90);
        sb.append("<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"");
        sb.append(adr.getPort());
        sb.append("\" /></cross-domain-policy>\u0000");
        return sb.toString();
    }
}

