/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.viewSpider;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

class ShakeGesture
implements SensorEventListener {
    private SensorManager sensorManager;
    private Sensor sensor;
    protected long oldTime;
    private static float[] x = new float[10];
    private static float[] y = new float[10];
    private static float[] z = new float[10];
    private static final int START_LEN = 10;
    private static int count = 0;
    private float var_x = 0.0f;
    private float var_y = 0.0f;
    private float var_z = 0.0f;
    private int state = 0;
    private static final int STATE0 = 0;
    private static final int STATE1 = 1;
    private static final int STATE2 = 2;
    private static float old_x = 0.0f;
    private static float old_y = 0.0f;
    private static float old_z = 0.0f;
    private static int trigger = 0;
    private OnShakeGestureListener mListener;

    ShakeGesture(OnShakeGestureListener listener) {
        this.mListener = listener;
    }

    public void register(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.sensor = this.sensorManager.getDefaultSensor(1);
        this.sensorManager.registerListener((SensorEventListener)this, this.sensor, 0);
    }

    public void unRegister() {
        this.sensorManager.unregisterListener((SensorEventListener)this, this.sensor);
    }

    private void calculate_var() {
        int i;
        float mean_x = 0.0f;
        float mean_y = 0.0f;
        float mean_z = 0.0f;
        for (i = 0; i < 10; ++i) {
            mean_x += x[i];
            mean_y += y[i];
            mean_z += z[i];
        }
        mean_x /= 10.0f;
        mean_y /= 10.0f;
        mean_z /= 10.0f;
        for (i = 0; i < 10; ++i) {
            this.var_x += (x[i] - mean_x) * (x[i] - mean_x);
            this.var_y += (y[i] - mean_y) * (y[i] - mean_y);
            this.var_z += (z[i] - mean_z) * (z[i] - mean_z);
        }
        this.var_x = (float)Math.sqrt(this.var_x);
        this.var_y = (float)Math.sqrt(this.var_y);
        this.var_z = (float)Math.sqrt(this.var_z);
    }

    public void onSensorChanged(SensorEvent event) {
        long newTime = System.currentTimeMillis();
        if (newTime - this.oldTime > 100L) {
            long diffTime = newTime - this.oldTime;
            this.oldTime = newTime;
            float new_x = event.values[0];
            float new_y = event.values[1];
            float new_z = event.values[2];
            float speed = Math.abs(new_x + new_y + new_z - old_x - old_y - old_z) / (float)diffTime * 10000.0f;
            old_x = new_x;
            old_y = new_y;
            old_z = new_z;
            ShakeGesture.x[ShakeGesture.count] = event.values[0];
            ShakeGesture.y[ShakeGesture.count] = event.values[1];
            ShakeGesture.z[ShakeGesture.count] = event.values[2];
            if (++count >= 10) {
                count = 0;
            }
            this.calculate_var();
            switch (this.state) {
                case 0: {
                    if (!((double)this.var_x > 2.5) || !(this.var_y > 5.0f) || !(this.var_z > 15.0f)) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.state = 2;
                    break;
                }
                case 2: {
                    trigger = this.var_z > 18.0f && speed < 4000.0f ? ++trigger : 0;
                    if (trigger < 14) break;
                    this.mListener.onShakeGesture();
                    trigger = 0;
                    this.state = 0;
                }
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    static interface OnShakeGestureListener {
        public void onShakeGesture();
    }
}

