/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.stat;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.zhuge.analysis.stat.ZhugeSDK;
import com.zhuge.analysis.util.AccountInfoUtils;
import com.zhuge.analysis.util.ActivityServicesUtils;
import com.zhuge.analysis.util.ConnectivityUtils;
import com.zhuge.analysis.util.DeviceInfoUtils;
import com.zhuge.analysis.util.ManifestUtils;
import com.zhuge.analysis.util.PackageInfosUtils;
import com.zhuge.analysis.util.TelephonyUtils;
import com.zhuge.analysis.util.Utils;
import com.zhuge.analysis.util.WifiInfoUtils;
import com.zhuge.analysis.util.ZGJSONObject;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ZhugeConfig {
    static final String SDK_V = "v2.2.0";
    private static final String TAG = "ZhugeSDK";
    private static final String CUID_KEY = "cuid";
    public static final String API_PATH = "https://apipool.zhugeio.com/APIPOOL/";
    private SharedPreferences globalSP;
    private static final String LAST_SESSION = "ZhugeLastSession";
    private static final String TOTALDAY_KEY = "Today_total";
    private final String config_info = "info_ts";
    private final String config_account = "acs_ts";
    private final String config_pkg = "pkg_ts";
    static boolean debug = false;
    boolean logEnable = false;
    private boolean disable_accounts = false;
    private boolean disable_phonenum = false;
    private boolean disable_applist = false;
    private String did = null;
    private String imei = null;
    private String mac = null;
    private String appkey = "";
    private String appChannel = "";
    private String appName = "";
    private String appVersion = "";
    private static final int session_exceed = 30;
    long preSessionEnd = -1L;
    private long session_time;
    private String cr = "";
    private int net = -100;
    private int mnet = -100;
    static final int MSG_RECV = 0;
    static final int MSG_READ = 1;

    ZhugeConfig() {
    }

    int getUpload_per_day() {
        return 500;
    }

    String getTotaldayKey() {
        return TOTALDAY_KEY;
    }

    String getConfig_Cuid() {
        return CUID_KEY;
    }

    String getConfig_pkg() {
        return "pkg_ts";
    }

    String getConfig_info() {
        return "info_ts";
    }

    String getConfig_account() {
        return "acs_ts";
    }

    String getLastSession() {
        return LAST_SESSION;
    }

    SharedPreferences getGlobalSP() {
        return this.globalSP;
    }

    long getSessionTime() {
        return this.session_time;
    }

    static short getPeriod_time() {
        if (debug) {
            return 1;
        }
        return 10;
    }

    String getAppVersion() {
        return this.appVersion;
    }

    String getAppChannel() {
        return this.appChannel;
    }

    void setAppChannel(String appChannel) {
        this.appChannel = appChannel;
    }

    String getAppkey() {
        return this.appkey;
    }

    String getDid() {
        return this.did;
    }

    void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    void disableAccounts() {
        this.disable_accounts = true;
    }

    void disablePhonenum() {
        this.disable_phonenum = true;
    }

    void disableAppList() {
        this.disable_applist = true;
    }

    public void debug(String message) {
        if (this.logEnable) {
            Log.e((String)TAG, (String)message);
        }
    }

    boolean checkSelf(String key, String channel) {
        long interval = Math.abs(System.currentTimeMillis() - this.preSessionEnd);
        this.debug("\u95f4\u9694\u65f6\u957f\uff1a" + interval / 1000L + "\n" + "channel = " + channel);
        return interval / 1000L < 30L || key.equals("null") || channel.equals("null");
    }

    void initDevInfo(Context context) {
        String[] info = ManifestUtils.getDevInfo(context);
        this.setAppkey(info[0]);
        this.setAppChannel(info[1]);
    }

    void initGlobalSettingFile(Context context) {
        String myProcessName = new ActivityServicesUtils(context).getMyProcessName();
        String myGlobalSPName = myProcessName + this.appkey;
        this.globalSP = context.getSharedPreferences(myGlobalSPName, 0);
    }

    void initDeviceInfo(Context context) {
        String mac = null;
        String imei = null;
        try {
            TelephonyManager tm = new TelephonyUtils(context).getTM();
            imei = tm.getDeviceId();
            this.cr = tm.getSimOperator();
            this.mnet = tm.getNetworkType();
        }
        catch (Exception e) {
            this.debug("\u83b7\u53d6IMEI\u548c\u8fd0\u8425\u5546\u5931\u8d25\uff0c\u68c0\u67e5\u6743\u9650READ_PHONE_STATE");
        }
        try {
            mac = new WifiInfoUtils(context).getMacAddress();
        }
        catch (Exception e) {
            this.debug("\u83b7\u53d6MAC\u5931\u8d25\uff0c\u68c0\u67e5\u6743\u9650ACCESS_WIFI_STATE");
        }
        if (mac == null && imei == null) {
            return;
        }
        try {
            this.mac = mac;
            this.imei = imei;
            this.did = Utils.md5(imei + mac);
        }
        catch (Exception e) {
            this.debug("\u8ba1\u7b97\u7528\u6237\u552f\u4e00ID\u5931\u8d25");
        }
        try {
            this.net = new ConnectivityUtils(context).getNetworkType();
        }
        catch (Exception e) {
            this.debug("\u83b7\u53d6\u7f51\u7edc\u7c7b\u578b\u5931\u8d25\uff0c\u68c0\u67e5\u6743\u9650ACCESS_NETWORK_STATE\uff0c\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u72b6\u6001");
        }
    }

    void initAppinfo(Context context) {
        try {
            PackageInfo devInfo = ManifestUtils.getAppInfo(context);
            if (devInfo != null) {
                this.appName = devInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
                this.appVersion = devInfo.versionName;
            } else {
                this.debug("\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u9519\u8bef");
            }
        }
        catch (Exception e) {
            this.debug("\u521d\u59cb\u5316\u5e94\u7528\u4fe1\u606f\u9519\u8bef");
        }
    }

    void debugInitInfo(Context context) {
        if (this.logEnable) {
            StringBuilder info = new StringBuilder();
            info.append("appKey\uff1a" + this.appkey + "\n");
            info.append("\u5b9e\u65f6\u8c03\u8bd5\uff1a" + debug + "\n");
            info.append("\u7981\u6b62\u83b7\u53d6\u624b\u673a\u53f7\uff1a" + this.disable_phonenum + "\n");
            info.append("\u7981\u6b62\u83b7\u53d6\u5e94\u7528\u5217\u8868\uff1a" + this.disable_applist + "\n");
            info.append("\u7981\u6b62\u83b7\u53d6\u7528\u6237\u8d26\u53f7\u4fe1\u606f\uff1a" + this.disable_accounts + "\n");
            info.append("\u6e20\u9053\u540d\u79f0\uff1a" + this.appChannel + "\n");
            info.append("\u5e94\u7528\u540d\u79f0\uff1a" + this.appName + "\n");
            info.append("\u5e94\u7528\u7248\u672c\uff1a" + this.appVersion + "\n");
            info.append("\u7528\u6237\u6807\u8bc6\uff1a" + this.did + "\n");
            info.append("\u8fd0\u8425\u5546\u4ee3\u53f7\uff1a" + this.cr + "\n");
            info.append("\u7f51\u7edc\u8fde\u63a5\u7c7b\u578b\uff1a" + this.net + "\n");
            info.append("\u79fb\u52a8\u7f51\u7edc\u7c7b\u578b\uff1a" + this.mnet + "\n");
            info.append("\u7cfb\u7edf\u7248\u672c\uff1a" + DeviceInfoUtils.getOSVersion() + "\n");
            info.append("\u624b\u673a\u578b\u53f7\uff1a" + DeviceInfoUtils.getDevice() + "\n");
            info.append("\u7cfb\u7edf\u5206\u8fa8\u7387\uff1a" + DeviceInfoUtils.getResolution(context) + "\n");
            this.debug(info.toString());
        }
    }

    ZGJSONObject completeLastSession(int state, int eventCount) {
        String info = this.globalSP.getString(LAST_SESSION, "");
        if (info.equals("")) {
            return null;
        }
        String[] infos = info.split("\\|");
        long sid = Long.valueOf(infos[0]);
        long ts = Long.valueOf(infos[1]);
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            infoObject.put("et", "se");
            infoObject.put("sr", state);
            infoObject.put("ec", eventCount);
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(ts));
            infoObject.put("sid", Utils.formatTime(sid));
            infoObject.put("dr", Utils.formatTime(ts - sid));
        }
        catch (JSONException e) {
            this.debug("\u6570\u636e\u7ec4\u88c5\u51fa\u9519" + e.getMessage());
        }
        return infoObject;
    }

    ZGJSONObject startSession() {
        long now_t;
        this.session_time = now_t = System.currentTimeMillis();
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            infoObject.put("et", "ss");
            infoObject.put("an", this.appName);
            infoObject.put("vn", this.appVersion);
            infoObject.put("ov", DeviceInfoUtils.getOSVersion());
            infoObject.put("cr", this.cr);
            infoObject.put("net", this.net);
            infoObject.put("mnet", this.mnet);
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            infoObject.put("sid", Utils.formatTime(this.session_time));
        }
        catch (JSONException e) {
            this.debug("\u6570\u636e\u7ec4\u88c5\u51fa\u9519" + e.getMessage());
        }
        return infoObject;
    }

    ZGJSONObject initInfo(Context context) {
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            long info_ts = this.globalSP.getLong("info_ts", -1L);
            long now_t = System.currentTimeMillis();
            if (info_ts != -1L && now_t / 86400000L - info_ts / 86400000L <= 7L) {
                return null;
            }
            infoObject.put("et", "info");
            infoObject.put("an", this.appName);
            infoObject.put("vn", this.appVersion);
            infoObject.put("ov", DeviceInfoUtils.getOSVersion());
            infoObject.put("rs", DeviceInfoUtils.getResolution(context));
            infoObject.put("dv", DeviceInfoUtils.getDevice());
            infoObject.put("maker", DeviceInfoUtils.getManfacturer());
            infoObject.put("br", DeviceInfoUtils.getBrand());
            infoObject.put("cr", this.cr);
            infoObject.put("net", this.net);
            infoObject.put("imei", this.imei);
            infoObject.put("mac", this.mac);
            infoObject.put("cn", this.appChannel);
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            infoObject.put("sid", Utils.formatTime(this.session_time));
            infoObject.put("mb", this.disable_phonenum ? "" : new TelephonyUtils(context).getPhoneNumber());
        }
        catch (Exception e) {
            this.debug("\u521d\u59cb\u5316\u4e2a\u4eba\u4fe1\u606f\u51fa\u9519" + e.getMessage());
        }
        return infoObject;
    }

    ZGJSONObject initAcs(Context context) {
        if (this.disable_accounts) {
            return null;
        }
        try {
            long info_ts = this.globalSP.getLong("acs_ts", -1L);
            long now_t = System.currentTimeMillis();
            if (info_ts == -1L || now_t / 86400000L - info_ts / 86400000L > 14L) {
                ZGJSONObject infoObject = new ZGJSONObject();
                infoObject.put("et", "acs");
                infoObject.put("list", new AccountInfoUtils(context).getAccountInfos());
                infoObject.put("tz", "" + Utils.getTimeZone());
                infoObject.put("ts", Utils.formatTime(now_t));
                infoObject.put("sid", Utils.formatTime(this.session_time));
                return infoObject;
            }
        }
        catch (Exception e) {
            this.debug("\u6ca1\u6709\u6dfb\u52a0\u6743\u9650GET_ACCOUNTS");
        }
        return null;
    }

    ZGJSONObject initApplist(Context context) {
        if (this.disable_applist) {
            return null;
        }
        try {
            long info_ts = this.globalSP.getLong("pkg_ts", -1L);
            long now_t = System.currentTimeMillis();
            if (info_ts == -1L || now_t / 86400000L - info_ts / 86400000L > 14L) {
                ZGJSONObject infoObject = new ZGJSONObject();
                infoObject.put("et", "pkgs");
                infoObject.put("list", new PackageInfosUtils(context).getUserAppInfos());
                infoObject.put("tz", "" + Utils.getTimeZone());
                infoObject.put("ts", Utils.formatTime(now_t));
                infoObject.put("sid", Utils.formatTime(this.session_time));
                return infoObject;
            }
        }
        catch (Exception e) {
            this.debug("\u83b7\u53d6\u5e94\u7528\u5217\u8868\u51fa\u9519\u3002" + e.getMessage());
        }
        return null;
    }

    ZGJSONObject customEvent(String event_name, JSONObject kv) {
        long now_t = System.currentTimeMillis();
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            infoObject.put("et", "cus");
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            infoObject.put("eid", event_name);
            if (null != kv) {
                infoObject.put("pr", kv);
            }
            infoObject.put("sid", Utils.formatTime(this.session_time));
        }
        catch (JSONException e) {
            this.debug("\u6570\u636e\u7ec4\u88c5\u51fa\u9519" + e.getMessage());
        }
        return infoObject;
    }

    ZGJSONObject identifyPerson(String uid, JSONObject kv) {
        long now_t = System.currentTimeMillis();
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            infoObject.put("et", "idf");
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            infoObject.put(CUID_KEY, uid);
            infoObject.put("pr", kv);
            infoObject.put("sid", Utils.formatTime(this.session_time));
        }
        catch (JSONException e) {
            this.debug("\u6570\u636e\u7ec4\u88c5\u51fa\u9519" + e.getMessage());
        }
        return infoObject;
    }

    JSONObject wrapData(String events) {
        try {
            String cuid;
            JSONObject postData = new JSONObject();
            postData.put("ak", (Object)this.appkey);
            postData.put("sdkv", (Object)SDK_V);
            postData.put("sdk", (Object)"and");
            postData.put("did", (Object)this.did);
            postData.put("cn", (Object)this.appChannel);
            if (debug) {
                postData.put("debug", 1);
            }
            if ((cuid = this.globalSP.getString(CUID_KEY, null)) != null) {
                postData.put(CUID_KEY, (Object)cuid);
            }
            long now_t = System.currentTimeMillis();
            postData.put("ts", (Object)Utils.formatTime(now_t));
            postData.put("type", (Object)"statis");
            postData.put("data", (Object)new JSONArray(events));
            return postData;
        }
        catch (Exception e) {
            this.debug("\u6570\u636e\u7ec4\u88c5\u51fa\u9519" + e.getMessage());
            return null;
        }
    }

    ZGJSONObject channelData(String chan, String userId) {
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "_usermap_");
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            JSONObject ch = new JSONObject();
            ch.put("channel", (Object)chan);
            ch.put("user_id", (Object)userId);
            infoObject.put("pr", ch);
            return infoObject;
        }
        catch (JSONException e) {
            this.debug("\u6570\u636e\u7ec4\u88c5\u51fa\u9519" + e.getMessage());
            return null;
        }
    }

    ZGJSONObject parseMid(int msgState, ZhugeSDK.PushChannel channel, Object t) {
        String mid = "";
        try {
            switch (channel) {
                case BAIDU: {
                    String baidu = (String)t;
                    if (null == baidu) {
                        return null;
                    }
                    JSONObject js = new JSONObject(baidu);
                    mid = js.getString("mid");
                    break;
                }
                case GETUI: {
                    break;
                }
                case JPUSH: {
                    if (t instanceof String) {
                        String jpush = (String)t;
                        JSONObject js = new JSONObject(jpush);
                        mid = js.getString("mid");
                        break;
                    }
                    if (!(t instanceof JSONObject)) break;
                    JSONObject js = (JSONObject)t;
                    mid = js.getString("mid");
                    break;
                }
                case UMENG: {
                    JSONObject js = (JSONObject)t;
                    JSONObject midJson = js.getJSONObject("extra");
                    mid = midJson.getString("mid");
                    break;
                }
                case XIAOMI: {
                    if (!(t instanceof Map)) break;
                    Map map = (Map)t;
                    mid = (String)map.get("mid");
                    break;
                }
                case XINGE: {
                    if (!(t instanceof String)) break;
                    String xinge = (String)t;
                    JSONObject js = new JSONObject(xinge);
                    mid = js.getString("mid");
                }
            }
        }
        catch (ClassCastException e) {
            this.debug("Object\u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        catch (JSONException e) {
            this.debug("json\u8f6c\u6362\u51fa\u9519" + e.getMessage());
        }
        return this.dealMid(mid, channel.toString(), msgState);
    }

    private ZGJSONObject dealMid(String mid, String chan, int msgState) {
        if (null == mid || "".equals(mid) || "null".equals(mid) || mid.length() < 1) {
            return null;
        }
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            switch (msgState) {
                case 0: {
                    infoObject.put("et", "_msgrecv_");
                    break;
                }
                case 1: {
                    infoObject.put("et", "_msgread_");
                    break;
                }
                default: {
                    return null;
                }
            }
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            JSONObject ch = new JSONObject();
            ch.put("channel", (Object)chan);
            ch.put("mid", (Object)mid);
            infoObject.put("pr", ch);
            return infoObject;
        }
        catch (Exception e) {
            this.debug("\u901a\u77e5\u4e0a\u4f20\u9519\u8bef" + e.getMessage());
            return null;
        }
    }
}

